/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.primitive.sort;

import com.cognos.xqe.util.primitive.CompactIntArrayList;
import com.cognos.xqe.util.primitive.sort.ArraySortUtility;
import com.cognos.xqe.util.primitive.sort.CompactIntArrayListDoubleArrayInsertionSort;
import com.cognos.xqe.util.primitive.sort.CompactIntArrayListDoubleArraySort;
import java.util.Random;

public class CompactIntArrayListDoubleArrayQuickSort
extends CompactIntArrayListDoubleArraySort {
    protected static final int SMALL_ARRAY_SIZE_DEFAULT = 16;
    private int smallArraySize = 16;
    private boolean isInsertionSortRequired = false;
    private Random random = new Random(0L);

    protected CompactIntArrayListDoubleArrayQuickSort(CompactIntArrayList bigIntList, double[] theDoubleArray, int theSmallArraySize) {
        super(bigIntList, theDoubleArray);
        this.smallArraySize = theSmallArraySize;
    }

    protected boolean isInsertionSortRequired() {
        return this.isInsertionSortRequired;
    }

    protected void sort(int leftIndex, int rightIndex) {
        if (rightIndex <= leftIndex) {
            return;
        }
        if (rightIndex - leftIndex + 1 <= this.smallArraySize) {
            this.isInsertionSortRequired = true;
            return;
        }
        int partitionIndex = leftIndex + this.random.nextInt(rightIndex - leftIndex + 1);
        int[] partitionValue = this.compactList.get(partitionIndex);
        this.swap(partitionIndex, rightIndex);
        int currentLeftIndex = leftIndex - 1;
        int currentRightIndex = rightIndex;
        int equalLeftIndex = leftIndex - 1;
        int equalRightIndex = rightIndex;
        int lastEqualRightIndex = rightIndex - 1;
        while (true) {
            if (this.compactList.compare(++currentLeftIndex, partitionValue) < 0) {
                continue;
            }
            while (this.compactList.compare(--currentRightIndex, partitionValue) > 0 && currentRightIndex != leftIndex) {
            }
            if (currentLeftIndex >= currentRightIndex) break;
            this.swap(currentLeftIndex, currentRightIndex);
            if (this.compactList.compare(currentLeftIndex, partitionValue) == 0) {
                this.swap(++equalLeftIndex, currentLeftIndex);
            }
            if (this.compactList.compare(currentRightIndex, partitionValue) != 0) continue;
            this.swap(currentRightIndex, --equalRightIndex);
        }
        if (this.compactList.compare(currentLeftIndex, partitionValue) == 0) {
            if (currentLeftIndex != rightIndex) {
                lastEqualRightIndex = rightIndex;
                if (currentLeftIndex == equalRightIndex) {
                    ++equalRightIndex;
                }
            }
        } else {
            this.swap(currentLeftIndex, rightIndex);
        }
        currentRightIndex = currentLeftIndex - 1;
        int currentEqualIndex = leftIndex;
        while (currentEqualIndex <= equalLeftIndex) {
            this.swap(currentEqualIndex, currentRightIndex);
            ++currentEqualIndex;
            --currentRightIndex;
        }
        ++currentLeftIndex;
        currentEqualIndex = lastEqualRightIndex;
        while (currentEqualIndex >= equalRightIndex) {
            this.swap(currentLeftIndex, currentEqualIndex);
            --currentEqualIndex;
            ++currentLeftIndex;
        }
        this.sort(leftIndex, currentRightIndex);
        this.sort(currentLeftIndex, rightIndex);
    }

    public static void sort(CompactIntArrayList bigIntList, double[] doubleArray) {
        CompactIntArrayListDoubleArrayQuickSort.sort(bigIntList, doubleArray, 16);
    }

    public static void sort(CompactIntArrayList bigIntList, double[] doubleArray, int smallArraySize) {
        ArraySortUtility.throwExceptionIfInvalid(bigIntList, doubleArray);
        if (!ArraySortUtility.isSortRequired(bigIntList)) {
            return;
        }
        CompactIntArrayListDoubleArrayQuickSort quickSort = new CompactIntArrayListDoubleArrayQuickSort(bigIntList, doubleArray, smallArraySize);
        quickSort.sort(0, bigIntList.size() - 1);
        if (quickSort.isInsertionSortRequired()) {
            CompactIntArrayListDoubleArrayInsertionSort.sort(bigIntList, doubleArray);
        }
    }
}

