/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.pushdownQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5FilterExpression;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.dmr.DMRPushdownQueryGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Stack;

public class DMRCustomValueRefiner {
    public static final String PUSHDOWNQUERYNAME_PREFIX = "XQE_PUSHDOWNQUERY";
    public static final String STR_MEASURE_INFO = "measureInfo";
    private static final String PROP_DATA_ITEM_NAME_TO_QUERY = "dataItemNameToQuery";
    private static final String PROP_MULTIPLE_MEASURES = "multipleMeasures";
    private static final String STR_NONE = "none";
    private V5QuerySet querySet = null;
    private List<MeasureInfo> measureInfoList = null;
    private Stack<MeasureInfo> measureInfoStack = null;
    private boolean factDriven = false;
    protected PlanningEnvironment environment;
    protected XQENodeFactory nodeFactory;
    protected Locale expressionLocale = null;

    public DMRCustomValueRefiner(V5QuerySet inputQuerySet, PlanningEnvironment env, boolean b) {
        this.querySet = inputQuerySet;
        this.measureInfoList = new ArrayList<MeasureInfo>();
        this.measureInfoStack = new Stack();
        this.environment = env;
        this.nodeFactory = this.environment.getNodeFactory();
        this.factDriven = b;
        String sLc = (String)this.querySet.getPropertyValue("expressionLocale");
        if (sLc != null || !sLc.isEmpty()) {
            this.expressionLocale = LocaleConverter.strToLocale(sLc);
        }
    }

    protected void addChildToParent(IXQEQueryNode parent, IXQEQueryNode child) {
        if (!this.factDriven) {
            parent.addChildNonIndexed(child);
        } else {
            parent.addChild(child);
        }
    }

    public void refine() {
        if (this.getMeasureInfoList().size() < 2) {
            return;
        }
        if (this.hasDifferentContexts()) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedDMRSubQuery);
        }
        List<V5Query> queryList = DMRPushdownQueryGenerator.getOrderedQueryList(this.querySet);
        int queryListSize = queryList.size();
        V5Query innerQuery = queryList.get(0);
        HashMap<MeasureInfo, V5Query> measureToQuery = new HashMap<MeasureInfo, V5Query>();
        HashMap dataItemNameToQuery = new HashMap();
        innerQuery.setPropertyValue(PROP_DATA_ITEM_NAME_TO_QUERY, dataItemNameToQuery);
        DMRPushdownQueryGenerator g = new DMRPushdownQueryGenerator(this.environment, this.factDriven);
        for (MeasureInfo mi : this.getMeasureInfoList()) {
            V5Query newQuery = g.createPushdownQuery(this.querySet, "PushdownQuery" + queryListSize++);
            newQuery.setPropertyValue(STR_MEASURE_INFO, mi);
            measureToQuery.put(mi, newQuery);
            this.querySet.addChild(newQuery, this.querySet.getNumberChildren() - 1);
            this.copyDataItemsAndFilters(innerQuery, newQuery, measureToQuery);
        }
        this.updateInnerQuery(innerQuery, measureToQuery);
    }

    private void updateInnerQuery(V5Query innerQuery, HashMap<MeasureInfo, V5Query> measureToQuery) {
        IXQEQueryNode[] dfs;
        HashMap dataItemNameToQuery = (HashMap)innerQuery.getPropertyValue(PROP_DATA_ITEM_NAME_TO_QUERY);
        String queryRefName = measureToQuery.get(this.measureInfoList.get(0)).getV5QueryName();
        ArrayList<V5DataItem> groupingColumns = new ArrayList<V5DataItem>();
        IXQEQueryNode[] dis1 = innerQuery.getV5Selection().getChildren();
        ArrayList<V5DataItem> dataItemsToBeRemoved = new ArrayList<V5DataItem>();
        for (IXQEQueryNode di1 : dis1) {
            V5DataItem dataItem = (V5DataItem)di1;
            String aggregateName = dataItem.getAggregateProperty();
            if (aggregateName != null && dataItem.getAggregateProperty().equals(STR_NONE)) {
                String exprStr = UniqueNameGenerator.createUniqueName(queryRefName, dataItem.getNameProperty());
                ((V5Expression)dataItem.getChild(0)).setExpression(exprStr);
                groupingColumns.add(dataItem);
                continue;
            }
            List mixedMeasures = (List)dataItem.getPropertyValue(PROP_MULTIPLE_MEASURES);
            if (dataItemNameToQuery.get(dataItem.getNameProperty()) != null && mixedMeasures == null) {
                dataItemsToBeRemoved.add(dataItem);
                continue;
            }
            this.updateQueryNameInQueryRefItems(dataItem, dataItemNameToQuery);
        }
        V5Selection selection = innerQuery.getV5Selection();
        for (V5DataItem di : dataItemsToBeRemoved) {
            selection.detachChild(di);
        }
        for (IXQEQueryNode df : dfs = innerQuery.getChildrenOfType(101008)) {
            innerQuery.detachChild(df);
        }
        this.createFiltersToJoinQueries(innerQuery, groupingColumns);
    }

    private void createFiltersToJoinQueries(V5Query innerQuery, List<V5DataItem> groupingColumns) {
        IXQEQueryNode[] queries = this.querySet.getChildrenOfTypeOrdered(101006);
        HashSet<String> queryRefs = new HashSet<String>();
        for (int i = 2; i < queries.length - 1; ++i) {
            V5Query leftQuery = (V5Query)queries[i];
            V5Query rightQuery = (V5Query)queries[i + 1];
            String leftQueryName = leftQuery.getV5QueryName();
            if (i == 2) {
                queryRefs.add(leftQueryName);
            }
            String rightQueryName = rightQuery.getV5QueryName();
            queryRefs.add(rightQueryName);
            int gcSize = groupingColumns.size();
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < gcSize; ++j) {
                V5DataItem gc = groupingColumns.get(j);
                sb.append(UniqueNameGenerator.createUniqueName(leftQueryName, gc.getNameProperty()));
                sb.append(" = ");
                sb.append(UniqueNameGenerator.createUniqueName(rightQueryName, gc.getNameProperty()));
                if (j >= gcSize - 1) continue;
                sb.append(" AND ");
            }
            V5DetailFilter df = (V5DetailFilter)this.nodeFactory.createNode(101008);
            innerQuery.addChild(df);
            V5FilterExpression fe = (V5FilterExpression)this.nodeFactory.createNode(101013);
            df.addChild(fe);
            fe.setPropertyValue("expression", sb.toString());
        }
        V5Source source = innerQuery.getV5Source();
        source.setReferencedQueries(queryRefs);
        Governors governorObj = new Governors();
        governorObj.setCrossProdAllowed("allow");
        this.querySet.getChild(1).setPropertyValue("governors", governorObj);
    }

    private boolean hasDifferentContexts() {
        MeasureInfo firstMi = this.measureInfoList.get(0);
        for (int i = 1; i < this.measureInfoList.size(); ++i) {
            if (firstMi.hasSameContexts(this.measureInfoList.get(i))) continue;
            return true;
        }
        return false;
    }

    private void updateQueryNameInQueryRefItems(V5DataItem dataItem, HashMap<String, V5Query> dataItemNameToQuery) {
        IXQEQueryNode[] boundRefs;
        PlanningEnvironment env = (PlanningEnvironment)dataItem.getPlanningEnvironment();
        V5Expression expressionNode = (V5Expression)dataItem.getChild(0);
        IXQEQueryNode expression = null;
        if (expressionNode.getNumberChildren() == 0) {
            String expr = expressionNode.getExpression();
            expression = this.expressionLocale != null ? RQPUtilities.createV5ValueExpression(expr, env, null, this.expressionLocale) : RQPUtilities.createV5ValueExpression(expr, env, null);
        } else {
            expression = expressionNode.getChild(0);
        }
        for (IXQEQueryNode ref : boundRefs = expression.getDescendantsOfType(201030, true)) {
            String[] nameParts;
            String columnName;
            V5Query query;
            if (ref.getParent() != null && ref.getParent().getType() == 201037 || (query = dataItemNameToQuery.get(columnName = (nameParts = ((V5MultiPartIdentifier)ref).getNameParts())[nameParts.length - 1])) == null) continue;
            ((V5MultiPartIdentifier)ref).setIdentifier(UniqueNameGenerator.createUniqueName(query.getV5QueryName(), columnName));
            nameParts[0] = query.getV5QueryName();
            ((V5MultiPartIdentifier)ref).setNameParts(nameParts);
        }
        StringBuilder sb = new StringBuilder();
        expression.writeFormattedText(sb);
        expressionNode.setExpression(sb.toString());
        expression.detach();
    }

    private V5DataItem addNewDataItem(V5Selection selection, V5DataItem currentDi, String exprStr) {
        V5DataItem newDataItem = (V5DataItem)this.nodeFactory.copyNode(currentDi);
        this.addChildToParent(selection, newDataItem);
        IXQEQueryNode expression = this.nodeFactory.createNode(101004);
        expression.setPropertyValue("expression", exprStr);
        this.addChildToParent(newDataItem, expression);
        return newDataItem;
    }

    private void copyDataItemsAndFilters(V5Query innerQuery, V5Query newQuery, HashMap<MeasureInfo, V5Query> measureToQuery) {
        IXQEQueryNode[] dataItems;
        V5Selection innerQuerySelection = innerQuery.getV5Selection();
        V5Selection newV5Selection = newQuery.getV5Selection();
        MeasureInfo miNewQuery = (MeasureInfo)newQuery.getPropertyValue(STR_MEASURE_INFO);
        PlanningEnvironment env = (PlanningEnvironment)innerQuery.getPlanningEnvironment();
        HashMap dataItemNameToQuery = (HashMap)innerQuery.getPropertyValue(PROP_DATA_ITEM_NAME_TO_QUERY);
        for (IXQEQueryNode di : dataItems = innerQuery.getV5Selection().getChildren()) {
            V5DataItem currentDi = (V5DataItem)di;
            String aggr = currentDi.getAggregateProperty();
            if (aggr != null && aggr.equals(STR_NONE)) {
                this.addNewDataItem(currentDi, newV5Selection);
                continue;
            }
            if (dataItemNameToQuery.get(currentDi.getNameProperty()) != null || currentDi.getPropertyValue(PROP_MULTIPLE_MEASURES) != null) continue;
            MeasureInfo mi = (MeasureInfo)currentDi.getPropertyValue(STR_MEASURE_INFO);
            if (mi != null) {
                if (mi != miNewQuery) continue;
                this.addNewDataItem(currentDi, newV5Selection);
                dataItemNameToQuery.put(currentDi.getNameProperty(), newQuery);
                continue;
            }
            List<MeasureInfo> mis = this.collectMeasureInfos(env, currentDi, innerQuerySelection, dataItemNameToQuery);
            if (mis.size() == 1) {
                mi = mis.get(0);
                if (mi != miNewQuery) continue;
                this.addNewDataItem(currentDi, newV5Selection);
                dataItemNameToQuery.put(currentDi.getNameProperty(), newQuery);
                continue;
            }
            currentDi.setPropertyValue(PROP_MULTIPLE_MEASURES, mis);
            dataItemNameToQuery.put(currentDi.getNameProperty(), innerQuery);
        }
        List<V5DetailFilter> memberFilters = miNewQuery.getMemberFilters();
        if (memberFilters != null) {
            for (V5DetailFilter df : memberFilters) {
                newQuery.addChild(this.nodeFactory.deepCopyNode(df));
            }
        }
    }

    private List<MeasureInfo> collectMeasureInfos(PlanningEnvironment env, V5DataItem dataItem, V5Selection selection, HashMap<String, V5Query> dataItemNameToQuery) {
        IXQEQueryNode[] boundRefs;
        ArrayList<MeasureInfo> measureInfos = new ArrayList<MeasureInfo>();
        MeasureInfo measInfo = (MeasureInfo)dataItem.getPropertyValue(STR_MEASURE_INFO);
        if (measInfo != null) {
            measureInfos.add(measInfo);
            return measureInfos;
        }
        IXQEQueryNode expressionNode = dataItem.getChild(0);
        IXQEQueryNode expression = null;
        if (expressionNode.getNumberChildren() == 0) {
            String expr = ((V5Expression)expressionNode).getExpression();
            expression = this.expressionLocale != null ? RQPUtilities.createV5ValueExpression(expr, env, null, this.expressionLocale) : RQPUtilities.createV5ValueExpression(expr, env, null);
        } else {
            expression = expressionNode.getChild(0);
        }
        for (IXQEQueryNode ref : boundRefs = expression.getDescendantsOfType(201030, true)) {
            if (ref.getParent() != null && ref.getParent().getType() == 201037) continue;
            String[] nameParts = ((V5MultiPartIdentifier)ref).getNameParts();
            V5DataItem refDataItem = selection.getDataItemByRefName(nameParts[nameParts.length - 1]);
            MeasureInfo mi = (MeasureInfo)refDataItem.getPropertyValue(STR_MEASURE_INFO);
            if (mi != null) {
                measureInfos.add(mi);
                continue;
            }
            measureInfos.addAll(this.collectMeasureInfos(env, refDataItem, selection, dataItemNameToQuery));
        }
        if (expressionNode.getNumberChildren() == 0 && measureInfos.size() > 1) {
            expressionNode.addChild(expression);
        }
        return measureInfos;
    }

    private V5DataItem addNewDataItem(V5DataItem currentDi, V5Selection newV5Selection) {
        V5DataItem dataItem = (V5DataItem)this.nodeFactory.deepCopyNode(currentDi);
        this.addChildToParent(newV5Selection, dataItem);
        return dataItem;
    }

    public List<MeasureInfo> getMeasureInfoList() {
        return this.measureInfoList;
    }

    public void addMeasureInfoInRefiner(MeasureInfo measureInfo) {
        this.measureInfoList.add(measureInfo);
    }

    public void addMeasureInfo(BaseMember measureMember, List<String> contexts) {
        MDXTuple tuple = (MDXTuple)measureMember.getAncestorOfType(1069);
        if (this.measureInfoStack.isEmpty()) {
            MeasureInfo newMi = new MeasureInfo((IMeasure)measureMember.getMember(), null, tuple, contexts);
            this.measureInfoStack.push(newMi);
        } else {
            MeasureInfo mi = this.measureInfoStack.peek();
            mi.setMeasure((IMeasure)measureMember.getMember());
            mi.setContextDataItems(contexts);
            mi.setAncestorTuple(tuple);
        }
    }

    public void addMemberFilterInCustomValueRefiner(V5DetailFilter detailFilter) {
        MeasureInfo mi = null;
        if (!this.measureInfoStack.isEmpty()) {
            mi = this.measureInfoStack.peek();
            List<V5DetailFilter> dfs = mi.getMemberFilters();
            if (dfs == null) {
                dfs = new ArrayList<V5DetailFilter>();
                mi.setMemberFilters(dfs);
            }
            dfs.add(detailFilter);
        } else {
            ArrayList<V5DetailFilter> dfs = new ArrayList<V5DetailFilter>();
            dfs.add(detailFilter);
            mi = new MeasureInfo(dfs);
            this.measureInfoStack.push(mi);
        }
    }

    public void addContextInMeasureInfo(List<String> dataItemNames) {
        if (!this.measureInfoStack.isEmpty()) {
            MeasureInfo mi = this.measureInfoStack.peek();
            mi.setContextDataItems(dataItemNames);
        }
    }

    public void removeMeasureInfoFromStack() {
        MeasureInfo mi;
        if (!this.measureInfoStack.isEmpty() && !this.measureInfoList.contains(mi = this.measureInfoStack.pop())) {
            this.addMeasureInfoInRefiner(mi);
        }
    }

    public MeasureInfo getMeasureInfoFromStack() {
        if (!this.measureInfoStack.isEmpty()) {
            return this.measureInfoStack.peek();
        }
        return null;
    }

    public class MeasureInfo {
        private IMeasure measure = null;
        private List<String> contextDataItems = null;
        private List<V5DetailFilter> memberFilters = null;
        private MDXTuple ancestorTuple = null;

        public MeasureInfo(IMeasure inputMeasure, List<V5DetailFilter> inputMemberFilters, MDXTuple tuple, List<String> contexts) {
            this.measure = inputMeasure;
            this.memberFilters = inputMemberFilters;
            this.ancestorTuple = tuple;
            this.contextDataItems = contexts;
        }

        public MeasureInfo(List<V5DetailFilter> inputMemberFilters) {
            this.memberFilters = inputMemberFilters;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof MeasureInfo)) {
                return false;
            }
            MeasureInfo otherMeasureInfo = (MeasureInfo)other;
            if (this.getMeasure() != otherMeasureInfo.getMeasure()) {
                return false;
            }
            if (!this.hasSameContexts(otherMeasureInfo)) {
                return false;
            }
            return this.hasSameMemberFilters(otherMeasureInfo);
        }

        public int hashCode() {
            return this.getMeasure().hashCode() + this.getContextDataItems().hashCode() + this.getAncestorTuple().hashCode();
        }

        public boolean hasSameContexts(MeasureInfo otherMeasureInfo) {
            HashSet<String> set1 = new HashSet<String>(this.getContextDataItems());
            HashSet<String> set2 = new HashSet<String>(otherMeasureInfo.getContextDataItems());
            HashSet<String> intersectionSet = new HashSet<String>(set1);
            intersectionSet.retainAll(set2);
            return intersectionSet.size() == set1.size();
        }

        private boolean hasSameMemberFilters(MeasureInfo mi2) {
            List<V5DetailFilter> memberFilters1 = this.getMemberFilters();
            List<V5DetailFilter> memberFilters2 = mi2.getMemberFilters();
            if (memberFilters1 != null && memberFilters2 != null) {
                if (memberFilters1.size() != memberFilters2.size()) {
                    return false;
                }
                for (V5DetailFilter f1 : memberFilters1) {
                    boolean found = false;
                    for (V5DetailFilter f2 : memberFilters1) {
                        if (f1 != f2) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                return true;
            }
            MDXTuple tuple1 = this.getAncestorTuple();
            MDXTuple tuple2 = mi2.getAncestorTuple();
            return tuple1 != null && tuple2 != null && tuple1.isSameExpression(tuple2, false);
        }

        public IMeasure getMeasure() {
            return this.measure;
        }

        public List<V5DetailFilter> getMemberFilters() {
            return this.memberFilters;
        }

        public void setMemberFilters(List<V5DetailFilter> filters) {
            this.memberFilters = filters;
        }

        public MDXTuple getAncestorTuple() {
            return this.ancestorTuple;
        }

        public void setAncestorTuple(MDXTuple tuple) {
            this.ancestorTuple = tuple;
        }

        public List<String> getContextDataItems() {
            return this.contextDataItems;
        }

        public void setContextDataItems(List<String> dataItemNames) {
            this.contextDataItems = dataItemNames;
        }

        public void setMeasure(IMeasure measureMember) {
            this.measure = measureMember;
        }
    }
}

