/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.resource;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.resource.AutoReleaseResource;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ResourceReleaseService {
    private static final XQELogger ERROR_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Resources", LogLevel.ERROR);
    private static final long CLEANUP_TIMEOUT = 1000L;
    private static final long THREAD_SHUTDOWN_TIMEOUT = 30000L;
    private static volatile Thread serviceThread = null;
    private static volatile boolean keepRunning = false;
    private static ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private static ConcurrentMap<AutoReleaseResource, AutoReleaseResource> pinList = new ConcurrentHashMap<AutoReleaseResource, AutoReleaseResource>();

    public static ReferenceQueue<? super Object> getReferenceQueue() {
        return refQueue;
    }

    public static void pinResource(AutoReleaseResource res) {
        pinList.put(res, res);
    }

    public static void unPinResource(AutoReleaseResource res) {
        pinList.remove(res);
    }

    public static synchronized void start() {
        if (serviceThread != null) {
            return;
        }
        keepRunning = true;
        serviceThread = new Thread((Runnable)new ReleaseRunner(), "ResourceReleaseService");
        serviceThread.setDaemon(true);
        serviceThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void stop() {
        if (serviceThread == null) {
            return;
        }
        keepRunning = false;
        ReferenceQueue<Object> referenceQueue = refQueue;
        synchronized (referenceQueue) {
            refQueue.notify();
        }
        try {
            serviceThread.join(30000L);
        }
        catch (InterruptedException e) {
            ERROR_LOGGER.log(e);
        }
        serviceThread = null;
    }

    private static class ReleaseRunner
    implements Runnable {
        private ReleaseRunner() {
        }

        private boolean releaseResource() {
            AutoReleaseResource res;
            try {
                res = (AutoReleaseResource)refQueue.remove(1000L);
            }
            catch (InterruptedException e) {
                return false;
            }
            if (res == null) {
                return false;
            }
            try {
                if (res.isSafetyNet()) {
                    ERROR_LOGGER.log("Releasing resource " + res.toString());
                }
                res.release();
            }
            catch (Throwable e) {
                ERROR_LOGGER.log("Error releasing resource: ", e);
            }
            return true;
        }

        @Override
        public void run() {
            do {
                this.releaseResource();
            } while (keepRunning);
            while (this.releaseResource()) {
            }
        }
    }
}

