/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.resource;

import com.cognos.xqe.util.resource.IWeakReferenceListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class WeakReferenceWatcher {
    private final Map<WatchRecord, WatchRecord> mRecords = new ConcurrentHashMap<WatchRecord, WatchRecord>();
    private final ReferenceQueue<Object> mRefQueue = new ReferenceQueue();

    public void addWatch(Object obj, IWeakReferenceListener listener) {
        if (null == obj) {
            throw new IllegalArgumentException("obj was null");
        }
        if (null == listener) {
            throw new IllegalArgumentException("listener was null");
        }
        WatchRecord rec = new WatchRecord(obj, this.mRefQueue, listener);
        this.mRecords.put(rec, rec);
    }

    public void removeWatch(Object obj) {
        Iterator<WatchRecord> iter = this.mRecords.keySet().iterator();
        while (iter.hasNext()) {
            WatchRecord rec = iter.next();
            if (null == rec || rec.get() != obj) continue;
            iter.remove();
            break;
        }
    }

    public void poll() {
        this.poll(Integer.MAX_VALUE);
    }

    public void poll(int maxIterations) {
        WatchRecord rec;
        for (int i = 0; i < maxIterations && null != (rec = (WatchRecord)this.mRefQueue.poll()); ++i) {
            this.mRecords.remove(rec);
            rec.getListener().onWeaklyReachable();
        }
    }

    private static final class WatchRecord
    extends WeakReference<Object> {
        private final IWeakReferenceListener mListener;

        WatchRecord(Object reference, ReferenceQueue<Object> queue, IWeakReferenceListener listener) {
            super(reference, queue);
            this.mListener = listener;
        }

        public IWeakReferenceListener getListener() {
            return this.mListener;
        }
    }
}

