/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.symboltable;

import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.util.symboltable.ISymbolTable;
import com.cognos.xqemoser.MoserQuerySubject;
import java.util.Iterator;
import java.util.LinkedList;

public final class SymbolTableStack {
    private static final String DOT = ".";
    public static final String SKIP_SELF = "SKIP_SELF";
    protected LinkedList<ISymbolTable> symbolTableStack = new LinkedList();
    protected LinkedList<IMetadata> self = new LinkedList();
    protected boolean allowBindToSelf = true;

    public ISymbolTable pop() {
        return this.symbolTableStack.pop();
    }

    public void push(ISymbolTable symbolTable) {
        this.symbolTableStack.push(symbolTable);
    }

    public IMetadata get(String identifier) {
        Iterator stackIterator = this.symbolTableStack.iterator();
        IMetadata metadata = null;
        String key = identifier;
        while (stackIterator.hasNext() && metadata == null) {
            ISymbolTable symbolTable = (ISymbolTable)stackIterator.next();
            metadata = symbolTable.get(key, this);
            if (SymbolTableStack.bindInMoserQuerySubject(symbolTable.getQuerySubject())) break;
            if (this.allowBindToSelf || this.self.isEmpty() || this.self.peek() == null || metadata != this.self.peek()) continue;
            String[] nameparts = key.split("\\.");
            StringBuilder newId = new StringBuilder();
            newId.append(SKIP_SELF);
            newId.append(DOT);
            if (nameparts.length == 1 && symbolTable.getQuerySubject() != null) {
                newId.append(symbolTable.getQuerySubject().getUniqueName());
                newId.append(DOT);
            }
            newId.append(key);
            key = newId.toString();
            metadata = null;
        }
        return metadata;
    }

    public void pushSelf(IMetadata metadata) {
        this.self.push(metadata);
    }

    public void popSelf() {
        this.self.pop();
    }

    public void setAllowBindToSelf(boolean b) {
        this.allowBindToSelf = b;
    }

    public static boolean bindInMoserQuerySubject(IQuerySubject qs) {
        return qs instanceof MoserQuerySubject;
    }
}

