/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.system;

import com.cognos.xqe.util.system.Command;
import com.cognos.xqe.util.system.UnixPingCommand;
import com.cognos.xqe.util.system.WindowsPingCommand;

public abstract class PingCommand {
    public static boolean ping(int pid) {
        PingCommand pingCommand = PingCommand.createPingCommand();
        return pingCommand.pingProcess(pid);
    }

    protected PingCommand() {
    }

    public static boolean isWindowsOS() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.startsWith("Windows");
    }

    public boolean pingProcess(int pid) {
        String command = this.getCommand(pid);
        String[] consoleOutput = Command.runCommandConsole(command);
        return this.isProcessAlive(consoleOutput, pid);
    }

    protected abstract boolean isProcessAlive(String[] var1, int var2);

    protected abstract String getCommand(int var1);

    public static PingCommand createPingCommand() {
        if (PingCommand.isWindowsOS()) {
            return new WindowsPingCommand();
        }
        return new UnixPingCommand();
    }
}

