/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.usage;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.query.engine.SessionContext;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.usage.IndicatorSnapshot;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.OncePerReportUsageIndicator;
import com.cognos.xqe.util.usage.indicators.SimpleUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Writer;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class UsageTrackingService
implements Runnable {
    private static TreeMap<UsageIndicatorCategory, TreeMap<String, IUsageIndicator>> indicators = new TreeMap();
    private static ReentrantReadWriteLock indicatorLock = new ReentrantReadWriteLock();
    private static final String USAGE = "usage";
    private static final String NAME = "name";
    private static final String REPORT = "report";
    private static final String CATEGORY = "category";
    private static final String INDICATOR = "indicator";
    private static final String VALUE = "value";
    private static final String CONFIG_ERROR = "Usage Tracking configuration property '%1$s' is incorrect, reverting to default: %2$s";
    private static final int DEFAULT_DUMP_PERIOD = 60;
    private static final int DEFAULT_ROLL_OVER_PERIOD = 1440;
    private static final int MS_IN_MINUTE = 60000;
    private static volatile UsageTrackingService instance;
    static String logFolder;
    private static volatile Thread serviceThread;
    private static volatile boolean enabled;
    private static long dumpPeriod;
    private static long rollOverPeriod;
    private static boolean recordZeros;
    private static boolean recordPerReport;
    private volatile boolean keepRunning = true;
    private long startTime;
    private long lastRollOverTime;
    private long lastDumpTime;
    static XQELogger mErrorLogger;
    static XQELogger mInfoLogger;
    static XQELogger mInitTermLogger;
    private String version = null;
    private StringBuilder stringBuilder = new StringBuilder();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd-HHmmssSSS");
    private static TreeMap<String, TreeMap<UsageIndicatorCategory, TreeMap<String, Long>>> perReportData;
    private static WeakHashMap<SessionContext, String> sessionToReportNameMap;
    private static ReentrantReadWriteLock sessionToReportNameMapLock;
    private static long unknownReportCounter;
    private static boolean transformationUsageTrackingEnabled;
    public static final IUsageIndicator DISABLED_INDICATOR;

    private UsageTrackingService() {
        this.lastDumpTime = this.startTime = System.currentTimeMillis();
        this.lastRollOverTime = this.startTime;
    }

    public static synchronized void start() {
        if (instance != null) {
            return;
        }
        UsageTrackingService.configure();
        if (!enabled) {
            mInitTermLogger.log("Usage Tracking Service is disabled");
            return;
        }
        instance = new UsageTrackingService();
        serviceThread = new Thread((Runnable)instance, "UsageTrackingService");
        serviceThread.setDaemon(true);
        serviceThread.start();
        mInitTermLogger.log("Usage Tracking Service started");
        UsageTrackingService.recordEnvIndicator("javaVendor", "java.vendor");
        UsageTrackingService.recordEnvIndicator("javaVM", "java.vm.name");
        UsageTrackingService.recordEnvIndicator("javaVersion", "java.runtime.version");
        UsageTrackingService.recordEnvIndicator("osName", "os.name");
        UsageTrackingService.recordEnvIndicator("osVersion", "os.version");
    }

    private static void recordEnvIndicator(String cat, String prop) {
        String val = System.getProperty(prop);
        if (val == null) {
            return;
        }
        IUsageIndicator ind = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.ENVIRONMENT, cat + "/" + val);
        ind.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void stop() {
        if (instance == null) {
            return;
        }
        instance.shutDown();
        instance = null;
        try {
            serviceThread.join();
        }
        catch (InterruptedException e) {
            mErrorLogger.log(e);
        }
        serviceThread = null;
        indicatorLock.writeLock().lock();
        try {
            indicators.clear();
        }
        finally {
            indicatorLock.writeLock().unlock();
        }
        TreeMap<String, TreeMap<UsageIndicatorCategory, TreeMap<String, Long>>> treeMap = perReportData;
        synchronized (treeMap) {
            perReportData.clear();
        }
        sessionToReportNameMapLock.writeLock().lock();
        try {
            sessionToReportNameMap.clear();
        }
        finally {
            sessionToReportNameMapLock.writeLock().unlock();
        }
        mInitTermLogger.log("Usage Tracking Service was shut down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutDown() {
        this.keepRunning = false;
        UsageTrackingService usageTrackingService = this;
        synchronized (usageTrackingService) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.cleanFolder();
        while (this.keepRunning) {
            long missedChkpts = this.missedCheckpoints(this.lastRollOverTime, rollOverPeriod);
            if (missedChkpts > 0L) {
                this.lastRollOverTime += missedChkpts * rollOverPeriod;
                this.cleanFolder();
            }
            if ((missedChkpts = this.missedCheckpoints(this.lastDumpTime, dumpPeriod)) > 0L) {
                this.lastDumpTime += missedChkpts * dumpPeriod;
                this.saveData();
            }
            try {
                UsageTrackingService usageTrackingService = this;
                synchronized (usageTrackingService) {
                    this.wait(60000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this.saveData();
    }

    private static void configure() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        logFolder = configuration.getXqeLogsDirectory() + File.separator + USAGE;
        UsageTrackingService.readUsageTrackingFromConfig(configuration);
        if (!enabled) {
            return;
        }
        dumpPeriod = 60000 * configuration.getIntProperty("usageTracking.dumpPeriod[@value]", 60);
        if (dumpPeriod <= 0L) {
            mErrorLogger.log(String.format(CONFIG_ERROR, "dumpPeriod", Integer.toString(60)));
            dumpPeriod = 3600000L;
        }
        if ((rollOverPeriod = (long)(60000 * configuration.getIntProperty("usageTracking.rollOverPeriod[@value]", 1440))) <= 0L) {
            mErrorLogger.log(String.format(CONFIG_ERROR, "rollOverPeriod", Integer.toString(1440)));
            rollOverPeriod = 86400000L;
        }
        recordZeros = configuration.getBooleanProperty("usageTracking.recordZeros[@value]", false);
        File usageFolder = new File(logFolder);
        usageFolder.mkdirs();
        if (!usageFolder.exists()) {
            throw new IllegalStateException("Error creating folder for Usage Tracking Service data files: " + logFolder);
        }
    }

    public static void readUsageTrackingFromConfig(XQEConfiguration configuration) {
        enabled = configuration.getBooleanProperty("usageTracking[@enabled]", false);
        recordPerReport = configuration.getBooleanProperty("usageTracking.recordPerReport[@value]", false);
        transformationUsageTrackingEnabled = configuration.getBooleanProperty("usageTracking.transformationUsage[@value]", true);
    }

    private void cleanFolder() {
        File[] files = new File(logFolder).listFiles();
        int fileCount = 0;
        long currTime = System.currentTimeMillis();
        for (File file : files) {
            if (currTime - file.lastModified() < rollOverPeriod) continue;
            if (!file.delete()) {
                mErrorLogger.log("Error deleting file " + file.getAbsolutePath());
                continue;
            }
            ++fileCount;
        }
        mInfoLogger.log("Removed " + Integer.toString(fileCount) + " stale usage tracking data file(s)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveData() {
        this.stringBuilder.delete(0, this.stringBuilder.length());
        this.stringBuilder.append("usage-");
        long currentTime = System.currentTimeMillis();
        this.stringBuilder.append(this.dateFormat.format(new Date(currentTime)));
        this.stringBuilder.append(".xml.gz");
        File file = new File(logFolder, this.stringBuilder.toString());
        try {
            BufferedOutputStream logFile = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file)));
            XMLStreamWriter writer = StaxUtil.createXMLStreamWriter(logFile);
            writer.writeStartDocument();
            writer.writeStartElement(USAGE);
            writer.writeAttribute("component", "XQE");
            writer.writeAttribute("version", this.getVersion());
            writer.writeAttribute("timestamp", new Timestamp(currentTime).toString());
            if (!recordPerReport) {
                indicatorLock.readLock().lock();
                try {
                    for (Map.Entry<UsageIndicatorCategory, TreeMap<String, IUsageIndicator>> catData : indicators.entrySet()) {
                        boolean indicatorsFound = false;
                        for (IUsageIndicator indicator : catData.getValue().values()) {
                            long value = indicator.pullValue();
                            if (value <= 0L && !recordZeros) continue;
                            if (!indicatorsFound) {
                                writer.writeStartElement(CATEGORY);
                                writer.writeAttribute(NAME, catData.getKey().getName());
                                indicatorsFound = true;
                            }
                            writer.writeStartElement(INDICATOR);
                            writer.writeAttribute(NAME, indicator.getName());
                            writer.writeAttribute(VALUE, Long.toString(value));
                            writer.writeEndElement();
                        }
                        if (!indicatorsFound) continue;
                        writer.writeEndElement();
                    }
                }
                finally {
                    indicatorLock.readLock().unlock();
                }
            }
            TreeMap<String, TreeMap<UsageIndicatorCategory, TreeMap<String, Long>>> treeMap = perReportData;
            synchronized (treeMap) {
                for (Map.Entry<String, TreeMap<UsageIndicatorCategory, TreeMap<String, Long>>> reportData : perReportData.entrySet()) {
                    UsageTrackingService.writeReportData(writer, reportData.getKey(), reportData.getValue());
                }
                perReportData.clear();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            logFile.close();
        }
        catch (Exception e) {
            mErrorLogger.log(e);
        }
        mInfoLogger.log("Saved usage tracking data to " + this.stringBuilder.toString());
    }

    public static void writeReportData(XMLStreamWriter writer, String reportName, TreeMap<UsageIndicatorCategory, TreeMap<String, Long>> treeMap) throws XMLStreamException {
        writer.writeStartElement(REPORT);
        writer.writeAttribute(NAME, reportName);
        for (Map.Entry<UsageIndicatorCategory, TreeMap<String, Long>> catData : treeMap.entrySet()) {
            boolean indicatorsFound = false;
            for (Map.Entry<String, Long> indicator : catData.getValue().entrySet()) {
                long value = indicator.getValue();
                if (value <= 0L && !recordZeros) continue;
                if (!indicatorsFound) {
                    writer.writeStartElement(CATEGORY);
                    writer.writeAttribute(NAME, catData.getKey().getName());
                    indicatorsFound = true;
                }
                writer.writeStartElement(INDICATOR);
                writer.writeAttribute(NAME, indicator.getKey());
                writer.writeAttribute(VALUE, Long.toString(value));
                writer.writeEndElement();
            }
            if (!indicatorsFound) continue;
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedList<IndicatorSnapshot> getSnapshot() {
        LinkedList<IndicatorSnapshot> list = new LinkedList<IndicatorSnapshot>();
        indicatorLock.readLock().lock();
        try {
            for (Map.Entry<UsageIndicatorCategory, TreeMap<String, IUsageIndicator>> catData : indicators.entrySet()) {
                for (IUsageIndicator indicator : catData.getValue().values()) {
                    UsageIndicatorCategory category = indicator.getCategory();
                    list.add(new IndicatorSnapshot(category.getName(), indicator.getName(), indicator.getValue()));
                }
            }
        }
        finally {
            indicatorLock.readLock().unlock();
        }
        return list;
    }

    private long missedCheckpoints(long lastTime, long interval) {
        return (System.currentTimeMillis() - lastTime) / interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IUsageIndicator getIndicator(UsageIndicatorType type, UsageIndicatorCategory cat, String name) {
        TreeMap<String, IUsageIndicator> indMap;
        if (instance == null) {
            return DISABLED_INDICATOR;
        }
        IUsageIndicator indicator = null;
        indicatorLock.readLock().lock();
        try {
            indMap = indicators.get((Object)cat);
            if (indMap != null && (indicator = indMap.get(name)) != null) {
                IUsageIndicator iUsageIndicator = indicator;
                return iUsageIndicator;
            }
        }
        finally {
            indicatorLock.readLock().unlock();
        }
        indicatorLock.writeLock().lock();
        try {
            indMap = indicators.get((Object)cat);
            if (indMap == null) {
                indMap = new TreeMap();
                indicators.put(cat, indMap);
            } else {
                indicator = indMap.get(name);
            }
            if (indicator == null) {
                switch (type) {
                    case SIMPLE_INDICATOR: {
                        indicator = new SimpleUsageIndicator(cat, name, recordPerReport);
                        break;
                    }
                    case ONCE_PER_REPORT_INDICATOR: {
                        indicator = new OncePerReportUsageIndicator(cat, name, recordPerReport);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid indicator type: " + type.toString());
                    }
                }
                indMap.put(name, indicator);
            }
            IUsageIndicator iUsageIndicator = indicator;
            return iUsageIndicator;
        }
        finally {
            indicatorLock.writeLock().unlock();
        }
    }

    private String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        try {
            Class<Provider> clazz = Provider.class;
            String classSimpleName = clazz.getSimpleName();
            String classFileName = classSimpleName + ".class";
            String classFilePath = clazz.getResource(classFileName).toString();
            int bangSeparatorIndex = classFilePath.indexOf("!");
            String manifestFilePath = classFilePath.substring(0, bangSeparatorIndex + 1);
            manifestFilePath = manifestFilePath + "/META-INF/MANIFEST.MF";
            URL manifestFileURL = new URL(manifestFilePath);
            Manifest xqeManifest = new Manifest(manifestFileURL.openStream());
            Attributes attributes = xqeManifest.getAttributes("com/cognos/xqe");
            this.version = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        catch (Exception e) {
            this.version = "";
            mErrorLogger.log(e);
        }
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePerReportValue(SessionContext context, UsageIndicatorCategory cat, String indicator, long value) {
        String reportName;
        if (!recordPerReport) {
            return;
        }
        sessionToReportNameMapLock.readLock().lock();
        try {
            reportName = sessionToReportNameMap.get(context);
            if (reportName == null) {
                throw new IllegalStateException("Report name must be registered");
            }
        }
        finally {
            sessionToReportNameMapLock.readLock().unlock();
        }
        UsageTrackingService.updatePerReportValue(reportName, cat, indicator, value);
    }

    public static boolean recordPerReportEnabled() {
        return recordPerReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePerReportValue(String reportName, UsageIndicatorCategory cat, String indicator, long value) {
        TreeMap<String, TreeMap<UsageIndicatorCategory, TreeMap<String, Long>>> treeMap = perReportData;
        synchronized (treeMap) {
            Long prevValue;
            TreeMap<String, Long> categoryData;
            TreeMap<UsageIndicatorCategory, TreeMap<String, Long>> reportData = perReportData.get(reportName);
            if (reportData == null) {
                reportData = new TreeMap();
                perReportData.put(reportName, reportData);
            }
            if ((categoryData = reportData.get((Object)cat)) == null) {
                categoryData = new TreeMap();
                reportData.put(cat, categoryData);
            }
            if ((prevValue = categoryData.get(indicator)) == null) {
                categoryData.put(indicator, value);
            } else {
                categoryData.put(indicator, value + prevValue);
            }
        }
    }

    public static void registerReport(SessionContext context, String reportName) {
        sessionToReportNameMapLock.readLock().lock();
        try {
            if (sessionToReportNameMap.get(context) != null) {
                return;
            }
        }
        finally {
            sessionToReportNameMapLock.readLock().unlock();
        }
        sessionToReportNameMapLock.writeLock().lock();
        try {
            if (sessionToReportNameMap.get(context) == null) {
                if (reportName.equals("unknown")) {
                    sessionToReportNameMap.put(context, reportName + Long.toString(unknownReportCounter));
                    ++unknownReportCounter;
                } else {
                    sessionToReportNameMap.put(context, reportName);
                }
            }
        }
        finally {
            sessionToReportNameMapLock.writeLock().unlock();
        }
    }

    public static String getReportName(SessionContext context) {
        sessionToReportNameMapLock.readLock().lock();
        try {
            String string = sessionToReportNameMap.get(context);
            return string;
        }
        finally {
            sessionToReportNameMapLock.readLock().unlock();
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean transformationUsageTrackingEnabled() {
        return enabled && transformationUsageTrackingEnabled;
    }

    public static void setRecordPerReport(boolean b) {
        if (instance == null) {
            UsageTrackingService.start();
        }
        enabled = true;
        transformationUsageTrackingEnabled = true;
        recordPerReport = b;
    }

    public static void writePerfDataForReport(Writer logger, String reportName) {
        TreeMap<UsageIndicatorCategory, TreeMap<String, Long>> reportData = perReportData.get(reportName);
        if (reportData == null) {
            return;
        }
        try {
            XMLStreamWriter writer = StaxUtil.createXMLStreamWriter(logger);
            writer.writeStartDocument();
            writer.writeStartElement(USAGE);
            writer.writeAttribute("component", "XQE");
            long currentTime = System.currentTimeMillis();
            writer.writeAttribute("timestamp", new Timestamp(currentTime).toString());
            UsageTrackingService.writeReportData(writer, reportName, reportData);
            writer.writeEndElement();
            writer.writeEndDocument();
            perReportData.remove(reportName);
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public static boolean isOn() {
        return instance != null;
    }

    static {
        enabled = false;
        mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
        mInfoLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "UsageTracker", LogLevel.INFO);
        mInitTermLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "InitTerm", LogLevel.ERROR);
        perReportData = new TreeMap();
        sessionToReportNameMap = new WeakHashMap();
        sessionToReportNameMapLock = new ReentrantReadWriteLock();
        unknownReportCounter = 0L;
        transformationUsageTrackingEnabled = true;
        DISABLED_INDICATOR = new IUsageIndicator(){

            @Override
            public void setValue(long val) {
            }

            @Override
            public void increment() {
            }

            @Override
            public void add(long val) {
            }

            @Override
            public long getValue() {
                return 0L;
            }

            @Override
            public long pullValue() {
                return 0L;
            }

            @Override
            public String getName() {
                return null;
            }

            @Override
            public UsageIndicatorCategory getCategory() {
                return null;
            }
        };
    }
}

