/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.xml.serializer;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.util.xml.serializer.XMLAttribute;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import com.cognos.xqe.util.xml.serializer.XMLElementCollection;
import com.cognos.xqe.util.xml.serializer.XMLElementMap;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;

class FieldAccessor {
    FieldAccessor() {
    }

    static String getLocalName(Field field) {
        String name = FieldAccessor.getAnnotatedName(field);
        if (name.equals("")) {
            name = field.getName();
        }
        return name;
    }

    static String getAnnotatedName(Field field) {
        String name = "";
        if (field == null) {
            return name;
        }
        XMLElement elem = field.getAnnotation(XMLElement.class);
        if (elem != null) {
            name = elem.name();
        } else {
            XMLAttribute attr = field.getAnnotation(XMLAttribute.class);
            if (attr != null) {
                name = attr.name();
            } else {
                XMLElementCollection coll = field.getAnnotation(XMLElementCollection.class);
                if (coll != null) {
                    name = coll.name();
                } else {
                    XMLElementMap map = field.getAnnotation(XMLElementMap.class);
                    if (map != null) {
                        name = map.name();
                    }
                }
            }
        }
        return name;
    }

    static boolean isCDATA(Field field) {
        boolean isCDATA = false;
        if (field == null) {
            return isCDATA;
        }
        XMLElement elem = field.getAnnotation(XMLElement.class);
        if (elem != null) {
            isCDATA = elem.cdata();
        } else {
            XMLElementCollection coll = field.getAnnotation(XMLElementCollection.class);
            if (coll != null) {
                isCDATA = coll.cdata();
            } else {
                XMLElementMap map = field.getAnnotation(XMLElementMap.class);
                if (map != null) {
                    isCDATA = map.cdata();
                }
            }
        }
        return isCDATA;
    }

    static boolean isBasicType(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass().isPrimitive()) {
            return true;
        }
        if (obj.getClass().equals(String.class) || obj.getClass().equals(Integer.class) || obj.getClass().equals(Double.class) || obj.getClass().equals(Long.class) || obj.getClass().equals(Float.class) || obj.getClass().equals(Boolean.class) || obj.getClass().equals(Byte.class) || obj.getClass().equals(Short.class) || obj.getClass().equals(Character.class)) {
            return true;
        }
        if (obj instanceof Value) {
            return true;
        }
        if (obj instanceof IDataType) {
            return true;
        }
        if (obj instanceof Enum) {
            return true;
        }
        return obj instanceof EnumSet;
    }

    static Object getFieldAsObject(Object parent, Field field) throws IllegalAccessException {
        if (field.isAccessible()) {
            return field.get(parent);
        }
        field.setAccessible(true);
        Object val = field.get(parent);
        field.setAccessible(false);
        return val;
    }

    static Collection<Object> getFieldAsCollection(Object parent, Field field) throws IllegalAccessException, ClassCastException {
        return FieldAccessor.castToCollection(FieldAccessor.getFieldAsObject(parent, field));
    }

    static Map<Object, Object> getFieldAsMap(Object parent, Field field) throws IllegalAccessException, ClassCastException {
        return FieldAccessor.castToMap(FieldAccessor.getFieldAsObject(parent, field));
    }

    static Collection<Object> castToCollection(Object obj) throws ClassCastException {
        if (obj != null) {
            if (Collection.class.isAssignableFrom(obj.getClass())) {
                return (Collection)obj;
            }
            throw new ClassCastException();
        }
        return null;
    }

    static Map<Object, Object> castToMap(Object obj) throws ClassCastException {
        if (obj != null) {
            if (Map.class.isAssignableFrom(obj.getClass())) {
                return (Map)obj;
            }
            throw new ClassCastException();
        }
        return null;
    }
}

