/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.xml.stax;

import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.IStaxComponentHandler;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DelegatingComponentHandler
implements IStaxComponentHandler {
    private final List<DelegateRegistration> registrations = new ArrayList<DelegateRegistration>();

    public void registerDelegate(QName elementName, IStaxComponentHandler handler) {
        this.registrations.add(new DelegateRegistration(elementName, handler));
    }

    public void unregisterDelegate(QName elementName) {
        this.registrations.remove(new DelegateRegistration(elementName, null));
    }

    @Override
    public void consume(XMLStreamReader reader) throws XMLStreamException {
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            QName name = reader.getName();
            IStaxComponentHandler handler = null;
            for (DelegateRegistration registration : this.registrations) {
                if (!registration.matchesName(name)) continue;
                handler = registration.getHandler();
                break;
            }
            if (null != handler) {
                handler.consume(reader);
                continue;
            }
            StaxUtil.skipElement(reader);
        }
    }

    private static final class DelegateRegistration {
        private final QName name;
        private final IStaxComponentHandler handler;

        DelegateRegistration(QName theName, IStaxComponentHandler theHandler) {
            this.name = theName;
            this.handler = theHandler;
        }

        public QName getName() {
            return this.name;
        }

        public IStaxComponentHandler getHandler() {
            return this.handler;
        }

        public boolean matchesName(QName theName) {
            if (this.name.getNamespaceURI().length() > 0 && !this.name.getNamespaceURI().equals(theName.getNamespaceURI())) {
                return false;
            }
            return this.name.getLocalPart().equals(theName.getLocalPart());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DelegateRegistration)) {
                return false;
            }
            DelegateRegistration otherReg = (DelegateRegistration)other;
            return this.name.equals(otherReg.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

