/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqeapi;

import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqeapi.DQResultSetMetaData;
import com.cognos.xqeapi.DQSession;
import java.util.Iterator;

public class DQResultSet
implements Iterator<IRow> {
    protected DQSession session;
    private RSAPIPartialDataset partialDataset;
    private RSAPIEdgeIterator edgeItr;

    DQResultSet(DQSession theSession) {
        this.session = theSession;
    }

    DQResultSet(DQSession theSession, RSAPIPartialDataset aPartialDataset) {
        this(theSession);
        this.partialDataset = aPartialDataset;
        this.edgeItr = this.partialDataset.edgeIterator(0);
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.edgeItr.hasNext();
        if (!hasNext) {
            this.edgeItr.close();
        }
        return hasNext;
    }

    @Override
    public IRow next() {
        return this.edgeItr.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public DQResultSetMetaData getMetadata() {
        RSAPIDataset dataset = this.partialDataset.getMasterDataset();
        RSAPIEdge[] edges = dataset.getEdges();
        if (edges.length > 1) {
            throw new UnsupportedOperationException("Only list reports are supported.");
        }
        RSAPIEdgeRowset[] rowsets = edges[0].getRowsets();
        return new DQResultSetMetaData(rowsets[0]);
    }

    public void release() {
        this.edgeItr.release();
        this.partialDataset.release();
    }
}

