/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqeapi.jdbc;

import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqeapi.DQSession;
import com.cognos.xqeapi.jdbc.DQJDBCDatabaseMetaData;
import com.cognos.xqeapi.jdbc.DQJDBCPreparedStatement;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DQJDBCConnection
implements Connection {
    private DQSession session = new DQSession();
    private String url = null;
    private String model = null;
    private String defaultDataSource = null;
    private boolean isClosed = true;

    public DQJDBCConnection(String aURL, Properties info) throws Exception {
        this.url = aURL;
        Pattern urlpart = Pattern.compile("(\\w+)=([^;]+)(;|$)");
        Matcher m = urlpart.matcher(aURL);
        while (m.find()) {
            if ("model".equalsIgnoreCase(m.group(1))) {
                this.model = m.group(2);
                continue;
            }
            if (!"datasource".equalsIgnoreCase(m.group(1))) continue;
            this.defaultDataSource = m.group(2);
        }
        this.isClosed = false;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void close() throws SQLException {
        try {
            if (!this.isClosed) {
                this.session.release();
                this.isClosed = true;
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Statement createStatement() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public String getCatalog() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new DQJDBCDatabaseMetaData(this.url);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            return new DQJDBCPreparedStatement(this.session.prepareSQLRequest(this.model, this.defaultDataSource, sql));
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            if (t != null && t instanceof ParseException) {
                throw new SQLException(t.getMessage(), e);
            }
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public PreparedStatement prepareStatement(String sl, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLException("Method not supported by DQM JDBC Driver");
    }
}

