/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqeapi.jdbc;

import com.cognos.xqe.util.XQEManifest;
import com.cognos.xqeapi.jdbc.DQJDBCConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DQJDBCDriver
implements Driver {
    public static final String URL_PATTERN = "jdbc:dqm:.*";
    public static final String PROPERTY_USER = "user";
    public static final String PROPERTY_PASSWORD = "password";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_DEFAULT_DATA_SOURCE = "datasource";
    public static final String METHOD_NOT_SUPPORTED = "Method not supported by DQM JDBC Driver";

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return Pattern.matches(URL_PATTERN, url);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            throw new SQLException("Invalid URL: " + url);
        }
        DQJDBCConnection connection = null;
        try {
            connection = new DQJDBCConnection(url, info);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException("Could not establish connection to DQM.");
        }
        return connection;
    }

    @Override
    public int getMajorVersion() {
        try {
            return XQEManifest.getMajorVersion();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int getMinorVersion() {
        try {
            return XQEManifest.getMinorVersion();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return null;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger() is not supported");
    }

    static {
        try {
            DriverManager.registerDriver(new DQJDBCDriver());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

