/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen.translator;

import com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen.AtomElement;
import com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen.QNameFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class XMLElementsParser {
    public static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    public static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private XMLStreamReader mxmlReader;
    private Stack<QName> mnameStack;
    private AtomElement mcurrentAtomElement;
    private Stack<AtomElement> msubElementStack;

    private XMLElementsParser(XMLStreamReader streamReader) {
        this.mxmlReader = streamReader;
    }

    private XMLElementsParser(Reader reader) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        this.mxmlReader = inputFactory.createXMLStreamReader(reader);
    }

    private XMLElementsParser(String xmlString) throws XMLStreamException {
        this(new StringReader(xmlString));
    }

    public static AtomElement parse(String xmlString) throws XMLStreamException {
        return XMLElementsParser.parse(new StringReader(xmlString));
    }

    public static AtomElement parse(Reader reader) throws XMLStreamException {
        XMLElementsParser parser = new XMLElementsParser(reader);
        parser.dispatchEvents();
        return parser.mcurrentAtomElement;
    }

    private void dispatchEvents() throws XMLStreamException {
        this.mnameStack = new Stack();
        while (this.mxmlReader.hasNext()) {
            int nEvent = this.mxmlReader.next();
            switch (nEvent) {
                case 1: {
                    String namespaceURI = this.mxmlReader.getNamespaceURI();
                    String localName = this.mxmlReader.getLocalName();
                    String prefix = this.mxmlReader.getPrefix();
                    QName qName = QNameFactory.newInstance(localName, namespaceURI, prefix);
                    this.mnameStack.push(qName);
                    this.dispatchStartEvent(qName);
                    break;
                }
                case 4: 
                case 12: {
                    this.dispatchCharacters();
                    break;
                }
                case 2: {
                    QName qName = this.mnameStack.pop();
                    if (qName == null) break;
                    this.dispatchEndEvent(qName);
                    break;
                }
            }
        }
    }

    private void dispatchStartEvent(QName qName) throws XMLStreamException {
        AtomElement element = new AtomElement(qName);
        if (this.mcurrentAtomElement == null) {
            this.mcurrentAtomElement = element;
            this.msubElementStack = new Stack();
        }
        int nAttributes = this.mxmlReader.getAttributeCount();
        for (int i = 0; i < nAttributes; ++i) {
            String sName = this.mxmlReader.getAttributeLocalName(i);
            String sValue = this.mxmlReader.getAttributeValue(i);
            element.addAttribute(sName, sValue);
        }
        this.msubElementStack.push(element);
    }

    private void dispatchEndEvent(QName qName) throws XMLStreamException {
        AtomElement element = this.msubElementStack.pop();
        if (element == null) {
            return;
        }
        if (!element.getQName().equals(qName)) {
            throw new XMLStreamException("Wrong element on stack!");
        }
        if (!this.msubElementStack.empty()) {
            AtomElement parentElement = this.msubElementStack.peek();
            parentElement.addElement(element);
        }
    }

    private void dispatchCharacters() throws XMLStreamException {
        String text;
        if (this.msubElementStack == null || this.msubElementStack.empty()) {
            return;
        }
        AtomElement currentElement = this.msubElementStack.peek();
        if (currentElement != null && (text = this.mxmlReader.getText()) != null && text.length() > 0) {
            currentElement.appendText(text);
        }
    }
}

