/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration;

import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqebifw.adminconsole.fragmentproducer.jest.TemplatePage;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration.UITemplateConstants;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration.WebKit;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.regex.Matcher;

public class UITemplatesUtility {
    public static TemplatePage loadTemplatePage(String templateBaseDirectory, String templateFileName) throws IOException {
        String sBaseDirectory = null;
        sBaseDirectory = templateBaseDirectory != null ? templateBaseDirectory : TemplatePage.getSystemTemplateBaseDirectory(null);
        TemplatePage tp = new TemplatePage();
        tp.setBaseDirectory(sBaseDirectory);
        tp.loadTemplate(templateFileName);
        return tp;
    }

    public static StringBuilder replaceCommonsBasicScripts(WebKit webKit, StringBuilder scriptedTextBuffer) throws IOException {
        if (scriptedTextBuffer == null || scriptedTextBuffer.length() == 0) {
            return scriptedTextBuffer;
        }
        String skin = webKit.getSkin();
        if (skin == null || skin.length() == 0) {
            skin = "corporate";
        }
        UITemplatesUtility.scriptReplaceAll("$SKIN$", skin, scriptedTextBuffer);
        String webRootPath = webKit.getWebContentRoot();
        if (webRootPath == null || webRootPath.length() == 0) {
            webRootPath = UITemplateConstants.DEFAULT_WEB_ROOT;
        }
        webRootPath = webRootPath.replaceAll("\\\\", "/");
        UITemplatesUtility.scriptReplaceAll("$WEB$", webRootPath, scriptedTextBuffer);
        URL cgiURL = webKit.getCGIUrl();
        String cgiURLString = null;
        cgiURLString = cgiURL == null ? null : cgiURL.toExternalForm();
        UITemplatesUtility.scriptReplaceAll("$CGI$", cgiURLString, scriptedTextBuffer);
        URL pageURL = webKit.getFragmentURL();
        String pageURLString = null;
        pageURLString = pageURL == null ? null : pageURL.toExternalForm();
        UITemplatesUtility.scriptReplaceAll("$FRAGMENT_URL$", pageURLString, scriptedTextBuffer);
        Locale productLocale = webKit.getProductLocale();
        if (productLocale != null) {
            UITemplatesUtility.scriptReplaceAll("$LANGUAGE$", LocaleConverter.getLanguage(productLocale), scriptedTextBuffer);
        }
        return scriptedTextBuffer;
    }

    public static StringBuilder scriptReplaceAll(String scriptPattern, String scriptValue, StringBuilder scriptedTextBuffer) {
        if (scriptedTextBuffer == null || scriptedTextBuffer.length() == 0) {
            return scriptedTextBuffer;
        }
        String value = null;
        value = scriptValue == null ? "" : scriptValue;
        int scriptLen = scriptPattern.length();
        int pos = 0;
        while ((pos = scriptedTextBuffer.indexOf(scriptPattern, pos)) > -1) {
            scriptedTextBuffer.replace(pos, pos + scriptLen, value);
            ++pos;
        }
        return scriptedTextBuffer;
    }

    public static String scriptReplaceAll(String scriptPattern, String scriptValue, String scriptedText) {
        if (scriptedText == null || scriptedText.length() == 0) {
            return scriptedText;
        }
        StringBuilder scriptedTextBuffer = new StringBuilder(scriptedText);
        scriptedTextBuffer = UITemplatesUtility.scriptReplaceAll(scriptPattern, scriptValue, scriptedTextBuffer);
        return scriptedTextBuffer.toString();
    }

    public static String removeScriptTags(String scriptedText) {
        if (scriptedText == null || scriptedText.length() == 0) {
            return "";
        }
        Matcher matcher = UITemplateConstants.SCRIPT_PATTERN.matcher(scriptedText);
        String scriptFreeText = matcher.replaceAll("");
        return scriptFreeText;
    }
}

