/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control;

import com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen.HtmlBurner;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control.Control;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.control.ControlHelper;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.page.Page;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class TabControl
implements Control {
    private static final String STR_TWO_K = "200";
    private static final String STR_TWENTY = "20";
    private static final String STR_ZERO = "0";
    private static final String STR_EIGHTEEN = "18";
    private static final String STR_ONE = "1";
    protected List<Page> pages = new ArrayList<Page>();
    protected Page activePage;

    public List<Page> getAllPages() {
        return this.pages;
    }

    public void addPage(Page page) {
        this.pages.add(page);
    }

    public Page getActivePage() {
        return this.activePage;
    }

    public void setActivePage(Page aPage) {
        this.activePage = aPage;
    }

    @Override
    public void draw(HtmlBurner burner) throws XMLStreamException {
        int len = this.pages.size();
        if (len == 0) {
            throw new IllegalArgumentException("Cannot create a Tab Control with 0 pages.");
        }
        burner.elementStart("span");
        burner.elementStart("table");
        burner.addAttribute("height", STR_TWENTY);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("border", STR_ZERO);
        burner.addAttribute("width", "100%");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("valign", "bottom");
        burner.addAttribute("align", "right");
        burner.elementStart("table");
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("border", STR_ZERO);
        burner.elementStart("tr");
        for (int i = 0; i < len; ++i) {
            Page page = this.pages.get(i);
            boolean isActive = page.equals(this.activePage);
            if (i == 0) {
                this.drawFirstTab(burner, page, isActive);
                continue;
            }
            if (i + 1 == len) {
                this.drawLastTab(burner, page, isActive);
                continue;
            }
            this.drawMiddleTab(burner, page, isActive);
        }
        this.drawLine(burner);
        burner.elementEnd("tr");
        burner.elementEnd("table");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        this.activePage.draw(burner);
        burner.elementEnd("span");
    }

    protected void drawLine(HtmlBurner burner) throws XMLStreamException {
        burner.elementStart("td");
        burner.addAttribute("height", STR_EIGHTEEN);
        burner.addAttribute("width", "100%");
        burner.elementStart("table");
        burner.addAttribute("width", "100%");
        burner.addAttribute("height", STR_EIGHTEEN);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("border", STR_ZERO);
        burner.elementStart("td");
        burner.elementStart("img");
        burner.addAttribute("height", STR_ONE);
        burner.addAttribute("width", "100%");
        burner.addAttribute("src", "$WEB$/ps/images/space.gif");
        burner.addAttribute("alt", "");
        burner.elementEnd("img");
        burner.elementEnd("td");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("height", STR_EIGHTEEN);
        burner.addAttribute("align", "center");
        burner.addAttribute("class", "tableText");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("height", STR_ONE);
        burner.addAttribute("width", "100%");
        burner.addAttribute("class", "tabBorder");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        burner.elementEnd("td");
    }

    protected void drawFirstTab(HtmlBurner burner, Page page, boolean isActive) throws XMLStreamException {
        if (isActive) {
            this.drawLeftVerticalBorder(burner);
            this.drawActiveTab(burner, page);
        } else {
            this.drawInactiveTab(burner, page);
        }
    }

    protected void drawLastTab(HtmlBurner burner, Page page, boolean isActive) throws XMLStreamException {
        this.drawLeftVerticalBorder(burner);
        if (isActive) {
            this.drawActiveTab(burner, page);
            this.drawLeftVerticalBorder(burner);
        } else {
            this.drawInactiveTab(burner, page);
        }
    }

    protected void drawMiddleTab(HtmlBurner burner, Page page, boolean isActive) throws XMLStreamException {
        this.drawLeftVerticalBorder(burner);
        if (isActive) {
            this.drawActiveTab(burner, page);
        } else {
            this.drawInactiveTab(burner, page);
        }
    }

    protected void drawLeftVerticalBorder(HtmlBurner burner) throws XMLStreamException {
        burner.elementStart("td");
        burner.addAttribute("width", STR_ONE);
        burner.addAttribute("height", STR_TWENTY);
        burner.elementStart("table");
        burner.addAttribute("width", "100%");
        burner.addAttribute("height", STR_TWENTY);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("border", STR_ZERO);
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("width", STR_ONE);
        burner.addAttribute("height", STR_EIGHTEEN);
        burner.addAttribute("class", "tabBorder");
        burner.elementStart("img");
        burner.addAttribute("height", STR_ONE);
        burner.addAttribute("width", STR_ONE);
        burner.addAttribute("src", "$WEB$/ps/images/space.gif");
        burner.addAttribute("alt", "");
        burner.elementEnd("img");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        burner.elementEnd("td");
    }

    protected void drawInactiveTab(HtmlBurner burner, Page page) throws XMLStreamException {
        burner.elementStart("td");
        burner.addAttribute("height", STR_EIGHTEEN);
        burner.addAttribute("width", page.getSize());
        burner.elementStart("table");
        burner.addAttribute("width", "100%");
        burner.addAttribute("height", STR_EIGHTEEN);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("border", STR_ZERO);
        burner.elementStart("td");
        burner.elementStart("img");
        burner.addAttribute("height", STR_ONE);
        burner.addAttribute("width", page.getSize());
        burner.addAttribute("src", "$WEB$/ps/images/space.gif");
        burner.addAttribute("alt", "");
        burner.elementEnd("img");
        burner.elementEnd("td");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("height", STR_EIGHTEEN);
        burner.addAttribute("align", "center");
        burner.addAttribute("class", "tableText");
        burner.elementStart("a");
        String pageHref = page.getHref();
        burner.addAttribute("href", pageHref);
        ControlHelper.addLocalizedString(burner, page.getTitle());
        burner.elementEnd("a");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("height", STR_ONE);
        burner.addAttribute("width", page.getSize());
        burner.addAttribute("class", "tabBorder");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        burner.elementEnd("td");
    }

    protected void drawActiveTab(HtmlBurner burner, Page page) throws XMLStreamException {
        burner.elementStart("td");
        burner.addAttribute("height", STR_EIGHTEEN);
        burner.addAttribute("width", page.getSize());
        burner.elementStart("table");
        burner.addAttribute("width", "100%");
        burner.addAttribute("height", STR_EIGHTEEN);
        burner.addAttribute("cellspacing", STR_ZERO);
        burner.addAttribute("cellpadding", STR_ZERO);
        burner.addAttribute("border", STR_ZERO);
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("class", "tabBorder");
        burner.elementStart("img");
        burner.addAttribute("height", STR_ONE);
        burner.addAttribute("width", page.getSize());
        burner.addAttribute("src", "$WEB$/ps/images/space.gif");
        burner.addAttribute("alt", "");
        burner.elementEnd("img");
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementStart("tr");
        burner.elementStart("td");
        burner.addAttribute("height", STR_EIGHTEEN);
        burner.addAttribute("width", STR_TWO_K);
        burner.addAttribute("align", "center");
        burner.addAttribute("class", "portlet-form-field-label");
        ControlHelper.addLocalizedString(burner, page.getTitle());
        burner.elementEnd("td");
        burner.elementEnd("tr");
        burner.elementEnd("table");
        burner.elementEnd("td");
    }
}

