/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.qsat.fragmentproducer.ui.configuration;

import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.schemas.fragments.Fragment;
import com.cognos.portal.schemas.fragments.Markup;
import com.cognos.portal.utils.XMLString;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.stream.XMLRecorderStreamWriter;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen.HtmlBurner;
import com.cognos.xqebifw.adminconsole.fragmentproducer.htmlgen.StaxBurner;
import com.cognos.xqebifw.adminconsole.fragmentproducer.jest.TemplatePage;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration.StringResources;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration.UITemplatesUtility;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration.WebKit;
import com.cognos.xqebifw.adminconsole.fragmentproducer.ui.configuration.WebParameters;
import com.cognos.xqebifw.adminconsole.qsat.fragmentproducer.ui.configuration.HTMLQSATTranslator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.IOUtils;

public class RenderQSATExecutor {
    private static final String EMPTY_STRING = "";
    private StageContext mcontext;
    private WebParameters mwebParameters = new WebParameters();
    private String msResults = "";
    private static final String UNEXPECTED_EXCEPTION = "Unexpected Exception";
    XQELogger errorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public WebParameters getWebParameters() {
        return this.mwebParameters;
    }

    public void setWebParameters(WebParameters webParameters) {
        this.mwebParameters = webParameters;
    }

    private void loadParameters() throws PipelineException {
        try {
            this.mwebParameters = new WebParameters(this.mcontext);
        }
        catch (Exception e) {
            this.errorLogger.log(e);
            this.generateErrorReply(UNEXPECTED_EXCEPTION, e);
            return;
        }
    }

    public void execute(StageContext context) throws PipelineException {
        this.mcontext = context;
        this.loadParameters();
        this.doRequest();
    }

    protected void doRequest() throws PipelineException {
        try {
            this.transform();
        }
        catch (Exception e) {
            this.errorLogger.log(e);
            this.generateErrorReply(UNEXPECTED_EXCEPTION, e);
            return;
        }
        try {
            this.reply();
        }
        catch (Exception e) {
            this.errorLogger.log(e);
            this.generateErrorReply(UNEXPECTED_EXCEPTION, e);
            return;
        }
    }

    protected void transform() throws XMLStreamException, PipelineException, IOException {
        this.getAdminResult();
    }

    protected void getAdminResult() throws XMLStreamException, PipelineException, IOException {
        WebKit webKit = this.mwebParameters.getWebKit();
        Locale productLocale = webKit.getProductLocale();
        HTMLQSATTranslator translator = new HTMLQSATTranslator(this.mcontext, productLocale);
        translator.translate();
        String htmlResult = translator.getStringResults();
        htmlResult = UITemplatesUtility.replaceCommonsBasicScripts(webKit, new StringBuilder(htmlResult)).toString();
        TemplatePage tp = new TemplatePage();
        Reader reader = this.mcontext.getInputAsReader("markup");
        StringWriter writer = new StringWriter();
        IOUtils.copy((Reader)reader, (Writer)writer);
        tp.setPage(writer.toString());
        tp.replaceTag("jest:content", "page", htmlResult);
        ResourceBundle rb = StringResources.getResourceBundle(StringResources.getGsResourceName(), productLocale);
        if (rb == null) {
            rb = StringResources.getResourceBundle(StringResources.getGsResourceName(), LocaleConverter.strToLocale("en"));
        }
        tp.addResourceBundle(rb);
        boolean decorate = false;
        tp.replaceResourceStrings(decorate);
        this.msResults = tp.toString();
    }

    protected void reply() throws XMLStreamException, PipelineException {
        Fragment fragment = this.mcontext.getFragment();
        Markup markup = new Markup();
        markup.setMarkupString(this.msResults);
        fragment.addMarkup(markup);
    }

    protected void generateErrorReply(String message, Exception e) throws PipelineException {
        try {
            XMLRecorderStreamWriter writer = new XMLRecorderStreamWriter();
            Locale productLocale = this.mwebParameters.getProductLocale();
            HtmlBurner burner = new HtmlBurner((XMLStreamWriter)writer, productLocale);
            if (e.getMessage() == null) {
                ((StaxBurner)burner).errorMessage(message, "NullPointerException");
            } else {
                ((StaxBurner)burner).errorMessage(message, e.getMessage());
            }
            XMLString xmlString = new XMLString(writer.toXMLStreamReader());
            this.msResults = xmlString.toString();
            this.reply();
        }
        catch (Exception eBad) {
            throw new PipelineException(message.toString(), (Throwable)e);
        }
    }
}

