/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.server;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.xqebifw.management.XqeAgent;
import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

final class AdminConsoleDefaultConfigUtility {
    private static JMXConnector cntor = null;
    private static final String STR_GETMETHODNAME_XQEJMX_MBEAN = "getAllQSInstancesJMXURL";
    private static URL dispatcher = null;
    private static String dispatcherPwd = null;
    private static final String INTERNAL_DISPATCHER = "internalDispatcher";

    AdminConsoleDefaultConfigUtility() {
    }

    public static String getDispatcherDefaultPassword() {
        if (dispatcherPwd == null) {
            AdminConsoleDefaultConfigUtility.fetchDispatcherCredentials();
        }
        return dispatcherPwd;
    }

    public static String[] getDefaultXqeJmxUrl() {
        String[] array = null;
        try {
            if (cntor == null) {
                cntor = AdminConsoleDefaultConfigUtility.getDispatcherHessianConnection();
            }
            MBeanServerConnection mbeanServerConnection = cntor.getMBeanServerConnection();
            ObjectName obName = new ObjectName("com.cognos:type=config,service=XqeJMXConfigMBean");
            array = (String[])mbeanServerConnection.invoke(obName, STR_GETMETHODNAME_XQEJMX_MBEAN, null, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException(e);
        }
        return array;
    }

    private static JMXConnector getDispatcherHessianConnection() {
        if (cntor == null) {
            try {
                String dispJxmUrl;
                if (dispatcher == null || dispatcherPwd == null) {
                    AdminConsoleDefaultConfigUtility.fetchDispatcherCredentials();
                }
                if ((dispJxmUrl = XqeAgent.makeDispatcherJmxUrl(dispatcher, false)) == null) {
                    throw new IllegalStateException("Unable to set up Dispatcher JMX URL based on Dispatcher URL: " + dispatcher);
                }
                JMXServiceURL url = new JMXServiceURL(dispJxmUrl);
                HashMap<String, Object> env = new HashMap<String, Object>();
                byte[] token = CryptoProvider.getToken((byte[])dispatcherPwd.getBytes());
                env.put("jmx.remote.credentials", token);
                env.put("request.waiting.timeout", 300000);
                cntor = JMXConnectorFactory.connect(url, env);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return cntor;
    }

    private static void fetchDispatcherCredentials() {
        try {
            if (dispatcher == null || dispatcherPwd == null || dispatcherPwd.equals("")) {
                ICCLConfiguration cclConfig = null;
                cclConfig = CCLConfigurationFactory.getInstance();
                cclConfig.init();
                dispatcher = new URL(cclConfig.getValue(INTERNAL_DISPATCHER, false));
                dispatcherPwd = cclConfig.getValue("disp_sharedsecret", false);
            }
        }
        catch (CCLConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

