/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.adminconsole.server;

import com.cognos.xqebifw.adminconsole.server.AbstractXqeUIBean;
import com.cognos.xqebifw.adminconsole.server.JmxUtils;
import com.cognos.xqebifw.adminconsole.server.XqeConfigEnum;
import com.cognos.xqebifw.adminconsole.server.XqeConfigEnums;
import com.cognos.xqebifw.adminconsole.server.XqeConfigurationBean;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XqeConfigurationElementBean
extends AbstractXqeUIBean {
    private XqeConfigurationElementType mType = null;
    private Object mDependingParent = null;
    private Set<Object> mDependentChildrens = new HashSet<Object>();
    String mDependsOn = null;
    String mDependingValue = null;
    private String mJmxAttributeName = null;
    private boolean isDirty = false;

    public void setMDependingParent(Object dependingParent) {
        this.mDependingParent = dependingParent;
    }

    public Object getMDependingParent() {
        return this.mDependingParent;
    }

    public Set<Object> getMDependentChildren() {
        return this.mDependentChildrens;
    }

    public void addMDependentChild(Object dependentChild) {
        for (XqeConfigurationElementBean xqeConfigurationElementBean : this.mDependentChildrens) {
            if (!xqeConfigurationElementBean.getName().equals(((XqeConfigurationElementBean)dependentChild).getName())) continue;
            return;
        }
        this.mDependentChildrens.add(dependentChild);
    }

    public Object getDependsOn() {
        return this.mDependsOn;
    }

    public String getDependentValue() {
        return this.mDependingValue;
    }

    XqeConfigurationElementBean(String name) {
        super(name);
    }

    public void setValue(Object value) {
        if (value != null && !value.equals(this.mValue)) {
            this.mValue = value;
            this.isDirty = true;
        }
    }

    public void save(String dispatcherName) {
        if (this.isDirty) {
            JmxUtils.setConfigAttributeValue(this.getJmxAttributeName(), this.getValue(), dispatcherName);
        }
    }

    public String getJmxAttributeName() {
        return this.mJmxAttributeName;
    }

    public void load(String dispatcherName) {
        this.mValue = JmxUtils.getConfigAttributeValue(this.getJmxAttributeName(), dispatcherName);
    }

    public XqeConfigurationElementType getType() {
        return this.mType;
    }

    public void setType(XqeConfigurationElementType type) {
        this.mType = type;
    }

    public void addEnum(XqeConfigEnum pEnum) {
        if (this.mEnums == null) {
            this.mEnums = new ArrayList();
        }
        this.mEnums.add(pEnum);
    }

    public void readconfigurationElement(Node node) {
        Node jmxAttributeName;
        NamedNodeMap attributes = node.getAttributes();
        String type = attributes.getNamedItem("type").getNodeValue();
        this.mType = "enum".equals(type) ? XqeConfigurationElementType.Enumeration : ("numeric".equals(type) ? XqeConfigurationElementType.Numeric : ("date".equals(type) ? XqeConfigurationElementType.Date : XqeConfigurationElementType.Character));
        if (this.mType.equals((Object)XqeConfigurationElementType.Enumeration)) {
            Node configEnumRefNode = attributes.getNamedItem("configEnumRef");
            if (configEnumRefNode != null) {
                String configEnumRef = configEnumRefNode.getNodeValue();
                XqeConfigEnums configEnums = XqeConfigurationBean.getGlobalConfigEnumsRef(configEnumRef);
                if (configEnums != null) {
                    this.mEnums = configEnums.getEnums();
                }
            } else {
                XqeConfigEnums newEnums = new XqeConfigEnums();
                newEnums.readEnums(node);
                this.mEnums = newEnums.getEnums();
            }
        }
        Node configDependsOnNode = attributes.getNamedItem("dependentElement");
        Node configDependentValueNode = attributes.getNamedItem("dependentValue");
        if (configDependsOnNode != null) {
            this.mDependsOn = configDependsOnNode.getNodeValue();
        }
        if (configDependentValueNode != null) {
            this.mDependingValue = configDependentValueNode.getNodeValue();
        }
        if (attributes != null && (jmxAttributeName = attributes.getNamedItem("jmxAttributeName")) != null) {
            this.mJmxAttributeName = jmxAttributeName.getNodeValue();
        }
    }

    public XqeConfigurationElementBean createCopy() {
        XqeConfigurationElementBean newElem = new XqeConfigurationElementBean(this.getName());
        newElem.mJmxAttributeName = this.mJmxAttributeName;
        newElem.mType = this.mType;
        newElem.mEnums = this.mEnums;
        newElem.mDependsOn = this.mDependsOn;
        newElem.mDependingValue = this.mDependingValue;
        newElem.mDependingParent = null;
        newElem.mDependentChildrens = new HashSet<Object>();
        return newElem;
    }

    public static enum XqeConfigurationElementType {
        Numeric,
        Character,
        Enumeration,
        Date;

    }
}

