/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.metadata.mdquery.MDQueryAdapter;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqebifw.bibushandler.ExecuteMetadataRequestAdapter;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ProviderMetadataRequestAdapter
extends RequestAdapter {
    private static final String PROVIDER_METADATA = "providerMetadata";

    @Override
    public ResponseAdapter executeRequest(RequestEnvironment reqEnv) throws XQEException, IOException {
        return this.executeRequest(reqEnv, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAdapter executeRequest(RequestEnvironment reqEnv, boolean bAddContentType) throws XQEException, IOException {
        BIBusEnvelope requestEnvelope = reqEnv.getRequestEnvelope();
        Element rootElement = requestEnvelope.getBody().element(PROVIDER_METADATA).createCopy("command");
        rootElement.detach();
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
        BIBusEnvelope responseEnvelope = null;
        List attachmentList = Collections.emptyList();
        this.logV5Request(rootElement, "queriesPlanned", reqEnv.getReportName());
        responseEnvelope = new BIBusEnvelope();
        XQETrace trace = new XQETrace();
        QueryEngineLoggingUtils.addExecutionTraceLevels(trace, reqEnv);
        executionEnvironment.setTrace(trace);
        String infoValue = "false";
        try {
            MDQueryAdapter adapter = new MDQueryAdapter();
            String response = adapter.execute(reqEnv, rootElement.asXML());
            Document d = DocumentHelper.parseText((String)response);
            Element responseElement = d.getRootElement();
            responseElement.detach();
            if (bAddContentType) {
                InputStream resultStream = ExecuteMetadataRequestAdapter.generateMetadataResponse(responseElement, reqEnv, bAddContentType);
                if (resultStream != null) {
                    attachmentList = new ArrayList(1);
                    attachmentList.add(resultStream);
                }
            } else {
                responseEnvelope.getBody().add(responseElement);
            }
        }
        catch (Throwable t) {
            this.failQueryReThrowAsXQERTE(reqEnv, rootElement, t, "");
        }
        finally {
            MetricsService.collectMetricInfo(reqEnv, "isV5QueryExecuted", infoValue);
            executionEnvironmentContext.exit();
        }
        return new SimpleResponseAdapter(responseEnvelope, attachmentList);
    }

    @Override
    public String getOperationName() {
        return PROVIDER_METADATA;
    }

    @Override
    public void setEngine(QueryEngine newEngine) {
        super.setEngine(newEngine);
    }
}

