/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqebifw.bibushandler.QSAdminTaskProvider;
import com.cognos.xqebifw.bibushandler.ROLAPCubeAdminCommandRequestUtility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ROLAPQSAdminTaskProvider
extends QSAdminTaskProvider {
    public static final String PROVIDER_TYPE = "ROLAP";
    public static final String EXCPETION_ELEMENT_NAME = "exception";
    public static final String COMMANDSTATUS_ELEMENT_NAME = "commandStatus";
    public static final String COMMAND_ELEMENT_NAME = "command";
    public static final String RESPONSE_ELEMENT_NAME = "response";
    public static final String REFRESHCUBEDATACACHE_ELEMENT_NAME = "refreshROLAPCubeDataCache";
    public static final String REFRESHCUBEMEMBERCACHE_ELEMENT_NAME = "refreshROLAPCubeMemberCache";
    public static final String REFRESHCUBESECURITY_ELEMENT_NAME = "refreshROLAPCubeSecurity";
    public static final String RESTARTCUBES_ELEMENT_NAME = "restartROLAPCubes";
    public static final String STARTCUBES_ELEMENT_NAME = "startROLAPCubes";
    public static final String STOPCUBES_ELEMENT_NAME = "stopROLAPCubes";
    public static final String PAUSECUBES_ELEMENT_NAME = "pauseROLAPCubes";
    public static final String INCREMENTALLYLOADCUBES_ELEMENT_NAME = "incrementallyLoadROLAPCubes";
    public static final String TRANSACTIONID_ELEMENT_NAME = "transactionID";
    public static final String STOPCUBESIMMEDIATELY_ELEMENT_NAME = "stopROLAPCubesImmediately";
    public static final String STARTCUBESANDSOURCECUBES_ELEMENT_NAME = "startROLAPCubesAndSourceCubes";
    public static final String CLEARCUBEWORKLOADLOG_ELEMENT_NAME = "clearROLAPCubeWorkloadLog";

    public ROLAPQSAdminTaskProvider(Element options) {
        super(options);
    }

    @Override
    public ResponseAdapter execute(BIBusEnvelope env) throws XQEException {
        ROLAPCubeAdminCommandRequestUtility.logRequestBody(env);
        String operationString = null;
        ArrayList<String> cubeNames = null;
        Element valueElement = this.options.element("value");
        Iterator iter = valueElement.elementIterator();
        while (iter.hasNext()) {
            Element itemElement = (Element)iter.next();
            List attrList = itemElement.attributes();
            Attribute attr = null;
            for (int i = 0; i < attrList.size(); ++i) {
                attr = (Attribute)attrList.get(i);
                if (!attr.getQualifiedName().equals("xsi:type")) continue;
                if (attr.getValue().equals("cm:genericOptionBoolean") || attr.getValue().equals("bus:genericOptionBoolean")) {
                    operationString = this.getROLAPOperationName(itemElement);
                    continue;
                }
                if (!attr.getValue().equals("cm:genericOptionStringArray") && !attr.getValue().equals("bus:genericOptionStringArray")) continue;
                cubeNames = this.getROLAPCubeNames(itemElement);
            }
        }
        String operationName = this.getOperationName(operationString);
        Object[] params = null;
        if (operationString.indexOf(STARTCUBESANDSOURCECUBES_ELEMENT_NAME) >= 0) {
            params = new Object[]{Boolean.TRUE};
        }
        if (operationString.indexOf(STOPCUBESIMMEDIATELY_ELEMENT_NAME) >= 0) {
            params = new Object[]{Boolean.TRUE};
        }
        ResponseAdapter response = ROLAPCubeAdminCommandRequestUtility.executeRequest(env, operationName, cubeNames, params);
        return response;
    }

    private String getROLAPOperationName(Element item) {
        Iterator iter = item.elementIterator();
        while (iter.hasNext()) {
            Element ele = (Element)iter.next();
            if (!ele.getName().equals("name")) continue;
            return ele.getTextTrim();
        }
        return null;
    }

    private ArrayList<String> getROLAPCubeNames(Element item) {
        ArrayList<String> cubeList = new ArrayList<String>();
        Element valueElement = item.element("value");
        Iterator iter = valueElement.elementIterator();
        Element ele = null;
        while (iter.hasNext()) {
            ele = (Element)iter.next();
            cubeList.add(ele.getTextTrim());
        }
        return cubeList;
    }

    private String getOperationName(String opName) {
        if (opName.indexOf(REFRESHCUBEDATACACHE_ELEMENT_NAME) >= 0) {
            return "refreshCubeDataCache";
        }
        if (opName.indexOf(REFRESHCUBEMEMBERCACHE_ELEMENT_NAME) >= 0) {
            return "refreshCubeMemberCache";
        }
        if (opName.indexOf(REFRESHCUBESECURITY_ELEMENT_NAME) >= 0) {
            return "refreshCubeSecurity";
        }
        if (opName.indexOf(RESTARTCUBES_ELEMENT_NAME) >= 0) {
            return "restartCubes";
        }
        if (opName.indexOf(STARTCUBESANDSOURCECUBES_ELEMENT_NAME) >= 0) {
            return "startCubes";
        }
        if (opName.indexOf(STARTCUBES_ELEMENT_NAME) >= 0) {
            return "startCubes";
        }
        if (opName.indexOf(STOPCUBESIMMEDIATELY_ELEMENT_NAME) >= 0) {
            return "stopCubes";
        }
        if (opName.indexOf(STOPCUBES_ELEMENT_NAME) >= 0) {
            return "stopCubes";
        }
        if (opName.indexOf(PAUSECUBES_ELEMENT_NAME) >= 0) {
            return "pauseCubes";
        }
        if (opName.indexOf(INCREMENTALLYLOADCUBES_ELEMENT_NAME) >= 0) {
            return "incrementallyLoadCubes";
        }
        if (opName.indexOf(CLEARCUBEWORKLOADLOG_ELEMENT_NAME) >= 0) {
            return "clearCubeWorkloadLog";
        }
        return opName;
    }
}

