/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.xqe.bibushandler.CancelableRequestRegistry;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;

public abstract class RequestAdapter {
    private static final String NULL_CANCELABLE_REQUEST_REGISTRY = "null == cancelableRequestRegistry";
    protected static final String CONSOLE_LOGGED_INFO_QUERYPLANNED = "Query planned by XQE...";
    protected static final String CONSOLE_LOGGED_INFO_QUERYNOTPLANNED = "Query not planned by XQE...";
    protected static final String V5QUERY_NOT_PLANNED_DIR = "queriesNotPlanned";
    protected static final String V5QUERY_PLANNED_DIR = "queriesPlanned";
    protected static final String V5QUERY_UNRESOLVED_PARAMS_DIR = "queriesUnresolvedParameters";
    protected AtomicInteger requestNumber = new AtomicInteger(0);
    protected static final String STRING_FALSE = "false";
    protected static final String STRING_DOT_XML = ".xml";
    protected static final String STRING_UNDERSCORE = "_";
    protected boolean binaryAttachment = false;
    protected static final byte[] XML_STREAM_TYPE = "xml".getBytes();
    protected static final byte[] BIN_STREAM_TYPE = "bin".getBytes();
    private static final int NAME_LENGTH = 7;
    protected static final SimpleResponseAdapter NULL_RESPONSE_ADAPTER = new SimpleResponseAdapter(null, Collections.EMPTY_LIST);
    protected static final String XML_CONTENT_TYPE_HEADER = "Content-Type: text/xml; charset=utf-8\r\n\r\n";
    private QueryEngine engine;
    protected static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    protected synchronized QueryEngine getEngine() {
        return this.engine;
    }

    public void init() {
    }

    public synchronized void setEngine(QueryEngine newEngine) {
        this.engine = newEngine;
    }

    public abstract ResponseAdapter executeRequest(RequestEnvironment var1) throws XQEException, IOException;

    public abstract String getOperationName();

    public boolean hasCompressedAttachment() {
        return false;
    }

    protected boolean requiresCancelableRegistration() {
        return true;
    }

    public boolean sequentializeRequestsInSession() {
        return true;
    }

    public boolean requiresMultiRequestContext() {
        return true;
    }

    public void registerCancelable(RequestEnvironment requestEnvironment) {
        String requestID;
        if (this.requiresCancelableRegistration() && (requestID = requestEnvironment.getRequestID()) != null) {
            CancelableRequestRegistry cancelableRequestRegistry = requestEnvironment.getCancelableRequestRegistry();
            if (null == cancelableRequestRegistry) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, NULL_CANCELABLE_REQUEST_REGISTRY);
            }
            cancelableRequestRegistry.registerCancelable(requestID, ((ExecutionEnvironment)requestEnvironment.getExecutionEnvironment()).getCancelManager());
        }
    }

    public void deregisterCancelable(RequestEnvironment requestEnvironment) {
        String requestID;
        if (this.requiresCancelableRegistration() && (requestID = requestEnvironment.getRequestID()) != null) {
            CancelableRequestRegistry cancelableRequestRegistry = requestEnvironment.getCancelableRequestRegistry();
            if (null == cancelableRequestRegistry) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, NULL_CANCELABLE_REQUEST_REGISTRY);
            }
            cancelableRequestRegistry.deregisterCancelable(requestID, ((ExecutionEnvironment)requestEnvironment.getExecutionEnvironment()).getCancelManager());
        }
    }

    protected void logV5Request(Element v5Request, String logDir, String reportName) {
        MultiRequestContext multiRequestContext = ExecutionEnvironmentContext.getExecutionEnvironment().getMultiRequestContext();
        XQEConfiguration configuration = multiRequestContext.getXQEConfiguration();
        StringBuilder configPath = new StringBuilder("queryPlanning.logV5Query.");
        configPath.append(logDir);
        configPath.append(".[@enabled]");
        if (!multiRequestContext.fetchBooleanConfiguration(configPath.toString(), false)) {
            return;
        }
        StringBuilder logsDirectory = new StringBuilder(configuration.getXqeLogsDirectory());
        logsDirectory.append(File.separatorChar);
        logsDirectory.append(logDir);
        File f = new File(logsDirectory.toString());
        if (!f.exists()) {
            f.mkdir();
        }
        logsDirectory.append(File.separatorChar);
        logsDirectory.append(this.getClass().getSimpleName());
        logsDirectory.append(STRING_UNDERSCORE);
        if (reportName == null || reportName.length() == 0) {
            logsDirectory.append("V5Request");
            logsDirectory.append(this.requestNumber.getAndAdd(1));
        } else {
            if (reportName.indexOf("/") != -1) {
                int indexOfReportName = reportName.lastIndexOf("@name=") + 7;
                String quote = reportName.substring(indexOfReportName - 1, indexOfReportName);
                reportName = reportName.substring(indexOfReportName);
                reportName = reportName.replace(quote + "]", "");
            }
            logsDirectory.append("V5_");
            logsDirectory.append(reportName);
            File logFile = new File(logsDirectory.toString() + STRING_DOT_XML);
            if (logFile.exists()) {
                logsDirectory.append(STRING_UNDERSCORE);
                logsDirectory.append(this.requestNumber.getAndAdd(1));
            }
        }
        logsDirectory.append(STRING_DOT_XML);
        File file = new File(logsDirectory.toString());
        try {
            BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(file));
            XMLWriter writer = new XMLWriter((OutputStream)outStream);
            writer.write(RequestAdapter.obfuscateV5Request(v5Request));
            writer.close();
        }
        catch (Exception ex) {
            mErrorLogger.log(ex);
        }
    }

    public static Element obfuscateV5Request(Element v5Request) {
        Element camPassport;
        Element strippedRequest = (Element)v5Request.clone();
        strippedRequest.detach();
        Element connection = strippedRequest.element("connection");
        if (null != connection && null != (camPassport = connection.element("CAMPassport"))) {
            camPassport.attribute("value").setValue("*****");
        }
        return strippedRequest;
    }

    protected void failQuery(RequestEnvironment environment, Element v5RootElement, String metricName, Throwable cause) {
        if (cause != null) {
            mErrorLogger.log(cause);
        }
        XQELog.logConsole(CONSOLE_LOGGED_INFO_QUERYNOTPLANNED);
        MetricsService.collectMetricInfo(environment, metricName, STRING_FALSE);
        this.logV5Request(v5RootElement, V5QUERY_NOT_PLANNED_DIR, environment.getReportName());
    }

    protected void failQueryReThrowAsXQERTE(RequestEnvironment environment, Element v5RootElement, Throwable t, String metricName) {
        XQERuntimeException xqeRTException = null;
        xqeRTException = t == null ? new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed) : (t instanceof XQERuntimeException ? (XQERuntimeException)t : new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed, t));
        this.failQuery(environment, v5RootElement, metricName, xqeRTException);
        throw xqeRTException;
    }

    public void release() {
    }
}

