/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqebifw.bibushandler.QSAdminTaskProvider;
import com.cognos.xqebifw.bibushandler.ROLAPQSAdminTaskProvider;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.content.CMQuery;
import java.io.IOException;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class RunAdminCommandRequestAdapter
extends RequestAdapter {
    public static final String QUERY_SERVICE_ADMIN_NAME = "name";
    public static final String QUERY_SERVICE_ADMIN_ITEM = "item";
    public static final String QUERY_SERVICE_ADMIN_VALUE = "value";
    public static final String QUERY_SERVICE_ADMIN_OPTIONS = "options";
    private static final String QUERY_SERVICE_ADMIN_OBJECT_CLASS = "objectClass";
    private static final String QUERY_SERVICE_ADMIN_OBJECT_PATH = "objectPath";
    XQELogger errorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    public static final String RUNCOMMAND_OP_NAME = "run";
    public static final String ITEM_ELEMENT_NAME = "item";
    public static final String CUBENAMES_ELEMENT_NAME = "cubeNames";
    public static final String COMMANDSTATUS_ELEMENT_NAME = "commandStatus";
    public static final String COMMAND_ELEMENT_NAME = "command";
    public static final String RESPONSE_ELEMENT_NAME = "response";
    public static final String CUBESTATUSLIST_ELEMENT_NAME = "cubeStatusList";
    public static final String CUBESTATUS_ELEMENT_NAME = "cubeStatus";
    public static final String NAME_ELEMENT_NAME = "name";
    public static final String STATUS_ELEMENT_NAME = "status";
    public static final String EXCPETION_ELEMENT_NAME = "exception";
    public static final String SUCCESS_STR = "Success";
    public static final String FAIL_STR = "Fail";

    @Override
    public ResponseAdapter executeRequest(RequestEnvironment environment) throws XQEException, IOException {
        BIBusEnvelope requestEnvelope = environment.getRequestEnvelope();
        Element runElement = (Element)requestEnvelope.getBody().element(RUNCOMMAND_OP_NAME).clone();
        Document requestDocument = DocumentHelper.createDocument((Element)runElement);
        ResponseAdapter ra = this.runCommand(requestDocument, requestEnvelope);
        return ra;
    }

    @Override
    public String getOperationName() {
        return RUNCOMMAND_OP_NAME;
    }

    @Override
    protected boolean requiresCancelableRegistration() {
        return false;
    }

    @Override
    public boolean requiresMultiRequestContext() {
        return false;
    }

    public ResponseAdapter runCommand(Document requestDocument, BIBusEnvelope envelope) throws XQEException {
        Element requestHeader = (Element)((Element)envelope.getBIBusHeader().clone()).detach();
        Element objectPath = requestDocument.getRootElement().element(QUERY_SERVICE_ADMIN_OBJECT_PATH);
        String path = objectPath.getTextTrim();
        Element queryServiceAdminTask = this.getTaskDetailsFromCM(path, requestHeader);
        QSAdminTaskProvider adminTaskProvider = this.getQSAdminTaskProviderType(queryServiceAdminTask);
        ResponseAdapter ra = adminTaskProvider.execute(envelope);
        return ra;
    }

    private Element getTaskDetailsFromCM(String path, Element requestHeader) {
        CMQuery query = new CMQuery(path);
        query.setBIBusHeader(requestHeader);
        query.addQueryPropertyName(QUERY_SERVICE_ADMIN_OPTIONS);
        query.addQueryPropertyName(QUERY_SERVICE_ADMIN_OBJECT_CLASS);
        Element queryServiceAdminTask = null;
        try {
            query.execute();
            List resultList = query.getResultList();
            for (CMClass cmResult : resultList) {
                queryServiceAdminTask = cmResult.getItemElement();
            }
            queryServiceAdminTask.detach();
        }
        catch (CommandExecutionException ce) {
            XQERuntimeException exception = new XQERuntimeException(XQEMessageKeys.UI_xqeROLAPQSATCMFetchException, (Throwable)ce);
            this.errorLogger.log(LogLevel.ERROR, (Throwable)exception);
            this.errorLogger.log(ce);
            this.errorLogger.log("Searchpath  :" + path);
            throw exception;
        }
        return queryServiceAdminTask;
    }

    private QSAdminTaskProvider getQSAdminTaskProviderType(Element inputQueryServiceAdminTask) {
        Element taskOptions = inputQueryServiceAdminTask.element(QUERY_SERVICE_ADMIN_OPTIONS);
        Element taskOptionValues = taskOptions.element(QUERY_SERVICE_ADMIN_VALUE);
        List taskOptionItems = taskOptionValues.elements("item");
        for (Element option : taskOptionItems) {
            String paramName = this.getParameter(option.elementText("name"));
            if (!paramName.equalsIgnoreCase("refreshROLAPCubeDataCache") && !paramName.equalsIgnoreCase("refreshROLAPCubeMemberCache") && !paramName.equalsIgnoreCase("refreshROLAPCubeSecurity") && !paramName.equalsIgnoreCase("restartROLAPCubes") && !paramName.equalsIgnoreCase("clearROLAPCubeWorkloadLog") && !paramName.equalsIgnoreCase("startROLAPCubes") && !paramName.equalsIgnoreCase("stopROLAPCubes") && !paramName.equalsIgnoreCase("pauseROLAPCubes") && !paramName.equalsIgnoreCase("incrementallyLoadROLAPCubes") && !paramName.equalsIgnoreCase("stopROLAPCubesImmediately") && !paramName.equalsIgnoreCase("startROLAPCubesAndSourceCubes")) continue;
            return new ROLAPQSAdminTaskProvider(taskOptions);
        }
        return null;
    }

    private String getParameter(String elementText) {
        int index = elementText.indexOf("#");
        if (index != -1) {
            return elementText.substring(index + 1);
        }
        return elementText;
    }
}

