/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqebifw.bibushandler.ConnectionTester;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import java.rmi.server.UID;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class TestDataSourceConnectionWithInfoRequestAdapter
extends RequestAdapter {
    private static final String TEST_DATA_SOURCE_CONNECTION_WITH_INFO_ELEMENT_NAME = "testDataSourceConnectionWithInfo";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAdapter executeRequest(RequestEnvironment reqEnv) throws XQEException {
        BIBusEnvelope requestEnvelope = reqEnv.getRequestEnvelope();
        Element v5RootElement = requestEnvelope.getBody().element(TEST_DATA_SOURCE_CONNECTION_WITH_INFO_ELEMENT_NAME);
        v5RootElement.detach();
        Document requestDocument = DocumentHelper.createDocument((Element)v5RootElement);
        if (null == reqEnv.getSessionContextID()) {
            reqEnv.setSessionContextID(new UID().toString());
        }
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
        MultiRequestContext multiRequestContext = QueryEngine.getInstance().configureMultiRequestContext(reqEnv, requestDocument);
        multiRequestContext.incrementRefCount();
        List<XQEMessage> databaseInformation = null;
        reqEnv.initializeRequestPAC(executionEnvironment.getConnectionElement());
        try {
            databaseInformation = ConnectionTester.testDataSourceConnection(requestDocument, reqEnv);
        }
        finally {
            multiRequestContext.decrementRefCount();
            executionEnvironmentContext.exit();
        }
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        List attachmentList = Collections.emptyList();
        Document responseDocument = DocumentHelper.createDocument();
        Element responseElement = responseDocument.addElement("response");
        responseEnvelope.getBody().add(responseElement);
        if (databaseInformation != null) {
            Locale locale = reqEnv.getProductLocale();
            Element connectionInfo = responseElement.addElement("connectionInfo");
            for (int i = 0; i < databaseInformation.size(); ++i) {
                Element msg = connectionInfo.addElement("message");
                msg.setText(databaseInformation.get(i).getBody(locale));
            }
        }
        return new SimpleResponseAdapter(responseEnvelope, attachmentList);
    }

    @Override
    public String getOperationName() {
        return TEST_DATA_SOURCE_CONNECTION_WITH_INFO_ELEMENT_NAME;
    }

    @Override
    public boolean requiresMultiRequestContext() {
        return false;
    }

    @Override
    protected boolean requiresCancelableRegistration() {
        return false;
    }
}

