/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.bibushandler.BindErrorsDuringValidateException;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.bibushandler.SyntaxErrorsDuringValidateException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.Nag;
import com.cognos.xqe.query.engine.NagDMRSubquery;
import com.cognos.xqe.query.engine.NagSubquery;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.planner.PlanValidationUtil;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqebifw.bibushandler.ExecuteRequestAdapter;
import com.cognos.xqebifw.bibushandler.RSVP4JHelper;
import com.cognos.xqebifw.bibushandler.RSVP4JResponseAdapter;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.SOAPFaultResponseAdapter;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import com.cognos.xqebifw.bibushandler.XQENodeSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ValidateRequestAdapter
extends RequestAdapter {
    @Override
    public ResponseAdapter executeRequest(RequestEnvironment reqEnv) throws XQEException, IOException {
        return this.executeRequest(reqEnv, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseAdapter executeRequest(RequestEnvironment reqEnv, boolean bAddContentType) throws IOException {
        long startTime = System.currentTimeMillis();
        BIBusEnvelope requestEnvelope = reqEnv.getRequestEnvelope();
        Element v5RootElement = requestEnvelope.getBody().element("validate");
        v5RootElement.detach();
        Document requestDocument = DocumentHelper.createDocument((Element)v5RootElement);
        MetricsService.collectMetricInfo(reqEnv, "requestType", "validate");
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
        MultiRequestContext multiRequestContext = QueryEngine.getInstance().configureMultiRequestContext(reqEnv, requestDocument);
        multiRequestContext.incrementRefCount();
        multiRequestContext.getRequestParameters().getParameters().clearMasterDetailParameters();
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        ArrayList<ByteArrayInputStream> attachmentList = null;
        List<Object> rsvpAttachmentList = null;
        Set<String> executionParameters = null;
        try {
            boolean hasMissingmembers;
            if (null != requestDocument.getRootElement().element("updateSet")) {
                ResponseAdapter responseAdapter = this.validateUpdateQuery(requestDocument, reqEnv);
                return responseAdapter;
            }
            List requestedDatasets = v5RootElement.elements("retrieveDataset");
            ArrayList<String> datasetNames = new ArrayList<String>();
            for (Element datasetName : requestedDatasets) {
                datasetNames.add(datasetName.attributeValue("value"));
            }
            ByteArrayInputStream resultStream = null;
            String charName = "UTF-8";
            Document responseDocument = DocumentHelper.createDocument();
            Element responseElement = responseDocument.addElement("response");
            IXQEQueryNode planTree = null;
            try {
                planTree = this.getEngine().validateRequest(requestDocument, responseDocument, reqEnv);
                this.logV5Request(v5RootElement, "queriesPlanned", reqEnv.getReportName());
            }
            catch (SyntaxErrorsDuringValidateException sre) {
                this.failQuery(reqEnv, v5RootElement, "isV5QueryPlanned", sre);
            }
            catch (BindErrorsDuringValidateException bre) {
                this.failQuery(reqEnv, v5RootElement, "isV5QueryPlanned", bre);
            }
            catch (Throwable t) {
                this.failQueryReThrowAsXQERTE(reqEnv, v5RootElement, t, "isV5QueryPlanned");
            }
            long time = System.currentTimeMillis() - startTime;
            Element missingMembersElement = responseElement.element("missingMembers");
            boolean bl = hasMissingmembers = null != missingMembersElement;
            if (!hasMissingmembers && planTree != null) {
                if (planTree.getNumberChildren() == 0) {
                    MetricsService.collectMetricInfo(reqEnv, "isV5QueryPlanned", "true", time);
                    SimpleResponseAdapter simpleResponseAdapter = new SimpleResponseAdapter(responseEnvelope, Collections.EMPTY_LIST);
                    return simpleResponseAdapter;
                }
                RSAPIDataset rSAPIDataset = (RSAPIDataset)planTree.getChild(0);
                if (rSAPIDataset == null) {
                    MetricsService.collectMetricInfo(reqEnv, "isV5QueryPlanned", "false", time);
                    SOAPFaultResponseAdapter sOAPFaultResponseAdapter = new SOAPFaultResponseAdapter(new Fault(""), false);
                    return sOAPFaultResponseAdapter;
                }
                if (PlanValidationUtil.isRSAPISupportedQuery(rSAPIDataset) == -1) {
                    MetricsService.collectMetricInfo(reqEnv, "isV5QueryPlanned", "true", time);
                } else {
                    MetricsService.collectMetricInfo(reqEnv, "isV5QueryPlanned", "false", time);
                    SOAPFaultResponseAdapter sOAPFaultResponseAdapter = new SOAPFaultResponseAdapter(new Fault(""), false);
                    return sOAPFaultResponseAdapter;
                }
            }
            if (planTree != null) {
                for (IXQEQueryNode node : planTree.getChildrenOfType(401005)) {
                    RSAPIDataset dataSet = (RSAPIDataset)node;
                    if (!dataSet.forDMRReport() || reqEnv.getMaxSeverityLevel() != 3) continue;
                    executionEnvironment.getGovernors().setLocalCache("false");
                    IXQEQueryNode[] mdxs = dataSet.getDescendantsOfType(501053, false);
                    try {
                        for (IXQEQueryNode mdx : mdxs) {
                            ((XMdxLocal)mdx).setExecuteForValidate(true);
                        }
                        QueryEngine.getInstance().executeRSAPIDataset(dataSet, executionEnvironment);
                    }
                    finally {
                        for (IXQEQueryNode mdx : mdxs) {
                            ((XMdxLocal)mdx).setExecuteForValidate(false);
                        }
                    }
                    List<Nag> dmrSQL = executionEnvironment.getNagCollector().getNagOfSubqueryType(NagSubquery.NagSubqueryType.DMR);
                    for (int i = 0; i < dmrSQL.size(); ++i) {
                        NagDMRSubquery nag = (NagDMRSubquery)dmrSQL.get(i);
                        if (nag.getReportQueryName() != null) continue;
                        nag.setReportQueryName(dataSet.getRefQueryName());
                    }
                }
            }
            Element element = v5RootElement.element("queryFeedback");
            executionParameters = reqEnv.getBoundParameters();
            if (!reqEnv.getRSVP4J()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                OutputStreamWriter aWriter = new OutputStreamWriter((OutputStream)baos, charName);
                if (bAddContentType) {
                    aWriter.write("Content-Type: text/xml; charset=utf-8\r\n\r\n");
                }
                XQENodeSerializer.generateValidateResponse(aWriter, planTree, datasetNames, reqEnv, missingMembersElement, element, "validate");
                ((Writer)aWriter).close();
                byte[] attachmentBytes = baos.toByteArray();
                resultStream = new ByteArrayInputStream(attachmentBytes);
                if (resultStream == null) {
                    attachmentList = Collections.EMPTY_LIST;
                } else {
                    attachmentList = new ArrayList<ByteArrayInputStream>(1);
                    attachmentList.add(resultStream);
                    XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
                    boolean allowRefParametersInResponse = config.getBooleanProperty("general.allowRefParametersInResponse[@enabled]", true);
                    if (allowRefParametersInResponse) {
                        byte[] parameterBytes = ExecuteRequestAdapter.generateParameterBytes(bAddContentType, executionParameters, multiRequestContext, reqEnv);
                        attachmentList.add(new ByteArrayInputStream(parameterBytes));
                    }
                }
            } else {
                rsvpAttachmentList = RSVP4JHelper.generateValidateResponse(charName, planTree, datasetNames, reqEnv, missingMembersElement, element, "validate");
            }
        }
        finally {
            multiRequestContext.decrementRefCount();
            executionEnvironmentContext.exit();
        }
        if (reqEnv.getRSVP4J()) {
            return new RSVP4JResponseAdapter(responseEnvelope, rsvpAttachmentList, executionParameters);
        }
        return new SimpleResponseAdapter(responseEnvelope, attachmentList);
    }

    private ResponseAdapter validateUpdateQuery(Document requestDocument, RequestEnvironment environment) {
        try {
            this.getEngine().validateRequest(requestDocument, null, environment);
            this.logV5Request(requestDocument.getRootElement(), "queriesPlanned", environment.getReportName());
        }
        catch (Throwable t) {
            this.failQueryReThrowAsXQERTE(environment, requestDocument.getRootElement(), t, "isV5QueryPlanned");
        }
        Parameters parameters = environment.getRequestParameters();
        Set paramNames = parameters.keySet();
        for (String name : paramNames) {
            parameters.getParameter(name).getParameterValues();
        }
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        Element responseElement = responseEnvelope.getBody().addElement("response");
        responseElement.addElement("connectionID");
        List list = Collections.emptyList();
        return new SimpleResponseAdapter(responseEnvelope, list);
    }

    @Override
    public String getOperationName() {
        return "validate";
    }

    @Override
    public void setEngine(QueryEngine newEngine) {
        super.setEngine(newEngine);
    }
}

