/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.binaryprotocol;

import com.cognos.xqebifw.bibushandler.binaryprotocol.IVarLenByteBufferOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class VarLenByteBufferOutputStream
extends OutputStream
implements IVarLenByteBufferOutputStream {
    private static final ByteOrder NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
    private static final boolean USING_UTF16_ENCODING_FOR_STRING = false;
    private static final String ENCODING_UTF8 = "UTF8";
    private static final int BUFFER_SIZE = 10240;
    private static final int POOL_SIZE = 10;
    private static final int TYPE_SIZE_BOOLEAN = 1;
    private static final byte BOOLEAN_VALUE_TRUE = 1;
    private static final byte BOOLEAN_VALUE_FALSE = 0;
    private static final int TYPE_SIZE_SHORT = 2;
    private static final int TYPE_SIZE_INTEGER = 4;
    private static final int TYPE_SIZE_DOUBLE = 8;
    private static final int TYPE_SIZE_FLOAT = 4;
    private static final int TYPE_SIZE_LONG = 8;
    private static final ConcurrentLinkedQueue<ByteBuffer> GPOOLEDBUFFERS = new ConcurrentLinkedQueue();
    private static final int ACTIVE_BUFFERS_SIZE = 50;
    private ByteBuffer[] mCurrBuffers = new ByteBuffer[50];
    private int[] mCurrBuffersStartAddr = new int[50];
    private int mCurrBufferIdx = 0;
    private int mPosition = 0;

    public VarLenByteBufferOutputStream() {
        this.acquireBuffer();
    }

    @Override
    public void write(int b) throws IOException {
        this.putByte((byte)b);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        for (int i = 0; i < bytes.length; ++i) {
            this.write(bytes[i]);
        }
    }

    @Override
    public void close() throws IOException {
        this.releaseBuffers();
    }

    private void releaseBuffers() {
        int idx;
        int returnSize = 10 - GPOOLEDBUFFERS.size();
        for (idx = 0; idx < returnSize && idx < this.mCurrBufferIdx; ++idx) {
            GPOOLEDBUFFERS.add(this.mCurrBuffers[idx]);
        }
        for (idx = 0; idx < this.mCurrBufferIdx; ++idx) {
            this.mCurrBuffers[idx] = null;
            this.mCurrBuffersStartAddr[idx] = 0;
        }
        this.mCurrBufferIdx = 0;
    }

    protected void finalize() throws Throwable {
        try {
            this.releaseBuffers();
        }
        finally {
            super.finalize();
        }
    }

    private ByteBuffer reserve(int size) {
        ByteBuffer activeBuffer = this.mCurrBuffers[this.mCurrBufferIdx - 1];
        if (activeBuffer.remaining() < size) {
            activeBuffer = this.acquireBuffer();
        }
        return activeBuffer;
    }

    @Override
    public int putBoolean(boolean value) {
        int valuePosition = this.mPosition;
        ByteBuffer activeBuffer = this.reserve(1);
        if (value) {
            activeBuffer.put((byte)1);
        } else {
            activeBuffer.put((byte)0);
        }
        ++this.mPosition;
        return valuePosition;
    }

    @Override
    public int putShort(short value) {
        int valuePosition = this.mPosition;
        ByteBuffer activeBuffer = this.reserve(2);
        activeBuffer.putShort(value);
        this.mPosition += 2;
        return valuePosition;
    }

    @Override
    public int putInt(int value) {
        int valuePosition = this.mPosition;
        ByteBuffer activeBuffer = this.reserve(4);
        activeBuffer.putInt(value);
        this.mPosition += 4;
        return valuePosition;
    }

    @Override
    public int putLong(long value) {
        int valuePosition = this.mPosition;
        ByteBuffer activeBuffer = this.reserve(8);
        activeBuffer.putLong(value);
        this.mPosition += 8;
        return valuePosition;
    }

    @Override
    public int putDouble(double value) {
        int valuePosition = this.mPosition;
        ByteBuffer activeBuffer = this.reserve(8);
        activeBuffer.putDouble(value);
        this.mPosition += 8;
        return valuePosition;
    }

    @Override
    public int putFloat(float value) {
        int valuePosition = this.mPosition;
        ByteBuffer activeBuffer = this.reserve(4);
        activeBuffer.putFloat(value);
        this.mPosition += 4;
        return valuePosition;
    }

    @Override
    public int putString(String value) {
        int valuePosition = this.mPosition;
        if (value == null || value.length() == 0) {
            this.putInt(0);
        } else {
            String encodingName = ENCODING_UTF8;
            byte[] bytes = null;
            try {
                bytes = value.getBytes(encodingName);
            }
            catch (UnsupportedEncodingException ue) {
                throw new RuntimeException(ue);
            }
            this.putInt(bytes.length);
            this.putBytes(bytes, 0, bytes.length);
            this.mPosition += bytes.length;
        }
        return valuePosition;
    }

    @Override
    public int putByte(byte value) {
        int valuePosition = this.mPosition;
        ByteBuffer activeBuffer = this.mCurrBuffers[this.mCurrBufferIdx - 1];
        if (activeBuffer.remaining() < 1) {
            activeBuffer = this.acquireBuffer();
        }
        activeBuffer.put(value);
        ++this.mPosition;
        return valuePosition;
    }

    private void putBytes(byte[] bytes, int off, int len) {
        int curPos = off;
        int remaining = len;
        ByteBuffer activeBuffer = this.mCurrBuffers[this.mCurrBufferIdx - 1];
        while (remaining > 0) {
            int curBufCapacity = activeBuffer.remaining();
            if (curBufCapacity >= remaining) {
                activeBuffer.put(bytes, curPos, remaining);
                remaining = 0;
                continue;
            }
            activeBuffer.put(bytes, curPos, curBufCapacity);
            remaining -= curBufCapacity;
            curPos += curBufCapacity;
            activeBuffer = this.acquireBuffer();
        }
    }

    @Override
    public void updateShort(int aPosition, short value) {
        int updateBuffIdx = this.locateBuffer(aPosition);
        this.mCurrBuffers[updateBuffIdx].putShort(aPosition - this.mCurrBuffersStartAddr[updateBuffIdx], value);
    }

    @Override
    public void updateInt(int aPosition, int value) {
        int updateBuffIdx = this.locateBuffer(aPosition);
        this.mCurrBuffers[updateBuffIdx].putInt(aPosition - this.mCurrBuffersStartAddr[updateBuffIdx], value);
    }

    private int locateBuffer(int aPosition) {
        for (int idx = aPosition / 10240; idx < this.mCurrBufferIdx; ++idx) {
            if (this.mCurrBuffersStartAddr[idx] == aPosition) {
                return idx;
            }
            if (this.mCurrBuffersStartAddr[idx] <= aPosition) continue;
            return idx - 1;
        }
        throw new BufferOverflowException();
    }

    public ByteBuffer getByteBuffer() {
        int size = 0;
        for (int idx = 0; idx < this.mCurrBufferIdx; ++idx) {
            size += this.mCurrBuffers[idx].position();
        }
        ByteBuffer bytes = ByteBuffer.allocate(size);
        bytes.order(NATIVE_BYTE_ORDER);
        for (int idx = 0; idx < this.mCurrBufferIdx; ++idx) {
            ByteBuffer aBuff = this.mCurrBuffers[idx];
            aBuff.flip();
            bytes.put(aBuff);
        }
        this.releaseBuffers();
        return bytes;
    }

    private ByteBuffer acquireBuffer() {
        ByteBuffer outBuff = GPOOLEDBUFFERS.poll();
        if (outBuff == null) {
            outBuff = ByteBuffer.allocate(10240);
            outBuff.order(NATIVE_BYTE_ORDER);
        } else {
            outBuff.clear();
        }
        if (this.mCurrBufferIdx >= this.mCurrBuffers.length) {
            ByteBuffer[] newCurrBuffers = new ByteBuffer[this.mCurrBuffers.length * 2];
            System.arraycopy(this.mCurrBuffers, 0, newCurrBuffers, 0, this.mCurrBuffers.length);
            this.mCurrBuffers = newCurrBuffers;
            int[] newCurrBuffersStartAddr = new int[this.mCurrBuffersStartAddr.length * 2];
            System.arraycopy(this.mCurrBuffersStartAddr, 0, newCurrBuffersStartAddr, 0, this.mCurrBuffersStartAddr.length);
            this.mCurrBuffersStartAddr = newCurrBuffersStartAddr;
        }
        this.mCurrBuffers[this.mCurrBufferIdx] = outBuff;
        this.mCurrBuffersStartAddr[this.mCurrBufferIdx] = this.mPosition;
        ++this.mCurrBufferIdx;
        return outBuff;
    }

    public static boolean endiannessMismatch(String remoteIsLittleEndian) {
        boolean mismatch = null == remoteIsLittleEndian ? false : remoteIsLittleEndian.equals("true") != NATIVE_BYTE_ORDER.equals(ByteOrder.LITTLE_ENDIAN);
        return mismatch;
    }

    static {
        for (int i = 0; i < 10; ++i) {
            ByteBuffer bf = ByteBuffer.allocate(10240);
            bf.order(NATIVE_BYTE_ORDER);
            GPOOLEDBUFFERS.add(bf);
        }
    }
}

