/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content.CMCacheService;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.ContentManagerCacheService_PortType;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.QueryCacheResult;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Session;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.Timer;
import com.cognos.xqebifw.bibushandler.content.BaseCMCommand;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import com.cognos.xqebifw.bibushandler.content.CMQuery;
import com.cognos.xqebifw.bibushandler.content.CMSession;
import com.cognos.xqebifw.bibushandler.content.CMSessionIdentity;
import com.cognos.xqebifw.bibushandler.content.CMUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.axis.AxisFault;

public final class CMSessionViaCMCService
extends CMSession {
    private static final String SEARCH_PATH = "~";
    private static final ClassEnum ACCOUNT_CLASSENUM = ClassEnum.fromString((String)"account");
    private static final ClassEnum SESSION_CLASSENUM = ClassEnum.fromString((String)"session");

    public static CMSession create(IRequestEnvironment env) {
        CMSessionViaCMCService cmS = null;
        cmS = new CMSessionViaCMCService(env);
        if (!CMEntityPool.tryUsingCMCacheService()) {
            return null;
        }
        return cmS;
    }

    private CMSessionViaCMCService(final IRequestEnvironment env) {
        Timer timer = CMQuery.getAndStartTimerForUsageStats();
        try {
            ((RequestEnvironment)env).getCMRequestExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ((RequestEnvironment)env).resetEnvelopeFromExecutor();
                    CMSessionViaCMCService.this.queryForCMInfo(env);
                }
            });
        }
        finally {
            CMQuery.updateCMUsageStats(timer);
        }
    }

    private void queryForCMInfo(IRequestEnvironment env) {
        BiBusHeader bibusHeader = CMUtils.buildBiBusHeader(env);
        ContentManagerCacheService_PortType port = null;
        try {
            BaseClass[] resultObjects;
            port = BaseCMCommand.getContentManagerCacheServicePort(bibusHeader);
            SearchPathSingleObject searchPathSingleObject = new SearchPathSingleObject();
            searchPathSingleObject.set_value(SEARCH_PATH);
            ClassEnum searchType = ACCOUNT_CLASSENUM;
            ClassEnum[] entries = new ClassEnum[]{SESSION_CLASSENUM};
            ArrayList<Option> optionList = new ArrayList<Option>();
            CMUtils.setOptionsForQueryCache(optionList, env);
            Option[] options = new Option[]{};
            if (optionList.size() > 0) {
                options = optionList.toArray(new Option[optionList.size()]);
            }
            QueryCacheResult qcResult = port.queryCache(searchPathSingleObject, searchType, entries, options);
            CMEntityPool.setIsCMCacheServiceEnabled(true);
            CMUtils.updateCMCacheContext(qcResult.getOptions(), env);
            for (BaseClass object : resultObjects = qcResult.getObjects()) {
                if (object.getObjectClass().getValue() != SESSION_CLASSENUM) continue;
                Session session = (Session)object;
                BaseClassArrayProp identity = session.getIdentity();
                if (identity.getValue() != null) {
                    BaseClass[] idProps;
                    for (BaseClass idProp : idProps = identity.getValue()) {
                        if (idProp.getSearchPath() == null || idProp.getSearchPath().getValue() == null) continue;
                        CMSessionIdentity sessionIden = new CMSessionIdentity(idProp.getSearchPath().getValue(), CMSessionViaCMCService.getType(idProp));
                        this.identities.add(sessionIden);
                    }
                }
                if (session.getTenantID() == null) continue;
                this.sessionTenantID = session.getTenantID().getValue();
            }
        }
        catch (RemoteException e) {
            boolean bIsCMCacheDisabled = false;
            if (e instanceof AxisFault) {
                bIsCMCacheDisabled = CMUtils.parseFaultForDisabledCMCache((AxisFault)e);
            }
            if (!bIsCMCacheDisabled) {
                throw new XQERuntimeException(XQEMessageKeys.CM_UnableToRetrieveSessionIdentities, (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.CM_UnableToRetrieveSessionIdentities, (Throwable)e);
        }
    }

    private static String getType(BaseClass identity) {
        String objName = identity.toString();
        int lastDotIndex = objName.lastIndexOf(46);
        int lastAtIndex = objName.lastIndexOf(64);
        String trimmedObjName = objName.substring(lastDotIndex + 1, lastAtIndex);
        return trimmedObjName.toLowerCase();
    }
}

