/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content.CMCacheService;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.ContentManagerCacheService_PortType;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.QueryCacheResult;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Session;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.ParameterMapCM;
import com.cognos.xqe.util.Timer;
import com.cognos.xqebifw.bibushandler.content.BaseCMCommand;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import com.cognos.xqebifw.bibushandler.content.CMQuery;
import com.cognos.xqebifw.bibushandler.content.CMUser;
import com.cognos.xqebifw.bibushandler.content.CMUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.axis.AxisFault;

public final class CMUserViaCMCService
extends CMUser {
    private static final ClassEnum ACCOUNT_CLASSENUM = ClassEnum.fromString((String)"account");
    private static final ClassEnum SESSION_CLASSENUM = ClassEnum.fromString((String)"session");

    public static CMUser create(IRequestEnvironment env) {
        CMUserViaCMCService cmU = null;
        cmU = new CMUserViaCMCService(env);
        if (!CMEntityPool.tryUsingCMCacheService()) {
            return null;
        }
        return cmU;
    }

    private CMUserViaCMCService(final IRequestEnvironment env) {
        Timer timer = CMQuery.getAndStartTimerForUsageStats();
        try {
            ((RequestEnvironment)env).getCMRequestExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ((RequestEnvironment)env).resetEnvelopeFromExecutor();
                    CMUserViaCMCService.this.queryForCMInfo(env);
                }
            });
        }
        finally {
            CMQuery.updateCMUsageStats(timer);
        }
    }

    private void queryForCMInfo(IRequestEnvironment env) {
        BiBusHeader bibusHeader = CMUtils.buildBiBusHeader(env);
        ContentManagerCacheService_PortType port = null;
        try {
            UserPreferenceVar[] userPreferences;
            BaseClass[] resultObjects;
            port = BaseCMCommand.getContentManagerCacheServicePort(bibusHeader);
            SearchPathSingleObject searchPathSingleObject = new SearchPathSingleObject();
            searchPathSingleObject.set_value("~");
            ClassEnum searchType = ACCOUNT_CLASSENUM;
            ClassEnum[] entries = new ClassEnum[]{ACCOUNT_CLASSENUM, SESSION_CLASSENUM};
            ArrayList<Option> optionList = new ArrayList<Option>();
            CMUtils.setOptionsForQueryCache(optionList, env);
            Option[] options = new Option[]{};
            if (optionList.size() > 0) {
                options = optionList.toArray(new Option[optionList.size()]);
            }
            QueryCacheResult qcResult = port.queryCache(searchPathSingleObject, searchType, entries, options);
            CMEntityPool.setIsCMCacheServiceEnabled(true);
            CMUtils.updateCMCacheContext(qcResult.getOptions(), env);
            boolean foundAccountTimeZoneID = false;
            for (BaseClass object : resultObjects = qcResult.getObjects()) {
                if (object instanceof Session) {
                    if (object.getTenantID() == null || object.getTenantID().getValue() == null) continue;
                    this.addToParmMap("tenantID", object.getTenantID().getValue());
                    continue;
                }
                if (!(object instanceof Account)) continue;
                Account account = (Account)object;
                this.params = new HashMap();
                if (account.getGivenName() != null && account.getGivenName().getValue() != null) {
                    this.addToParmMap("account.personalInfo." + ParameterMapCM.EPROPERTY.GIVEN_NAME.getKey(), account.getGivenName().getValue());
                }
                if (account.getSurname() != null && account.getSurname().getValue() != null) {
                    this.addToParmMap("account.personalInfo." + ParameterMapCM.EPROPERTY.SURNAME.getKey(), account.getSurname().getValue());
                }
                if (account.getDefaultName() != null) {
                    this.userName = account.getDefaultName().getValue();
                    this.addToParmMap("account." + ParameterMapCM.EPROPERTY.DEFAULT_NAME.getKey(), this.userName);
                }
                if (account.getBusinessPhone() != null && account.getBusinessPhone().getValue() != null) {
                    this.addToParmMap("account.personalInfo." + ParameterMapCM.EPROPERTY.BUSINESS_PHONE.getKey(), account.getBusinessPhone().getValue());
                }
                if (account.getEmail() != null && account.getEmail().getValue() != null) {
                    this.addToParmMap("account.personalInfo." + ParameterMapCM.EPROPERTY.EMAIL.getKey(), account.getEmail().getValue());
                }
                if (account.getFaxPhone() != null && account.getFaxPhone().getValue() != null) {
                    this.addToParmMap("account.personalInfo." + ParameterMapCM.EPROPERTY.FAX_PHONE.getKey(), account.getFaxPhone().getValue());
                }
                if (account.getHomePhone() != null && account.getHomePhone().getValue() != null) {
                    this.addToParmMap("account.personalInfo." + ParameterMapCM.EPROPERTY.HOME_PHONE.getKey(), account.getHomePhone().getValue());
                }
                if (account.getMobilePhone() != null && account.getMobilePhone().getValue() != null) {
                    this.addToParmMap("account.personalInfo." + ParameterMapCM.EPROPERTY.MOBILE_PHONE.getKey(), account.getMobilePhone().getValue());
                }
                if (account.getPagerPhone() != null && account.getPagerPhone().getValue() != null) {
                    this.addToParmMap("account.personalInfo." + ParameterMapCM.EPROPERTY.PAGER_PHONE.getKey(), account.getPagerPhone().getValue());
                }
                if (account.getPostalAddress() != null && account.getPostalAddress().getValue() != null) {
                    this.addToParmMap("account.personalInfo." + ParameterMapCM.EPROPERTY.POSTAL_ADDRESS.getKey(), account.getPostalAddress().getValue());
                }
                if (account.getTimeZoneID() != null && account.getTimeZoneID().getValue() != null) {
                    this.addToParmMap("account.personalInfo." + ParameterMapCM.EPROPERTY.TIMEZONE_ID.getKey(), account.getTimeZoneID().getValue());
                    foundAccountTimeZoneID = true;
                }
                if (account.getUserName() != null && account.getUserName().getValue() != null) {
                    this.addToParmMap("account.personalInfo." + ParameterMapCM.EPROPERTY.USERNAME.getKey(), account.getUserName().getValue());
                }
                if (account.getParameters() != null && account.getParameters().getValue() != null) {
                    this.loadLDAPVariables(account.getParameters().getValue());
                }
                if (account.getStoreID() == null || account.getStoreID().getValue() == null) continue;
                this.addToParmMap("account." + ParameterMapCM.EPROPERTY.STORE_ID.getKey(), account.getStoreID().getValue().get_value());
            }
            if (!foundAccountTimeZoneID && (userPreferences = bibusHeader.getUserPreferenceVars()) != null) {
                for (UserPreferenceVar aUserPref : userPreferences) {
                    if (!aUserPref.getName().equals("timeZoneID")) continue;
                    this.addToParmMap("account.personalInfo." + ParameterMapCM.EPROPERTY.TIMEZONE_ID.getKey(), aUserPref.getValue());
                }
            }
        }
        catch (RemoteException e) {
            boolean bIsCMCacheDisabled = false;
            if (e instanceof AxisFault) {
                bIsCMCacheDisabled = CMUtils.parseFaultForDisabledCMCache((AxisFault)e);
            }
            if (!bIsCMCacheDisabled) {
                throw new XQERuntimeException(e);
            }
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
    }

    private void loadLDAPVariables(ParameterValue[] parms) {
        for (ParameterValue p : parms) {
            ParmValueItem[] vItems;
            if (p.getName() == null || p.getValue() == null) continue;
            ArrayList<String> useValues = new ArrayList<String>();
            for (ParmValueItem v : vItems = p.getValue()) {
                SimpleParmValueItem simplePVItem;
                if (!(v instanceof SimpleParmValueItem) || (simplePVItem = (SimpleParmValueItem)v).getUse() == null) continue;
                useValues.add(simplePVItem.getUse());
            }
            if (useValues.size() <= 0) continue;
            this.params.put("account.parameters." + p.getName(), useValues);
        }
    }
}

