/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content;

import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.content.ICMConnection;
import com.cognos.xqe.bibushandler.content.ICMDataSource;
import com.cognos.xqe.bibushandler.content.ICryptoHandle;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.reference.IResourceHolder;
import com.cognos.xqebifw.bibushandler.content.CMCacheService.CMDataSourceViaCMCService;
import com.cognos.xqebifw.bibushandler.content.CMEntity;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import com.cognos.xqebifw.bibushandler.content.CMModel;
import com.cognos.xqebifw.bibushandler.content.CMObject;
import com.cognos.xqebifw.bibushandler.content.CMSignon;
import com.cognos.xqebifw.bibushandler.content.Dispatcher.CMDataSourceViaDispatcher;
import com.cognos.xqebifw.bibushandler.datasource.JCAMImpersonator;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CMDataSource
implements ICMDataSource {
    protected static final String DISABLED = "disabled";
    protected static final String CAM_AUTH_NEGOTIATE = "camAuthNegotiate";
    protected String dsName;
    protected final CMEntity derivedFromEntity;
    protected volatile Map<String, ICMConnection> connections = null;
    protected volatile CMObject dataSource = null;
    protected volatile CMModel model = null;
    protected volatile String base64EncodedSecurityBlob = null;
    protected volatile String tmpCryptoHandleId = null;
    private volatile IResourceHolder<? extends ICryptoHandle> cryptoHandleRef = null;
    private boolean connectionFailed = false;
    protected volatile JCAMImpersonator.DelegatedCredential credential = null;

    public static CMDataSource create(String name, CMEntity cmEntity, IRequestEnvironment env) {
        CMDataSource cmD = null;
        try {
            cmD = CMDataSource.createInternal(name, cmEntity, env);
        }
        catch (RolapException e) {
            try {
                cmD = CMDataSourceViaDispatcher.createDS(name, cmEntity, env);
            }
            catch (SSOException sSOException) {}
        }
        catch (SSOException e) {
            cmD = CMDataSourceViaDispatcher.createDS4SSO(name, cmEntity, e.getSecurityBlob(), env);
        }
        return cmD;
    }

    private static CMDataSource createInternal(String name, CMEntity cmEntity, IRequestEnvironment env) throws SSOException {
        CMDataSource cmD = null;
        if (CMEntityPool.tryUsingCMCacheService()) {
            try {
                cmD = CMDataSourceViaCMCService.createDS(name, cmEntity, env);
            }
            catch (RolapException e) {
                throw e;
            }
            catch (SSOException e) {
                throw e;
            }
            catch (XQERuntimeException e) {
                throw e;
            }
        }
        if (cmD == null) {
            try {
                cmD = CMDataSourceViaDispatcher.createDS(name, cmEntity, env);
            }
            catch (SSOException e) {
                throw e;
            }
            catch (XQERuntimeException e) {
                throw e;
            }
        }
        return cmD;
    }

    protected CMDataSource(String name, CMEntity myEntity) {
        this.dsName = name;
        this.derivedFromEntity = myEntity;
    }

    public String getName() {
        return this.dsName;
    }

    public CMObject getDataSource() {
        return this.dataSource;
    }

    @Override
    public boolean exist() {
        return this.dataSource != null;
    }

    @Override
    public Collection<ICMConnection> getConnections() {
        return this.connections.values();
    }

    @Override
    public ICMConnection getConnection(String name) {
        return this.connections.get(name);
    }

    @Override
    public IResourceHolder<? extends ICryptoHandle> getCryptoHandle() {
        return this.cryptoHandleRef;
    }

    @Override
    public JCAMImpersonator.DelegatedCredential getDelegatedCredential() {
        return this.credential;
    }

    public CMModel getModel() {
        return this.model;
    }

    @Override
    public void setConnectionFailed() {
        this.connectionFailed = true;
    }

    @Override
    public boolean isConnectionFailed() {
        return this.connectionFailed;
    }

    public String toString() {
        return super.toString() + ":Connections=" + this.connections;
    }

    protected void addSignonsAsChildrenOfConnection(List<CMSignon> dataSourceSignons, List<CMSignon> dataSourceCredentials) {
        List<CMSignon> signons = !dataSourceSignons.isEmpty() ? dataSourceSignons : dataSourceCredentials;
        for (CMSignon signon : signons) {
            String connectionName = signon.getConnectionName();
            ICMConnection connection = this.connections.get(connectionName);
            if (connection == null) continue;
            connection.addSignon(signon);
        }
    }

    protected void updateCryptoHandle() {
        try {
            this.cryptoHandleRef = CMEntityPool.instance().getOrCreateCryptoHandle(this.tmpCryptoHandleId);
        }
        finally {
            this.tmpCryptoHandleId = null;
        }
    }

    public class RolapException
    extends XQERuntimeException {
        private static final long serialVersionUID = -8052119504193792179L;
    }

    public class SSOException
    extends XQEException {
        private static final long serialVersionUID = -9020589604887152485L;
        private final String encoded64BitSecurityBlob;

        public SSOException(String aSecurityBlob) {
            this.encoded64BitSecurityBlob = aSecurityBlob;
        }

        public String getSecurityBlob() {
            return this.encoded64BitSecurityBlob;
        }
    }
}

