/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content;

import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.xqe.bibushandler.content.ICryptoHandle;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestReference;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.MapCast;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.reference.IResourceHolder;
import com.cognos.xqe.util.reference.SimpleResourceHolder;
import com.cognos.xqebifw.bibushandler.content.CAMCryptoHandle;
import com.cognos.xqebifw.bibushandler.content.CMEntity;
import com.cognos.xqebifw.bibushandler.content.CMQueryFactory;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.collections.map.ReferenceMap;
import org.dom4j.Element;

public final class CMEntityPool {
    private static final XQELogger SECBRIDGE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "SecBridge", LogLevel.TRACE);
    private static final int DEFAULT_ENTITY_RETAIN_PERIOD = 180000;
    private static final int DEFAULT_ENTITY_RETAIN_SIZE = 500;
    private static final boolean DEFAULT_ENTITIY_ENABLED = true;
    private static boolean gIsCMCacheServiceEnabled = true;
    private static boolean gUseCMCacheService = true;
    private static boolean gUseCMCacheServiceConfig = true;
    private static int gElapsedTimeToRetryCMCachService = 0;
    private static long gDisabledCMCacheServiceDetectedAt = 0L;
    private static SingletonHelper<CMEntityPool> singletonHelper = new SingletonHelper<CMEntityPool>(){

        @Override
        protected CMEntityPool newInstance() {
            return new CMEntityPool();
        }

        @Override
        protected void releaseImpl(CMEntityPool theInstance) {
            theInstance.release();
        }

        @Override
        protected void initializeImpl(CMEntityPool theInstance) {
            theInstance.initialize();
        }
    };
    private final LRUMap userCache;
    private final ReentrantLock userCacheLock = new ReentrantLock();
    private final Map<String, IResourceHolder<CAMCryptoHandle>> cryptoHandleCache = MapCast.uncheckedCast(new ReferenceMap(0, 2));
    private final MultiRequestReference<CMEntity> sessionEntityRef;
    private int retainPeriod = 180000;
    private boolean enabled = true;
    private AtomicReference<CMQueryFactory> cmQueryFactoryRef;

    public static CMEntityPool instance() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    private CMEntityPool() {
        int temp;
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.retainPeriod = config.getIntProperty("contentManagerCache[@retainPeriod]", 180000);
        int retainSize = config.getIntProperty("contentManagerCache[@retainSize]", 500);
        this.enabled = config.getBooleanProperty("contentManagerCache[@enabled]", true);
        this.sessionEntityRef = new MultiRequestReference();
        this.userCache = new LRUMap(retainSize);
        this.cmQueryFactoryRef = new AtomicReference<CMQueryFactory>(new CMQueryFactory());
        gUseCMCacheServiceConfig = config.getBooleanProperty("contentManagerCacheService[@enabled]", true);
        gElapsedTimeToRetryCMCachService = temp = config.getIntProperty("elapsedTimeToRetryCMCachService[@value]", 120);
        gUseCMCacheService = gUseCMCacheServiceConfig;
    }

    private void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        this.userCacheLock.lock();
        try {
            this.userCache.clear();
        }
        finally {
            this.userCacheLock.unlock();
        }
        Map<String, IResourceHolder<CAMCryptoHandle>> map = this.cryptoHandleCache;
        synchronized (map) {
            this.cryptoHandleCache.clear();
        }
    }

    @Deprecated
    public CMEntity get(String camPassport, Element biBusHeader) {
        return this.get(camPassport);
    }

    public CMEntity get(String camPassport) {
        return this.get(camPassport, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMEntity get(String camPassport, boolean enforceCreationTime) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (null == execEnv) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        CMEntity entity = this.sessionEntityRef.get(execEnv);
        if (entity != null && entity.isValid() && System.currentTimeMillis() - entity.lastAccessedAt() < (long)this.retainPeriod) {
            return entity;
        }
        if (this.enabled) {
            this.userCacheLock.lock();
            try {
                entity = (CMEntity)this.userCache.get((Object)camPassport);
                if (entity != null && entity.isValid() && (enforceCreationTime && System.currentTimeMillis() - entity.creationTime() < (long)this.retainPeriod || !enforceCreationTime) && System.currentTimeMillis() - entity.lastAccessedAt() < (long)this.retainPeriod) {
                    CMEntity cMEntity = entity;
                    return cMEntity;
                }
                entity = new CMEntity();
                this.userCache.put((Object)camPassport, (Object)entity);
            }
            finally {
                this.userCacheLock.unlock();
            }
        } else {
            entity = new CMEntity();
        }
        this.sessionEntityRef.set(execEnv, entity);
        return entity;
    }

    public void setCMQueryFactory(CMQueryFactory factory) {
        if (factory != null) {
            this.cmQueryFactoryRef.set(factory);
        }
    }

    public ContentManagerQueryCommand createCMQuery() {
        return this.cmQueryFactoryRef.get().getNewCommand();
    }

    public void clear() {
        this.userCache.clear();
        this.sessionEntityRef.clear();
        gUseCMCacheService = gUseCMCacheServiceConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IResourceHolder<? extends ICryptoHandle> getOrCreateCryptoHandle(String handleId) {
        IResourceHolder<CAMCryptoHandle> handleHolder = null;
        if (SECBRIDGE_LOGGER.isOn()) {
            SECBRIDGE_LOGGER.log("Looking for a cached Crypto handle for id = " + handleId);
        }
        Map<String, IResourceHolder<CAMCryptoHandle>> map = this.cryptoHandleCache;
        synchronized (map) {
            handleHolder = this.cryptoHandleCache.get(handleId);
            if (null == handleHolder) {
                SECBRIDGE_LOGGER.log("No Crypto handle was found in the cache. Creating a new one.");
                handleHolder = new SimpleResourceHolder<Object>(null, false);
                CAMCryptoHandle handle = new CAMCryptoHandle(handleId, handleHolder);
                handleHolder.reset(handle);
                this.cryptoHandleCache.put(handleId, handleHolder);
            } else {
                if (!handleHolder.isValid()) {
                    SECBRIDGE_LOGGER.log(LogLevel.ERROR, "A Crypto handle was found in cache, but it was already released!");
                    throw new XQERuntimeException(XQEMessageKeys.GEN_ResourceWasReleased);
                }
                SECBRIDGE_LOGGER.log("A valid Crypto handle was found in the cache. Ref-count incremented.");
            }
        }
        return handleHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCryptoHandle(String handleId) {
        Map<String, IResourceHolder<CAMCryptoHandle>> map = this.cryptoHandleCache;
        synchronized (map) {
            if (SECBRIDGE_LOGGER.isOn()) {
                SECBRIDGE_LOGGER.log("Removing cached CAM Crypto handle for id = " + handleId);
            }
            this.cryptoHandleCache.remove(handleId);
        }
    }

    public static void setIsCMCacheServiceEnabled(boolean state) {
        gIsCMCacheServiceEnabled = state;
        if (!gIsCMCacheServiceEnabled) {
            gDisabledCMCacheServiceDetectedAt = System.currentTimeMillis();
        }
    }

    public static boolean tryUsingCMCacheService() {
        if (gUseCMCacheService) {
            if (gIsCMCacheServiceEnabled) {
                return true;
            }
            return System.currentTimeMillis() - gDisabledCMCacheServiceDetectedAt > (long)(1000 * gElapsedTimeToRetryCMCachService);
        }
        return false;
    }

    public static void disableCMCacheServiceForTesting() {
        gUseCMCacheService = false;
    }
}

