/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content;

import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqebifw.bibushandler.content.CMCacheService.CMPackageViaCMCService;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import com.cognos.xqebifw.bibushandler.content.CMModel;
import com.cognos.xqebifw.bibushandler.content.Dispatcher.CMPackageViaDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class CMPackage {
    private static final String CAN_USE_USER_DEFINED_SQL = "canUseUserDefinedSQL";
    protected final String packageName;
    protected volatile boolean initialized = false;
    protected volatile Set<String> globalCapabilities;
    protected volatile Set<String> packageCapabilities;
    protected volatile Set<String> supportedCapabilities;
    protected volatile CMModel model = null;
    protected volatile boolean isFromModelXML = false;
    private Set<String> modelViews = null;

    public static CMPackage create(String thePackageName, IRequestEnvironment env) {
        CMPackage cmP = null;
        if (CMEntityPool.tryUsingCMCacheService()) {
            cmP = CMPackageViaCMCService.create(thePackageName, env);
        }
        if (cmP == null) {
            cmP = CMPackageViaDispatcher.create(thePackageName, env);
        }
        return cmP;
    }

    protected CMPackage(String thePackageName) {
        this.packageName = thePackageName;
        this.globalCapabilities = new HashSet<String>();
        this.packageCapabilities = new HashSet<String>();
        this.model = new CMModel(thePackageName);
        if (this.packageName.endsWith("model.xml")) {
            this.globalCapabilities.add(CAN_USE_USER_DEFINED_SQL);
            this.packageCapabilities.add(CAN_USE_USER_DEFINED_SQL);
            this.initialized = true;
            this.isFromModelXML = true;
        } else {
            this.supportedCapabilities = new HashSet<String>();
            this.supportedCapabilities.add(CAN_USE_USER_DEFINED_SQL);
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Set<String> getPackageCapabilities() {
        return Collections.unmodifiableSet(this.packageCapabilities);
    }

    public Set<String> getViews(RequestEnvironment rEnv) {
        if (this.isFromModelXML) {
            return new TreeSet<String>();
        }
        if (this.modelViews == null) {
            this.modelViews = this.model.getViews(rEnv);
        }
        return this.modelViews;
    }

    public List<String> getModelViewSearchPaths(IRequestEnvironment reqEnv, String modelView) {
        if (this.isFromModelXML) {
            return new ArrayList<String>();
        }
        if (this.modelViews == null) {
            this.modelViews = this.model.getViews(reqEnv);
        }
        return this.model.getViewSearchPaths(modelView);
    }
}

