/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content.Dispatcher;

import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.util.base64;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.bibushandler.Commands;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.secbridge.CAMImpersonate;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.exception.XQESOAPFaultException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.MapCast;
import com.cognos.xqebifw.bibushandler.content.CMConnection;
import com.cognos.xqebifw.bibushandler.content.CMDataSource;
import com.cognos.xqebifw.bibushandler.content.CMEntity;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import com.cognos.xqebifw.bibushandler.content.CMModel;
import com.cognos.xqebifw.bibushandler.content.CMObject;
import com.cognos.xqebifw.bibushandler.content.CMROLAPConnection;
import com.cognos.xqebifw.bibushandler.content.CMSignon;
import com.cognos.xqebifw.bibushandler.datasource.JCAMImpersonator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.collections.map.Flat3Map;
import org.dom4j.Element;

public final class CMDataSourceViaDispatcher
extends CMDataSource {
    private static final String OS_NAME = "os.name";
    private static final String UNEXPECTED_EXCEPTION = "Unexpected exception occurred ";
    private static final String UNEXPECTED_XQE_EXCEPTION = "Unexpected XQERuntimeException exception occurred ";
    private static final String CAM_SOAP_FAULT_NEGOTIATING = "CAM soap fault recieved as part of negotiation process";
    private static final String SECURITY_BLOB_NULL = "security blob null";
    private static final String CM_SEARCH_PATH_TEMPLATE = "CAMID(\":\")/dataSource[@name='NAME'] | personalDataSourceSignon('NAME') | CAMID(\":\")/rolapDataSource[@name='NAME' and permission('read')] | CAMID(\":\")/rolapVirtualDataSource[@name='NAME' and permission('read')]";
    private static final Pattern PATTERN = Pattern.compile("NAME");
    private static final String SECURITYBLOB = "securityBlob";
    private static final String CAM = "CAM";
    private static final String EXCEPTION = "exception";
    private static final String PROMPT_INFO = "promptInfo";
    private static final String ERRORCODESTRING = "errorCodeString";
    private static final XQELogger SECBRIDGE_EXCEPTION_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static final String CM_CLASS_DATA_SOURCE_CONNECTION = "cm:dataSourceConnection";
    private static final String CM_CLASS_DATA_SOURCE = "cm:dataSource";
    private static final String CM_CLASS_DATA_SOURCE_SIGNON = "cm:dataSourceSignon";
    private static final String CM_CLASS_DATA_SOURCE_CREDENTIAL = "cm:dataSourceCredential";
    private static final String CM_CLASS_ROLAP_DATA_SOURCE = "cm:rolapDataSource";
    private static final String CM_CLASS_ROLAP_VIRTUAL_DATA_SOURCE = "cm:rolapVirtualDataSource";
    private static final XQELogger SECBRIDGE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "SecBridge", LogLevel.TRACE);

    public static CMDataSource createDS(String name, CMEntity cmEntity, IRequestEnvironment env) throws CMDataSource.SSOException {
        CMDataSourceViaDispatcher cmD = null;
        cmD = new CMDataSourceViaDispatcher(name, cmEntity, env, null);
        return cmD;
    }

    public static CMDataSource createDS4SSO(String name, CMEntity cmEntity, String securityBlob, IRequestEnvironment env) {
        CMDataSourceViaDispatcher cmD = null;
        try {
            cmD = new CMDataSourceViaDispatcher(name, cmEntity, env, securityBlob);
        }
        catch (CMDataSource.SSOException sSOException) {
            // empty catch block
        }
        return cmD;
    }

    private CMDataSourceViaDispatcher(String name, CMEntity cmEntity, final IRequestEnvironment env, String securityBlob) throws CMDataSource.SSOException {
        super(name, cmEntity);
        if (securityBlob == null) {
            try {
                ((RequestEnvironment)env).getCMRequestExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((RequestEnvironment)env).resetEnvelopeFromExecutor();
                            CMDataSourceViaDispatcher.this.queryForCMInfo(env);
                        }
                        catch (CMDataSource.SSOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof CMDataSource.SSOException) {
                    throw (CMDataSource.SSOException)cause;
                }
                throw e;
            }
        }
        SECBRIDGE_LOGGER.log("CAM Soap fault caught start the crypto dance, blob is:" + securityBlob);
        this.base64EncodedSecurityBlob = securityBlob;
        SECBRIDGE_LOGGER.log("Operating system detected" + System.getProperty(OS_NAME));
        List<CMClass> resultList = null;
        boolean kerberos = false;
        boolean windows = false;
        if (System.getProperty(OS_NAME).toUpperCase().contains("WINDOW")) {
            windows = true;
            while (true) {
                try {
                    resultList = this.doNativeCryptoDance(env);
                }
                catch (XQERuntimeException ex) {
                    if (ex.getMessageKey() == XQEMessageKeys.GEN_ResourceWasReleased) continue;
                    throw ex;
                }
                break;
            }
            if (this.isKerberos(resultList)) {
                kerberos = true;
                this.base64EncodedSecurityBlob = null;
                try {
                    ((RequestEnvironment)env).getCMRequestExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ((RequestEnvironment)env).resetEnvelopeFromExecutor();
                                CMDataSourceViaDispatcher.this.runCMQuery(env);
                            }
                            catch (CMDataSource.SSOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    throw new RuntimeException("SSO exception expected, but not thrown");
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause != null && cause instanceof CMDataSource.SSOException) {
                        this.base64EncodedSecurityBlob = ((CMDataSource.SSOException)cause).getSecurityBlob();
                    }
                    throw e;
                }
            }
        }
        if (!windows || kerberos) {
            while (true) {
                try {
                    resultList = this.doCryptoDance(env);
                }
                catch (XQERuntimeException ex) {
                    if (ex.getMessageKey() == XQEMessageKeys.GEN_ResourceWasReleased) continue;
                    throw ex;
                }
                break;
            }
        }
        this.populate(resultList);
    }

    private void queryForCMInfo(IRequestEnvironment env) throws CMDataSource.SSOException {
        List<CMClass> resultList = this.runCMQuery(env);
        this.populate(resultList);
    }

    private List<CMClass> runCMQuery(IRequestEnvironment env) throws CMDataSource.SSOException {
        List<CMClass> list;
        Element localbiBusHeader = (Element)((Element)env.getBibusHeader().clone()).detach();
        ContentManagerQueryCommand query = CMEntityPool.instance().createCMQuery();
        if (MacroExpander.isMacro(this.dsName)) {
            PlanningEnvironment planningEnvironment = QueryPlanner.setupEnvironment(env);
            MacroExpander expander = new MacroExpander();
            this.dsName = expander.expand(null, planningEnvironment, this.dsName);
        }
        query.setQueryObject(CMDataSourceViaDispatcher.buildSearchPath(this.dsName));
        if (this.base64EncodedSecurityBlob != null) {
            byte[] byArray = this.base64EncodedSecurityBlob.getBytes();
            String encryptedString = base64.encode((int)0, (byte[])byArray);
            SECBRIDGE_LOGGER.log("Encoded Blob To Be Sent Back To CM:" + encryptedString);
            localbiBusHeader.element(CAM).addElement(SECURITYBLOB).addAttribute("xsi:type", "xsd:base64Binary").setText(encryptedString);
        }
        query.setBIBusHeader(localbiBusHeader);
        query.addQueryPropertyName(PropEnum.defaultName.getValue());
        query.addQueryPropertyName(PropEnum.searchPath.getValue());
        query.addQueryPropertyName(PropEnum.connectionString.getValue());
        query.addQueryPropertyName(PropEnum.credentials.getValue());
        query.addQueryPropertyName(PropEnum.disabled.getValue());
        query.addQueryPropertyName(PropEnum.credentialNamespaces.getValue());
        query.addQueryPropertyName(PropEnum.dataSourceConnectionName.getValue());
        query.addQueryPropertyName(PropEnum.dataSourceName.getValue());
        query.addQueryPropertyName(PropEnum.apiToken.getValue());
        for (Commands cmd : Commands.values()) {
            query.addQueryPropertyName(cmd.getName());
        }
        Object var4_8 = null;
        SECBRIDGE_LOGGER.log("CMQuery:" + query.toString());
        try {
            query.execute();
            list = CollectionCast.uncheckedCast(query.getResultList());
            this.derivedFromEntity.validate();
        }
        catch (SoapFaultException sfe) {
            this.derivedFromEntity.invalidate();
            BIBusEnvelope faultEnvelope = query.getResponseEnvelope();
            boolean bCAMException = CMDataSourceViaDispatcher.parseAuthException(faultEnvelope);
            if (bCAMException) {
                this.base64EncodedSecurityBlob = faultEnvelope.getCAM().element(EXCEPTION).element(PROMPT_INFO).element(SECURITYBLOB).getText();
                SECBRIDGE_LOGGER.log("CAM Soap fault caught returning security blob to caller.");
                throw new CMDataSource.SSOException(this, this.base64EncodedSecurityBlob);
            }
            SECBRIDGE_EXCEPTION_LOGGER.log("Unexpected SOAP fault occurred: " + sfe.getMessage());
            throw new XQESOAPFaultException(faultEnvelope, (Throwable)sfe);
        }
        catch (CommandExecutionException e) {
            this.derivedFromEntity.invalidate();
            throw new XQERuntimeException(XQEMessageKeys.CM_UnableToRetrieveDataSource, (Throwable)e, this.dsName);
        }
        if (list == null || list.isEmpty()) {
            throw new XQERuntimeException(XQEMessageKeys.DS_DataSourceNotFound, this.dsName);
        }
        return list;
    }

    private void populate(List<CMClass> resultList) {
        LinkedList<CMSignon> dataSourceSignons = new LinkedList<CMSignon>();
        LinkedList<CMSignon> dataSourceCredentials = new LinkedList<CMSignon>();
        this.connections = MapCast.uncheckedCast(new Flat3Map());
        for (CMClass cmResult : resultList) {
            CMSignon signon;
            CMConnection conn;
            String cmClassName = cmResult.getCMClassName();
            if (CM_CLASS_DATA_SOURCE.equals(cmClassName)) {
                this.dataSource = new CMObject(cmResult.getItemElement());
                continue;
            }
            if (CM_CLASS_DATA_SOURCE_CONNECTION.equals(cmClassName)) {
                conn = new CMConnection(cmResult.getItemElement());
                if (conn.getBooleanProperty("disabled", false)) continue;
                this.connections.put(conn.getDefaultName(), conn);
                continue;
            }
            if (CM_CLASS_DATA_SOURCE_SIGNON.equals(cmClassName)) {
                signon = new CMSignon(cmResult.getItemElement());
                if (signon.getBooleanProperty("disabled", false)) continue;
                dataSourceSignons.add(signon);
                continue;
            }
            if (CM_CLASS_DATA_SOURCE_CREDENTIAL.equals(cmClassName)) {
                signon = new CMSignon(cmResult.getItemElement());
                if (signon.getBooleanProperty("disabled", false)) continue;
                dataSourceCredentials.add(signon);
                continue;
            }
            if (!CM_CLASS_ROLAP_DATA_SOURCE.equals(cmClassName) && !CM_CLASS_ROLAP_VIRTUAL_DATA_SOURCE.equals(cmClassName)) continue;
            this.dataSource = new CMObject(cmResult.getItemElement());
            this.model = new CMModel(this.dataSource.getSearchPath());
            conn = new CMROLAPConnection(cmResult.getItemElement());
            this.connections.put(this.dataSource.getDefaultName(), conn);
        }
        this.addSignonsAsChildrenOfConnection(dataSourceSignons, dataSourceCredentials);
    }

    private static String buildSearchPath(String name) {
        return PATTERN.matcher(CM_SEARCH_PATH_TEMPLATE).replaceAll(name);
    }

    public static boolean parseAuthException(BIBusEnvelope faultEnvelope) {
        Element camFault = faultEnvelope.getCAM();
        if (null != camFault && null != camFault.element(EXCEPTION) && null != camFault.element(EXCEPTION).element(ERRORCODESTRING) && null != camFault.element(EXCEPTION).element(ERRORCODESTRING).getText()) {
            return camFault.element(EXCEPTION).element(ERRORCODESTRING).getText().equalsIgnoreCase("camAuthNegotiate");
        }
        return false;
    }

    private List<CMClass> doCryptoDance(IRequestEnvironment env) {
        boolean bFinishedDance = false;
        String camSecBlobCryptoHandle = null;
        JCAMImpersonator helper = new JCAMImpersonator();
        SECBRIDGE_LOGGER.log("Starting a JGSS crypto dance.");
        List<CMClass> resultList = null;
        while (!bFinishedDance) {
            try {
                if (this.base64EncodedSecurityBlob == null) {
                    SECBRIDGE_LOGGER.log(SECURITY_BLOB_NULL);
                    throw new XQERuntimeException();
                }
                SECBRIDGE_LOGGER.log("doCryptoDance calling GSS_Helper.camImpUsrNegotiate with encrypted blob:" + this.base64EncodedSecurityBlob);
                this.base64EncodedSecurityBlob = camSecBlobCryptoHandle = helper.camImpUsrNegotiate(this.base64EncodedSecurityBlob);
                SECBRIDGE_LOGGER.log("doCryptoDance calling back to process new base64EncodedSecurityBlob:" + this.base64EncodedSecurityBlob);
                resultList = this.runCMQuery(env);
                bFinishedDance = true;
                SECBRIDGE_LOGGER.log("doCryptoDance complete - Subject ready for use");
            }
            catch (CMDataSource.SSOException e) {
                SECBRIDGE_LOGGER.log(CAM_SOAP_FAULT_NEGOTIATING);
            }
            catch (XQERuntimeException ex) {
                SECBRIDGE_EXCEPTION_LOGGER.log(UNEXPECTED_XQE_EXCEPTION + ex.toString());
                if (ex.getMessageKey() != XQEMessageKeys.WSB_BRIDGE_INIT_ERROR) {
                    throw new XQERuntimeException(XQEMessageKeys.WSB_CAM_NEGOTIATION_FAILURE, (Throwable)ex);
                }
                throw ex;
            }
            catch (Exception ex) {
                SECBRIDGE_EXCEPTION_LOGGER.log(UNEXPECTED_EXCEPTION + ex.toString());
                throw new XQERuntimeException(XQEMessageKeys.WSB_CAM_NEGOTIATION_FAILURE, (Throwable)ex);
            }
        }
        this.credential = helper.getDelegatedCredential();
        return resultList;
    }

    private List<CMClass> doNativeCryptoDance(IRequestEnvironment env) {
        boolean bFinishedDance = false;
        Locale errMsgLocale = env.getProductLocale();
        String camSecBlobCryptoHandle = null;
        SECBRIDGE_LOGGER.log("Operating System is Windows, starting a native crypto dance.");
        List<CMClass> resultList = null;
        while (!bFinishedDance) {
            try {
                if (this.base64EncodedSecurityBlob == null) {
                    SECBRIDGE_LOGGER.log(SECURITY_BLOB_NULL);
                    throw new XQERuntimeException();
                }
                SECBRIDGE_LOGGER.log("doNativeCryptoDance calling CAMImpersonate.camImpUsrNegotiate ");
                camSecBlobCryptoHandle = CAMImpersonate.camImpUsrNegotiate(errMsgLocale, this.base64EncodedSecurityBlob, this.tmpCryptoHandleId);
                int index = camSecBlobCryptoHandle.indexOf("<>");
                if (index == -1 || camSecBlobCryptoHandle.length() <= index + 2) {
                    SECBRIDGE_EXCEPTION_LOGGER.log("Unexpected exception occurred while parsing camSecBlobCryptoHandle");
                    throw new XQERuntimeException(XQEMessageKeys.WSB_CAM_NEGOTIATION_FAILURE);
                }
                this.base64EncodedSecurityBlob = camSecBlobCryptoHandle.substring(0, index);
                this.tmpCryptoHandleId = camSecBlobCryptoHandle.substring(index + 2);
                SECBRIDGE_LOGGER.log("doNativeCryptoDance calling processInit to process new base64EncodedSecurityBlob");
                resultList = this.runCMQuery(env);
                bFinishedDance = true;
                SECBRIDGE_LOGGER.log("doNativeCryptoDance complete - cryptoHandle ready for use");
            }
            catch (CMDataSource.SSOException e) {
                SECBRIDGE_LOGGER.log(CAM_SOAP_FAULT_NEGOTIATING);
            }
            catch (XQERuntimeException ex) {
                SECBRIDGE_EXCEPTION_LOGGER.log(UNEXPECTED_XQE_EXCEPTION + ex.toString());
                if (ex.getMessageKey() != XQEMessageKeys.WSB_BRIDGE_INIT_ERROR) {
                    throw new XQERuntimeException(XQEMessageKeys.WSB_CAM_NEGOTIATION_FAILURE, (Throwable)ex);
                }
                throw ex;
            }
            catch (Exception ex) {
                SECBRIDGE_EXCEPTION_LOGGER.log(UNEXPECTED_EXCEPTION + ex.toString());
                throw new XQERuntimeException(XQEMessageKeys.WSB_CAM_NEGOTIATION_FAILURE, (Throwable)ex);
            }
        }
        this.updateCryptoHandle();
        return resultList;
    }

    private boolean isKerberos(List<CMClass> resultList) {
        for (CMClass cmResult : resultList) {
            CMConnection conn;
            String cmClassName = cmResult.getCMClassName();
            if (!CM_CLASS_DATA_SOURCE_CONNECTION.equals(cmClassName) || (conn = new CMConnection(cmResult.getItemElement())).getBooleanProperty("disabled", false)) continue;
            String connectionString = conn.getConnectionString();
            if (connectionString.contains("ibmcognos.authentication=java_krb5")) {
                return true;
            }
            if (!connectionString.contains(";BW;")) continue;
            return true;
        }
        return false;
    }
}

