/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content.Dispatcher;

import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.exception.XQESOAPFaultException;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.ParameterMapCM;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import com.cognos.xqebifw.bibushandler.content.CMSession;
import com.cognos.xqebifw.bibushandler.content.CMUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import org.dom4j.Element;

public final class CMUserViaDispatcher
extends CMUser {
    private static final String ITEM_PROPERTY = "item";
    private static final String VALUE_PROPERTY = "value";
    private static final String NAME_PROPERTY = "name";

    public static CMUser create(IRequestEnvironment env) {
        return new CMUserViaDispatcher(env);
    }

    private CMUserViaDispatcher(IRequestEnvironment env) {
        this.queryForCMInfo(env);
    }

    private void queryForCMInfo(IRequestEnvironment env) {
        Element biBusHeader = env.getBibusHeader();
        this.params = new HashMap();
        ContentManagerQueryCommand queryCommand = CMEntityPool.instance().createCMQuery();
        queryCommand.setQueryObject("~");
        queryCommand.setBIBusHeader((Element)((Element)biBusHeader.clone()).detach());
        queryCommand.addQueryPropertyName(PropEnum.defaultName.getValue());
        queryCommand.addQueryPropertyName(PropEnum.searchPath.getValue());
        for (ParameterMapCM.EPROPERTY aProperty : ParameterMapCM.EPROPERTY.values()) {
            queryCommand.addQueryPropertyName(aProperty.getKey());
        }
        List<CMClass> resultList = null;
        try {
            queryCommand.execute();
            resultList = CollectionCast.uncheckedCast(queryCommand.getResultList());
            for (CMClass aClass : resultList) {
                for (ParameterMapCM.EPROPERTY propertyName : ParameterMapCM.EPROPERTY.values()) {
                    try {
                        Element anElement = aClass.getPropertyAsElement(propertyName.getKey());
                        Element value = anElement.element(VALUE_PROPERTY);
                        if (value == null) continue;
                        switch (propertyName) {
                            case DEFAULT_NAME: {
                                this.userName = value.getText();
                                this.addToParmMap("account." + propertyName.getKey(), this.userName);
                                break;
                            }
                            case BUSINESS_PHONE: 
                            case EMAIL: 
                            case FAX_PHONE: 
                            case GIVEN_NAME: 
                            case HOME_PHONE: 
                            case MOBILE_PHONE: 
                            case PAGER_PHONE: 
                            case POSTAL_ADDRESS: 
                            case SURNAME: 
                            case TIMEZONE_ID: 
                            case USERNAME: {
                                this.addToParmMap("account.personalInfo." + propertyName.getKey(), value.getText());
                                break;
                            }
                            case PARAMETERS: {
                                this.loadLDAPVariables(value);
                                break;
                            }
                        }
                    }
                    catch (NoSuchElementException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (SoapFaultException sfe) {
            BIBusEnvelope faultEnvelope = queryCommand.getResponseEnvelope();
            throw new XQESOAPFaultException(faultEnvelope, (Throwable)sfe);
        }
        catch (CommandExecutionException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        CMSession cmSession = CMSession.create(env);
        this.addToParmMap("tenantID", cmSession.getSessionTenantID());
    }

    private void loadLDAPVariables(Element value) {
        List<Element> items = CollectionCast.uncheckedCast(value.elements(ITEM_PROPERTY));
        for (Element anItem : items) {
            ArrayList<String> useValues = new ArrayList<String>();
            Element itemValue = anItem.element(VALUE_PROPERTY);
            List<Element> itemItems = CollectionCast.uncheckedCast(itemValue.elements(ITEM_PROPERTY));
            for (Element anItemItems : itemItems) {
                Element useElm = anItemItems.element("use");
                if (useElm == null) continue;
                useValues.add(useElm.getText());
            }
            Element nameElm = anItem.element(NAME_PROPERTY);
            if (nameElm.getText() == null || useValues.isEmpty()) continue;
            this.params.put("account.parameters." + nameElm.getText(), useValues);
        }
    }
}

