/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices;

import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.async.AsyncService;
import com.cognos.pogo.async.service.AsyncBIBusXMLHelper;
import com.cognos.pogo.async.service.AsyncRequestHandler;
import com.cognos.pogo.async.service.bibustkserver.BIBusTKServerRequestHandler;
import com.cognos.pogo.async.service.connection.IConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.reportservice.ProcessFacade;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqebifw.bibushandler.ROLAPAsyncBIBusXMLHelper;
import com.cognos.xqebifw.cubingservices.CubingServicesComponentFactory;
import com.cognos.xqebifw.cubingservices.QSAdminTaskHandler;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class CubingServicesHandler
extends BIBusTKServerRequestHandler {
    private static final String MESSAGE_CONTEXT_PROPERTY_REQUEST_ENVELOPE = "request.envelope";
    private static final String MESSAGE_CONTEXT_PROPERTY_ASYNC = "async";
    private static final String MESSAGE_CONTEXT_PROPERTY_REFRESH_PASSPORT = "refreshPassport";
    private static final String MESSAGE_CONTEXT_PROPERTY_CONNECTION = "connection";
    private static final String MESSAGE_CONTEXT_PROPERTY_XML_HELPER = "xmlhelper";

    public void reconfigure(Configuration configuration) {
        CubingServicesComponentFactory.V5DataServerProcessFacade.updateConfiguration(configuration);
        List processes = this.getProcessManager().getProcessList().getProcesListView();
        for (ProcessFacade proc : processes) {
            try {
                ((CubingServicesComponentFactory.V5DataServerProcessFacade)proc).reconfigureProcess(configuration);
            }
            catch (IOException e) {
                XQELogger sLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Configuration", LogLevel.ERROR);
                if (!sLogger.isOn()) continue;
                sLogger.log("Failed to reconfigure query service.", (Throwable)e);
            }
        }
    }

    public void asyncInvoke(AsyncContext context) {
        MessageContext msgContext = context.getMessageContext();
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)msgContext.getProperty(MESSAGE_CONTEXT_PROPERTY_REQUEST_ENVELOPE);
        Element requestBody = requestEnvelope.getBody();
        Element requestTypeElement = (Element)requestBody.elementIterator().next();
        String requestType = requestTypeElement.getName();
        QSAdminTaskHandler handler = new QSAdminTaskHandler();
        if (requestType.equals("run") && handler.isLOLAPQueryServiceAdminRunRequest(requestEnvelope)) {
            AsyncBIBusXMLHelper xmlHelper = new AsyncBIBusXMLHelper();
            xmlHelper.cachePrimaryRequestInfo(requestEnvelope, true);
            this.handleQueryServiceAdminTask(requestEnvelope, handler);
            msgContext.setResponseName("response");
            Element bibusHeaderClone = (Element)requestEnvelope.getBIBusHeader().clone();
            bibusHeaderClone = (Element)bibusHeaderClone.detach();
            BIBusEnvelope responseEnvelope = new BIBusEnvelope();
            responseEnvelope.setBIBusHeader(bibusHeaderClone);
            responseEnvelope = QSAdminTaskHandler.prepareResponseElementForLOLAPQSAT(responseEnvelope);
            msgContext.setProperty("response.envelope", (Object)responseEnvelope);
            msgContext.setProperty(MESSAGE_CONTEXT_PROPERTY_XML_HELPER, (Object)xmlHelper);
            xmlHelper.prepareCompletedPrimaryResponse(msgContext);
        } else {
            super.asyncInvoke(context);
        }
    }

    private void handleQueryServiceAdminTask(BIBusEnvelope requestEnvelope, QSAdminTaskHandler handler) {
        handler.hanldeAdminTask(requestEnvelope);
    }

    public AsyncService getAsyncRequest(MessageContext messageContext) {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)messageContext.getProperty(MESSAGE_CONTEXT_PROPERTY_REQUEST_ENVELOPE);
        if (!ROLAPAsyncBIBusXMLHelper.isAsynchRequest(requestEnvelope)) {
            return super.getAsyncRequest(messageContext);
        }
        Boolean async = new Boolean(true);
        messageContext.setProperty(MESSAGE_CONTEXT_PROPERTY_ASYNC, (Object)async);
        Boolean refreshPassport = new Boolean(false);
        messageContext.setProperty(MESSAGE_CONTEXT_PROPERTY_REFRESH_PASSPORT, (Object)refreshPassport);
        IConnection connection = this.connectionFactory.getConnection();
        messageContext.setProperty(MESSAGE_CONTEXT_PROPERTY_CONNECTION, (Object)connection);
        Iterator elementIterator = requestEnvelope.getBody().elementIterator();
        Element commandElement = (Element)elementIterator.next();
        boolean alwaysIncludePrimaryRequest = AsyncBIBusXMLHelper.getAlwaysIncludePrimaryRequest((Element)commandElement);
        ROLAPAsyncBIBusXMLHelper xmlHelper = new ROLAPAsyncBIBusXMLHelper();
        xmlHelper.cachePrimaryRequestInfo(requestEnvelope, alwaysIncludePrimaryRequest);
        messageContext.setProperty(MESSAGE_CONTEXT_PROPERTY_XML_HELPER, (Object)xmlHelper);
        int threshold = AsyncBIBusXMLHelper.getPrimaryWaitThreshold((Element)commandElement);
        if (threshold > 0) {
            refreshPassport = new Boolean(true);
            messageContext.setProperty(MESSAGE_CONTEXT_PROPERTY_REFRESH_PASSPORT, (Object)refreshPassport);
            return new AsyncRequestHandler.AsyncRequestHandlerHelper((AsyncRequestHandler)this, (AsyncRequestHandler)this, threshold);
        }
        return null;
    }
}

