/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices;

import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqebifw.adminconsole.qsat.server.OptionsXMLProcessor;
import com.cognos.xqebifw.adminconsole.server.XqeAdministrator;
import com.cognos.xqebifw.bibushandler.ROLAPAsyncBIBusXMLHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.dom.DOMDocumentFactory;

public class QSAdminTaskHandler {
    private static final QName QN_BUS_ASYNCH_REPLY_STATUS_ENUM = DocumentHelper.createQName((String)"asynchReplyStatusEnum", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName QN_BUS_STATUS = DocumentHelper.createQName((String)"status", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName QN_RESULT = DocumentHelper.createQName((String)"result");
    private static final Namespace NS_SOAP_ENV = Namespace.get((String)"SOAP-ENV", (String)"http://schemas.xmlsoap.org/soap/envelope/");
    private static final Namespace NS_SOAP_ENC = Namespace.get((String)"SOAP-ENC", (String)"http://schemas.xmlsoap.org/soap/encoding/");
    private static final Namespace NS_QS = Namespace.get((String)"qs", (String)"http://developer.cognos.com/schemas/queryService/1/");
    private static final QName QN_BUS_ASYNCH_REPLY = DocumentHelper.createQName((String)"asynchReply", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName QN_SOAP_ENV_ENCODING_STYLE = DocumentHelper.createQName((String)"encodingStyle", (Namespace)NS_SOAP_ENV);
    static XQELogger errorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static final String QUERY_SERVICE_ADMIN_TASK = "run";
    private static final String QUERY_SERVICE_ADMIN_OPTIONS = "options";
    private static final String QUERY_SERVICE_ADMIN_OBJECT_CLASS = "objectClass";
    private static final String QUERY_SERVICE_ADMIN_VALUE = "value";
    private static final String QUERY_SERVICE_ADMIN_NAME = "name";
    private static final String QUERY_SERVICE_ADMIN_ITEM = "item";
    private static final String QUERY_SERVICE_ADMIN_OBJECT_PATH = "objectPath";
    private static final String QUERY_SERVICE_ADMIN_OPERATION_CLEAR_CACHE = "clearCache";
    private static final String QUERY_SERVICE_ADMIN_OPERATION_DUMP_CACHE = "dumpCacheState";

    void hanldeAdminTask(BIBusEnvelope requestEnvelope) {
        String cacheContext = null;
        String operation = null;
        Element requestBody = requestEnvelope.getBody();
        Element requestHeader = (Element)((Element)requestEnvelope.getBIBusHeader().clone()).detach();
        Element runElement = requestBody.element(QUERY_SERVICE_ADMIN_TASK);
        runElement.detach();
        Element objectPath = runElement.element(QUERY_SERVICE_ADMIN_OBJECT_PATH);
        String path = objectPath.getTextTrim();
        Element queryServiceAdminTask = this.getTaskDetailsFromCM(path, requestHeader);
        Element taskOptions = queryServiceAdminTask.element(QUERY_SERVICE_ADMIN_OPTIONS);
        Element taskOptionValues = taskOptions.element(QUERY_SERVICE_ADMIN_VALUE);
        List taskOptionItems = taskOptionValues.elements(QUERY_SERVICE_ADMIN_ITEM);
        HashMap taskParameters = new HashMap();
        for (Element option : taskOptionItems) {
            String paramName = this.getParameter(option.elementText(QUERY_SERVICE_ADMIN_NAME));
            List paramValueItems = null;
            Element paramValues = option.element(QUERY_SERVICE_ADMIN_VALUE);
            if (paramName.equalsIgnoreCase(QUERY_SERVICE_ADMIN_OPERATION_CLEAR_CACHE) || paramName.equalsIgnoreCase(QUERY_SERVICE_ADMIN_OPERATION_DUMP_CACHE)) {
                operation = paramName;
                continue;
            }
            paramValueItems = paramValues.elements(QUERY_SERVICE_ADMIN_ITEM);
            cacheContext = ((Element)paramValueItems.get(0)).getTextTrim();
        }
        this.performAndPropogateQSATOperation(operation, cacheContext);
    }

    private Element getTaskDetailsFromCM(String path, Element requestHeader) {
        ContentManagerQueryCommand query = new ContentManagerQueryCommand(path);
        query.setBIBusHeader(requestHeader);
        query.addQueryPropertyName(QUERY_SERVICE_ADMIN_OPTIONS);
        query.addQueryPropertyName(QUERY_SERVICE_ADMIN_OBJECT_CLASS);
        Element queryServiceAdminTask = null;
        try {
            query.execute();
            List resultList = query.getResultList();
            for (CMClass cmResult : resultList) {
                queryServiceAdminTask = cmResult.getItemElement();
            }
            queryServiceAdminTask.detach();
        }
        catch (CommandExecutionException ce) {
            errorLogger.log(ce);
            throw new XQERuntimeException(ce);
        }
        return queryServiceAdminTask;
    }

    private String getParameter(String elementText) {
        int index = elementText.indexOf("#");
        if (index != -1) {
            return elementText.substring(index + 1);
        }
        return elementText;
    }

    public void performAndPropogateQSATOperation(String qsatOperation, String qsatCacheContext) {
        try {
            qsatCacheContext = URLDecoder.decode(qsatCacheContext, "UTF-8");
            qsatCacheContext = OptionsXMLProcessor.xmlDecode(qsatCacheContext);
        }
        catch (UnsupportedEncodingException e) {
            errorLogger.log(e);
            throw new RuntimeException(e);
        }
        if (qsatCacheContext.endsWith("\"/\"DMR")) {
            this.handleDMRQSATTask(qsatOperation, qsatCacheContext);
        } else if (qsatCacheContext.endsWith("\"/\"SAPBW")) {
            this.handleSAPBWQSATTask(qsatOperation, qsatCacheContext);
        } else if (qsatCacheContext.endsWith("\"/\"ESSBASE")) {
            this.handleEssbaseQSATTask(qsatOperation, qsatCacheContext);
        } else {
            this.handleLOLAPQSATTask(qsatOperation, qsatCacheContext);
        }
    }

    public boolean isLOLAPQueryServiceAdminRunRequest(BIBusEnvelope requestEnvelope) {
        Element requestBody = requestEnvelope.getBody();
        Element requestHeader = (Element)((Element)requestEnvelope.getBIBusHeader().clone()).detach();
        Element runElement = requestBody.element(QUERY_SERVICE_ADMIN_TASK);
        Element objectPath = runElement.element(QUERY_SERVICE_ADMIN_OBJECT_PATH);
        String path = objectPath.getTextTrim();
        Element queryServiceAdminTask = this.getTaskDetailsFromCM(path, requestHeader);
        Element taskOptions = queryServiceAdminTask.element(QUERY_SERVICE_ADMIN_OPTIONS);
        Element taskOptionValues = taskOptions.element(QUERY_SERVICE_ADMIN_VALUE);
        List taskOptionItems = taskOptionValues.elements(QUERY_SERVICE_ADMIN_ITEM);
        for (Element option : taskOptionItems) {
            String paramName = this.getParameter(option.elementText(QUERY_SERVICE_ADMIN_NAME));
            Object paramValueItems = null;
            Element paramValues = option.element(QUERY_SERVICE_ADMIN_VALUE);
            if (!paramName.equalsIgnoreCase(QUERY_SERVICE_ADMIN_OPERATION_CLEAR_CACHE) && !paramName.equalsIgnoreCase(QUERY_SERVICE_ADMIN_OPERATION_DUMP_CACHE)) continue;
            return true;
        }
        return false;
    }

    private void handleDMRQSATTask(String opName, String taskContext) {
        String dataSource = null;
        String packageName = null;
        int firstIndexofSlash = -1;
        int secondIndexofSlash = -1;
        if (taskContext != null) {
            firstIndexofSlash = taskContext.indexOf("\"/\"");
            secondIndexofSlash = taskContext.indexOf("\"/\"", firstIndexofSlash + 3);
        }
        dataSource = taskContext.substring(0, firstIndexofSlash);
        packageName = taskContext.substring(firstIndexofSlash + 3, secondIndexofSlash);
        if (opName.equalsIgnoreCase(QUERY_SERVICE_ADMIN_OPERATION_CLEAR_CACHE)) {
            XqeAdministrator.getInstance().getXqeService("All").getSALMetrics().flushDMRCache(dataSource, packageName);
        } else if (opName.equalsIgnoreCase(QUERY_SERVICE_ADMIN_OPERATION_DUMP_CACHE)) {
            XqeAdministrator.getInstance().getXqeService("All").getSALMetrics().dumpDMRCache(dataSource, packageName);
        }
    }

    private void handleSAPBWQSATTask(String opName, String taskContext) {
        this.handleLOLAPQSATTask(opName, taskContext);
    }

    private void handleEssbaseQSATTask(String opName, String taskContext) {
        this.handleLOLAPQSATTask(opName, taskContext);
    }

    private void handleLOLAPQSATTask(String opName, String taskContext) {
        String dataSource = null;
        String catalog = null;
        String cube = null;
        int firstIndexofSlash = -1;
        int secondIndexofSlash = -1;
        int thirdIndexofSlash = -1;
        if (taskContext != null) {
            firstIndexofSlash = taskContext.indexOf("\"/\"");
            secondIndexofSlash = taskContext.indexOf("\"/\"", firstIndexofSlash + 3);
            thirdIndexofSlash = taskContext.indexOf("\"/\"", secondIndexofSlash + 3);
        }
        dataSource = taskContext.substring(0, firstIndexofSlash);
        catalog = taskContext.substring(firstIndexofSlash + 3, secondIndexofSlash);
        cube = thirdIndexofSlash != -1 ? taskContext.substring(secondIndexofSlash + 3, thirdIndexofSlash) : taskContext.substring(secondIndexofSlash + 3);
        if (opName.equalsIgnoreCase(QUERY_SERVICE_ADMIN_OPERATION_CLEAR_CACHE)) {
            XqeAdministrator.getInstance().getXqeService("All").getSALMetrics().flush(dataSource, catalog, cube);
        } else if (opName.equalsIgnoreCase(QUERY_SERVICE_ADMIN_OPERATION_DUMP_CACHE)) {
            XqeAdministrator.getInstance().getXqeService("All").getSALMetrics().dump(dataSource, catalog, cube);
        }
    }

    public static BIBusEnvelope prepareResponseElementForLOLAPQSAT(BIBusEnvelope responseEnvelope) {
        String commandResponseElementName = "QSATResponse";
        Element commandResponseElement = DOMDocumentFactory.getInstance().createElement(NS_QS.getPrefix() + ":" + commandResponseElementName);
        commandResponseElement.addAttribute(QN_SOAP_ENV_ENCODING_STYLE, NS_SOAP_ENC.getURI());
        commandResponseElement.add(NS_QS);
        Element resultElement = commandResponseElement.addElement(QN_RESULT);
        resultElement.addAttribute(SOAPEnvelope.XSI_TYPE, QN_BUS_ASYNCH_REPLY.getQualifiedName());
        ROLAPAsyncBIBusXMLHelper.addStatusElement(responseEnvelope, resultElement, AsynchReplyStatusEnum.conversationComplete);
        responseEnvelope.getBody().add(commandResponseElement);
        return responseEnvelope;
    }
}

