/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.impl.MessageContextImpl;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.BiBusHeader;
import com.cognos.pogo.pdk.common.UserCapabilityCache;
import com.cognos.pogo.pdk.xml.SAXReaderPool;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorConstants;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.bibushandler.XQEService;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.ISOAPFault;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEExceptionUtils;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.MetricsManager;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.query.engine.SessionContext;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import com.cognos.xqebifw.bibushandler.CancelRequestAdapter;
import com.cognos.xqebifw.bibushandler.ConfigureRequestAdapter;
import com.cognos.xqebifw.bibushandler.DescribeDataSourceQueryRequestAdapter;
import com.cognos.xqebifw.bibushandler.ExecuteDetailQueryRequestAdapter;
import com.cognos.xqebifw.bibushandler.ExecuteMetadataRequestAdapter;
import com.cognos.xqebifw.bibushandler.ExecuteRequestAdapter;
import com.cognos.xqebifw.bibushandler.FMRequestAdapter;
import com.cognos.xqebifw.bibushandler.GetDetailQueriesRequestAdapter;
import com.cognos.xqebifw.bibushandler.GetParametersRequestAdapter;
import com.cognos.xqebifw.bibushandler.GetPartialDatasetRequestAdapter;
import com.cognos.xqebifw.bibushandler.GetServerRequestAdapter;
import com.cognos.xqebifw.bibushandler.KeepAliveSessionsAdapter;
import com.cognos.xqebifw.bibushandler.MoserCommandAdapter;
import com.cognos.xqebifw.bibushandler.PrepareQuerySetRequestAdapter;
import com.cognos.xqebifw.bibushandler.ProviderMetadataRequestAdapter;
import com.cognos.xqebifw.bibushandler.ROLAPAdvisorCommandRequestAdapter;
import com.cognos.xqebifw.bibushandler.ROLAPCubeAdminCommandRequestAdapter;
import com.cognos.xqebifw.bibushandler.ReleaseDatasetRequestAdapter;
import com.cognos.xqebifw.bibushandler.ReleaseQuerySetRequestAdapter;
import com.cognos.xqebifw.bibushandler.ReleaseSessionRequestAdapter;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.RunAdminCommandRequestAdapter;
import com.cognos.xqebifw.bibushandler.SOAPFaultResponseAdapter;
import com.cognos.xqebifw.bibushandler.ShutDownRequestAdapter;
import com.cognos.xqebifw.bibushandler.TestDataSourceConnectionRequestAdapter;
import com.cognos.xqebifw.bibushandler.TestDataSourceConnectionWithInfoRequestAdapter;
import com.cognos.xqebifw.bibushandler.UpdateRequestAdapter;
import com.cognos.xqebifw.bibushandler.ValidateRequestAdapter;
import com.cognos.xqebifw.bibushandler.WaitRequestAdapter;
import com.cognos.xqebifw.config.CCLConfigurationFactoryImpl;
import com.cognos.xqebifw.cubingservices.DQThreadContext;
import com.cognos.xqebifw.cubingservices.IServerListener;
import com.cognos.xqebifw.cubingservices.IV5Provider;
import com.ibm.bi.logging.glug.support.web.GlugLoggingContext;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;

public final class V5QueryHandler
implements IV5Provider {
    private static final String BIBUS_NAME = "name";
    private static final String BIBUS_FORM_FIELD_VARS = "formFieldVars";
    private static final String BIBUS_ENVIRONMENT_VARS = "environmentVars";
    private static final String BIBUS_HDR_SESSION = "hdrSession";
    private static final String BIBUS_COOKIE_VARS = "cookieVars";
    private static final String SESSION_LOGGING_COOKIE = "ba-logging-session";
    public static final String QUERY_SERVICE_SESSION_CONTEXT = "queryServiceSessionContext";
    public static final String ID = "id";
    public static final String CREATE = "create";
    private static final String STR_FOR_REPORT = " for report ";
    private static final String STR_DOT = ".";
    private static final String STR_REQUEST = "\" request";
    private static final String ITEM = "item";
    private static final String TRUE = "true";
    private static final String CAUGHT_ERROR = "Caught error in V5QueryHandler: ";
    private static final String SOAP_FAULT = "V5QueryHandler returning SOAP Fault for request type \"";
    private static final String SERVER_BUSY_FAULT = "SERVER_BUSY";
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private static final int DEFAULT_DISP_SAX_POOL_SIZE = 10;
    private static final int DEFAULT_SERVER_PORT = 9301;
    private static final String INTERNAL_DISPATCHER_KEY = "internalDispatcher";
    private static final String DEFAULT_SOAP_ENDPOINT = "/dataset-service/v1/datasets/soap";
    private static final String SERVER_DIR = System.getProperty("server.config.dir");
    private static final String BOOTSTRAP_PROPERTIES = "/bootstrap.properties";
    private XQELogger mErrorLogger = null;
    private XQELogger mV5RequestLogger = null;
    private XQELogger mV5ResponseLogger = null;
    protected Map<String, RequestAdapter> requestTypeLookup = null;
    private IServerListener mServerListener;
    private static V5QueryHandler instance = null;
    private static XQELogger ipfAuditLogger;
    private static XQELogger perfLogger;
    private static XQELogger parametersLogger;
    private IUsageIndicator parseInputXML;
    private IUsageIndicator v5QueryHandlerMisc;
    private static final List<String> UNUSED_FORM_FIELD_VARS;
    private static final List<String> UNUSED_ENVIRONMENT_VARS;
    private static String serverURL;

    private V5QueryHandler() {
        XQECCLConfigurationFactory.initialize(new CCLConfigurationFactoryImpl());
        XQEService.initialize();
        SAXReaderPool.prepare((boolean)true, (int)10);
        ICCLConfiguration cclConfig = null;
        try {
            cclConfig = XQECCLConfigurationFactory.getInstance();
            String localDispatcher = cclConfig.getValue(INTERNAL_DISPATCHER_KEY, false);
            NodeIdGuidMapper.setContentManagerNID((NodeID)NodeID.getNodeID((String)localDispatcher));
        }
        catch (CCLConfigurationException ce) {
            throw new XQERuntimeException(ce);
        }
        this.setupServerURL();
        this.mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
        this.mV5RequestLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "RequestAdapter.V5Request", LogLevel.INFO);
        this.mV5ResponseLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "RequestAdapter.V5Response", LogLevel.INFO);
        ipfAuditLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryService", LogLevel.INFO);
        perfLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Timing", LogLevel.INFO);
        parametersLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Parameters", LogLevel.INFO);
        this.parseInputXML = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.XQE_SUMMARY, "parseInputXML");
        this.v5QueryHandlerMisc = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.XQE_SUMMARY, "V5QueryHandlerMisc");
        this.setupAdapters(QueryEngine.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupServerURL() {
        int serverPort;
        FileInputStream input;
        XQEConfiguration config;
        block14: {
            config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            if (config == null) {
                throw new XQERuntimeException(new RuntimeException("Failed to initialize the Query Service due to missing XQE Confiugration."));
            }
            input = null;
            Properties prop = new Properties();
            serverPort = config.getIntProperty("network.xqeService[@port]", 9301);
            try {
                input = new FileInputStream(SERVER_DIR + BOOTSTRAP_PROPERTIES);
                prop.load(input);
                String port = prop.getProperty("http.port");
                if (StringUtils.isEmpty((String)port)) {
                    XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "InitTerm", LogLevel.INFO).log("No http.port configured in bootstrap.properties.");
                    break block14;
                }
                serverPort = Integer.parseInt(port);
            }
            catch (IOException e) {
                try {
                    XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "InitTerm", LogLevel.INFO).log("Failed to get http.port from bootstrap.properties");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)input);
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        String soapEndpoint = config.getStringProperty("network.xqeService[@soapEndpoint]", DEFAULT_SOAP_ENDPOINT);
        StringBuilder url = new StringBuilder("");
        boolean urlResolved = true;
        ICCLConfiguration cclConfig = null;
        try {
            cclConfig = XQECCLConfigurationFactory.getInstance();
            String localDispatcher = cclConfig.getValue(INTERNAL_DISPATCHER_KEY, false);
            URL localDispatcherURL = new URL(localDispatcher);
            if (HTTPS_PROTOCOL.compareTo(localDispatcherURL.getProtocol()) == 0) {
                url.append(HTTPS_PROTOCOL);
            } else {
                url.append(HTTP_PROTOCOL);
            }
            url.append("://");
            url.append(localDispatcherURL.getHost());
        }
        catch (CCLConfigurationException cclce) {
            urlResolved = false;
            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "InitTerm", LogLevel.WARN).log("Unable to read internalDispatcher's URL from cclconfig. Falling back to auto resolution.", (Throwable)cclce);
        }
        catch (MalformedURLException murle) {
            urlResolved = false;
            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "InitTerm", LogLevel.WARN).log("Detected malformed internalDispatcher's URL from cclconfig. Falling back to auto resolution.", (Throwable)murle);
        }
        if (!urlResolved) {
            url = new StringBuilder("http://");
            try {
                url.append(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, (Throwable)e, "Unable to determine server name");
            }
        }
        url.append(":").append(serverPort).append(soapEndpoint);
        serverURL = url.toString();
        XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "InitTerm", LogLevel.INFO).log("XQE Server Path: " + serverURL);
    }

    public static synchronized V5QueryHandler getInstance() {
        if (instance == null) {
            instance = new V5QueryHandler();
        }
        return instance;
    }

    @Override
    public ResponseAdapter execute(InputStream bis) {
        return this.execute(bis, null);
    }

    /*
     * Exception decompiling
     */
    public ResponseAdapter execute(InputStream bis, HttpServletRequest servletRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void extractSessionLoggingCookieAndSetUpLoggingContext(Element header) {
        Element cookieVars;
        Element hdrSession = header.element(BIBUS_HDR_SESSION);
        if (null != hdrSession && null != (cookieVars = hdrSession.element(BIBUS_COOKIE_VARS))) {
            List items = cookieVars.elements(ITEM);
            for (Element item : items) {
                Element value;
                String valueText;
                Element name = item.element(BIBUS_NAME);
                if (null == name || !name.getText().equals(SESSION_LOGGING_COOKIE) || (valueText = (value = item.element("value")).getText()) == null) continue;
                MDCAdapter mdc = MDC.getMDCAdapter();
                GlugLoggingContext.setupLoggingControl((MDCAdapter)mdc, (String)valueText);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResponseAdapter executeRequestInSequence(RequestAdapter requestAdapter, RequestEnvironment reqEnv, boolean isSessionContextManagedByUser) throws IOException, XQEException {
        ResponseAdapter responseAdapter;
        block10: {
            responseAdapter = null;
            if (perfLogger.isOn()) {
                perfLogger.log(OperationEnum.START, "Start of V5QueryHandler->executeRequestInSequence().");
            }
            boolean sequentializeRequest = isSessionContextManagedByUser && requestAdapter.requiresMultiRequestContext() && requestAdapter.sequentializeRequestsInSession();
            List<Node> formFieldVars = V5QueryHandler.cleanUpHeaders(reqEnv.getBibusHeader(), BIBUS_FORM_FIELD_VARS, UNUSED_FORM_FIELD_VARS);
            List<Node> environmentVars = V5QueryHandler.cleanUpHeaders(reqEnv.getBibusHeader(), BIBUS_ENVIRONMENT_VARS, UNUSED_ENVIRONMENT_VARS);
            try {
                if (sequentializeRequest) {
                    Object lockObject;
                    SessionContext sessionContext = ((ExecutionEnvironment)reqEnv.getExecutionEnvironment()).getMultiRequestContext().getSessionContext();
                    Object object = lockObject = sessionContext.getSequentailLockObject();
                    synchronized (object) {
                        responseAdapter = requestAdapter.executeRequest(reqEnv);
                        break block10;
                    }
                }
                responseAdapter = requestAdapter.executeRequest(reqEnv);
            }
            finally {
                if (responseAdapter != null && responseAdapter.getSOAPResponse() != null) {
                    V5QueryHandler.attachVars(responseAdapter.getSOAPResponse().getHeader(), formFieldVars, BIBUS_FORM_FIELD_VARS);
                    V5QueryHandler.attachVars(responseAdapter.getSOAPResponse().getHeader(), environmentVars, BIBUS_ENVIRONMENT_VARS);
                }
            }
        }
        if (perfLogger.isOn()) {
            perfLogger.log(OperationEnum.END, "End of V5QueryHandler->executeRequestInSequence().");
        }
        return responseAdapter;
    }

    private static List<Node> cleanUpHeaders(Element bibusHeader, String variable, List<String> unUsed) {
        List vars;
        Element elem;
        Element hdrSession;
        LinkedList<Node> detachedVars = new LinkedList<Node>();
        if (bibusHeader != null && (hdrSession = bibusHeader.element(BIBUS_HDR_SESSION)) != null && (elem = hdrSession.element(variable)) != null && (vars = elem.elements(ITEM)) != null) {
            for (Object var : vars) {
                String text;
                Element eVar = (Element)var;
                Element name = eVar.element(BIBUS_NAME);
                if (name == null || (text = name.getText()) == null || !unUsed.contains(text)) continue;
                detachedVars.add(eVar.detach());
            }
        }
        return detachedVars;
    }

    private static void attachVars(Element bibusHeader, List<Node> vars, String variable) {
        Element fVars;
        Element hdrSession;
        if (bibusHeader != null && (hdrSession = bibusHeader.element(BIBUS_HDR_SESSION)) != null && (fVars = hdrSession.element(variable)) != null) {
            for (Node var : vars) {
                fVars.add(var);
            }
        }
    }

    public RequestAdapter getRequestAdapter(String requestType) throws XQERuntimeException {
        RequestAdapter requestAdapter = this.requestTypeLookup.get(requestType);
        if (null == requestAdapter) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "No adapter for " + requestType);
        }
        return requestAdapter;
    }

    private static Element extractQueryServiceSessionContextElement(BIBusEnvelope requestEnvelope) {
        Element bodyElement = requestEnvelope.getBody();
        Element queryServiceSessionContextElement = null != bodyElement ? requestEnvelope.getBody().element(QUERY_SERVICE_SESSION_CONTEXT) : null;
        return queryServiceSessionContextElement;
    }

    private static boolean extractCreateAttribute(Element queryServiceSessionContextElement) {
        boolean createAttribute;
        if (null != queryServiceSessionContextElement) {
            String createAttributeString = queryServiceSessionContextElement.attributeValue(CREATE);
            if (null != createAttributeString) {
                if (0 == createAttributeString.length()) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "0 == createAttributeString.length()");
                }
                createAttribute = createAttributeString.equals(TRUE);
            } else {
                createAttribute = false;
            }
        } else {
            createAttribute = false;
        }
        return createAttribute;
    }

    private static void insertSessionContextID(SOAPEnvelope responseEnvelope, String queryServiceSessionContextID) {
        Element bodyElement;
        if (null != responseEnvelope && null != (bodyElement = responseEnvelope.getBody())) {
            Element sessionContextElement = bodyElement.addElement(QUERY_SERVICE_SESSION_CONTEXT);
            sessionContextElement.addAttribute(ID, queryServiceSessionContextID);
        }
    }

    private static LogLevel getExceptionLogLevel(Throwable throwable) {
        LogLevel logLevel = LogLevel.ERROR;
        if (throwable instanceof XQEException) {
            logLevel = ((XQEException)throwable).getLogLevel();
        } else if (throwable instanceof XQERuntimeException) {
            logLevel = ((XQERuntimeException)throwable).getLogLevel();
        }
        return logLevel;
    }

    private SOAPFaultResponseAdapter logThrowableAndBuildSOAPFault(Throwable throwable, boolean canReceiveDetailedErrors) {
        if (parametersLogger.isOn(V5QueryHandler.getExceptionLogLevel(throwable)) && throwable instanceof UnresolvedParameterException) {
            if (parametersLogger.isOn(LogLevel.INFO)) {
                parametersLogger.log(CAUGHT_ERROR, throwable);
            }
        } else if (this.mErrorLogger.isOn(V5QueryHandler.getExceptionLogLevel(throwable))) {
            this.mErrorLogger.log(CAUGHT_ERROR, throwable);
        }
        ISOAPFault iSOAPFault = XQERuntimeException.isOomError(throwable) ? XQERuntimeException.wrapOomError(throwable) : (throwable instanceof ISOAPFault ? (ISOAPFault)((Object)throwable) : new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, throwable));
        if (!canReceiveDetailedErrors && XQEMessages.isInternalException((Throwable)((Object)iSOAPFault)) && !XQERuntimeException.isOomError((Throwable)((Object)iSOAPFault))) {
            iSOAPFault = new XQERuntimeException(XQEMessageKeys.GEN_InternalException);
        }
        if (XQEExceptionUtils.isCriticalSOAPFault(iSOAPFault)) {
            MetricsManager.incrementCounter("NumberOfCriticalFailures");
        }
        Fault fault = iSOAPFault.getFault();
        return new SOAPFaultResponseAdapter(fault, canReceiveDetailedErrors);
    }

    private static RequestEnvironment createRequestEnvironment(BIBusEnvelope requestEnvelope, SessionContext sessionContext, String requestType) {
        Element info;
        RequestEnvironment reqEnv;
        Element requestBody = requestEnvelope.getBody();
        Element commandElement = RequestEnvironment.getCommandElement(requestBody);
        if (sessionContext != null) {
            reqEnv = new RequestEnvironment(requestEnvelope, sessionContext.getCancelableRequestRegistry());
            reqEnv.setSessionContextID(sessionContext.getSessionContextID());
        } else {
            reqEnv = new RequestEnvironment(requestEnvelope);
        }
        Element header = requestEnvelope.getBIBusHeader();
        String dqaLoggingPref = QueryEngineLoggingUtils.getDQALoggingPreference(header);
        if (dqaLoggingPref != null) {
            reqEnv.setDQALoggingPreference(Integer.valueOf(dqaLoggingPref));
        }
        reqEnv.setOperationName(requestType);
        QueryEngine.getInstance().configureRequestEnvironment(reqEnv);
        reqEnv.extractParametersFromCommand(requestEnvelope, commandElement);
        if (sessionContext != null) {
            sessionContext.setRequestEnvironment(reqEnv);
        }
        if ((info = requestEnvelope.getBody().element("info")) != null) {
            info = (Element)info.clone();
            info.detach();
            reqEnv.setInfo(info);
        }
        reqEnv.initializeLoggingOverrides();
        return reqEnv;
    }

    private static void setupFaultLocale(Fault aFault, Locale aLocale) {
        MessageContextImpl messageContext = new MessageContextImpl();
        messageContext.setProperty("locale", (Object)aLocale);
        aFault.setMessageContext((MessageContext)messageContext);
    }

    public static void setServerURL(String url) {
        serverURL = url;
    }

    public static String getServerURL() {
        return serverURL;
    }

    private void logV5Request(RequestEnvironment reqEnv, String requestType) {
        if (ipfAuditLogger.isOn(LogLevel.INFO) || this.mV5RequestLogger.isOn(LogLevel.INFO)) {
            String reportName = reqEnv.getReportName();
            StringBuilder buffer = new StringBuilder("Started executing \"");
            buffer.append(requestType).append(STR_REQUEST);
            buffer.append(STR_FOR_REPORT).append(reportName);
            buffer.append(STR_DOT);
            String data = buffer.toString();
            ipfAuditLogger.log(LogLevel.INFO, OperationEnum.REQUEST, XQEMessageKeys.ADT_ReceivedRequest, requestType, reportName);
            this.mV5RequestLogger.log(LogLevel.INFO, OperationEnum.START, data);
            if (ipfAuditLogger.isOn(LogLevel.TRACE) || this.mV5RequestLogger.isOn(LogLevel.TRACE)) {
                String request = null;
                try {
                    request = reqEnv.getRequestEnvelope().getAsString();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (request != null) {
                    ipfAuditLogger.log(LogLevel.TRACE, OperationEnum.REQUEST, request);
                    this.mV5RequestLogger.log(LogLevel.TRACE, request);
                }
            }
        }
        QueryEngine.getInstance().getRequestRecorder().startRequest(requestType, reqEnv.getRequestID(), (SOAPEnvelope)reqEnv.getRequestEnvelope());
    }

    private ResponseAdapter logV5Response(RequestEnvironment reqEnv, String requestType, ResponseAdapter responseAdapter, Throwable faultException) {
        StringBuilder buffer = new StringBuilder();
        boolean isFault = responseAdapter instanceof SOAPFaultResponseAdapter;
        if (isFault) {
            SOAPFaultResponseAdapter adapter = (SOAPFaultResponseAdapter)responseAdapter;
            if (ipfAuditLogger.isOn(LogLevel.INFO)) {
                String reportName = reqEnv.getReportName();
                ipfAuditLogger.log(LogLevel.INFO, OperationEnum.RESPONSE, XQEMessageKeys.ADT_ReturnSOAPFault, adapter.getLocalizedMessage(XQEMessages.getCurrProductLocale()), requestType, reportName);
            }
            LogLevel exceptionFaultLogLevel = LogLevel.ERROR;
            if (faultException != null) {
                exceptionFaultLogLevel = V5QueryHandler.getExceptionLogLevel(faultException);
            }
            if (parametersLogger.isOn(exceptionFaultLogLevel) && faultException instanceof UnresolvedParameterException) {
                if (parametersLogger.isOn(LogLevel.INFO)) {
                    buffer.append(SOAP_FAULT).append(requestType).append('\"');
                    parametersLogger.log(LogLevel.INFO, buffer.toString());
                    if (null != responseAdapter.getSOAPResponse()) {
                        parametersLogger.log(LogLevel.INFO, responseAdapter.getSOAPResponse().toString());
                    }
                }
            } else if (this.mV5ResponseLogger.isOn(exceptionFaultLogLevel)) {
                buffer.append(SOAP_FAULT).append(requestType).append('\"');
                if (this.mV5ResponseLogger.isOn(LogLevel.INFO)) {
                    this.mV5ResponseLogger.log(LogLevel.ERROR, OperationEnum.END, buffer.toString());
                } else {
                    this.mV5ResponseLogger.log(LogLevel.ERROR, buffer.toString());
                }
                if (null != responseAdapter.getSOAPResponse()) {
                    this.mV5ResponseLogger.log(LogLevel.ERROR, responseAdapter.getSOAPResponse().toString());
                }
            }
        } else {
            if (ipfAuditLogger.isOn(LogLevel.INFO)) {
                String reportName = reqEnv.getReportName();
                ipfAuditLogger.log(LogLevel.INFO, OperationEnum.RESPONSE, XQEMessageKeys.ADT_ReturnResponse, requestType, reportName);
            }
            if (this.mV5ResponseLogger.isOn(LogLevel.INFO)) {
                buffer.append("V5QueryHandler returning normally for request type \"").append(requestType).append('\"');
                this.mV5ResponseLogger.log(LogLevel.INFO, OperationEnum.END, buffer.toString());
            }
            if (this.mV5ResponseLogger.isOn(LogLevel.TRACE) && null != responseAdapter.getSOAPResponse()) {
                this.mV5ResponseLogger.log(LogLevel.TRACE, responseAdapter.getSOAPResponse().toString());
            }
        }
        return QueryEngine.getInstance().getRequestRecorder().endRequest(responseAdapter, isFault);
    }

    protected void setupAdapters(QueryEngine engine) {
        String[] aggregateAdvisorCommandNames;
        HashMap<String, RequestAdapter> tempMap = new HashMap<String, RequestAdapter>();
        RequestAdapter adapter = null;
        adapter = new PrepareQuerySetRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new ReleaseQuerySetRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new ExecuteRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new ValidateRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new CancelRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new TestDataSourceConnectionRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new TestDataSourceConnectionWithInfoRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new GetPartialDatasetRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new ReleaseDatasetRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new GetDetailQueriesRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new ExecuteDetailQueryRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new GetParametersRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new ExecuteMetadataRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new ProviderMetadataRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new DescribeDataSourceQueryRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new UpdateRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new ConfigureRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new GetServerRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new ReleaseSessionRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new KeepAliveSessionsAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new ShutDownRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new RunAdminCommandRequestAdapter();
        adapter.setEngine(engine);
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new ROLAPCubeAdminCommandRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put("getCubeState", adapter);
        tempMap.put("getCubeMetrics", adapter);
        tempMap.put("refreshCubeDataCache", adapter);
        tempMap.put("refreshCubeMemberCache", adapter);
        tempMap.put("refreshCubeSecurity", adapter);
        tempMap.put("restartCubes", adapter);
        tempMap.put("startCubes", adapter);
        tempMap.put("stopCubes", adapter);
        tempMap.put("pauseCubes", adapter);
        tempMap.put("incrementallyLoadCubes", adapter);
        tempMap.put("clearCubeWorkloadLog", adapter);
        adapter = new WaitRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        adapter = new ROLAPAdvisorCommandRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        for (String aggregateAdvisorCommandName : aggregateAdvisorCommandNames = AggregateAdvisorConstants.AGGREGATE_ADVISOR_COMMAND_NAMES) {
            tempMap.put(aggregateAdvisorCommandName, adapter);
        }
        adapter = new FMRequestAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        tempMap.put("validateV5", adapter);
        tempMap.put("rolapGetMembers", adapter);
        adapter = new MoserCommandAdapter();
        adapter.setEngine(engine);
        adapter.init();
        tempMap.put(adapter.getOperationName(), adapter);
        this.requestTypeLookup = Collections.unmodifiableMap(tempMap);
    }

    protected static void sanityCheckForCAMPassport(BIBusEnvelope requestEnvelope) throws XQERuntimeException {
        if (null == requestEnvelope.getPassportID()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "The CAM passport is not specified");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Class<V5QueryHandler> clazz = V5QueryHandler.class;
        synchronized (V5QueryHandler.class) {
            if (instance != null) {
                XQEService.terminate();
                instance = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (RequestAdapter adapter : this.requestTypeLookup.values()) {
                adapter.release();
            }
            DQThreadContext.getInstance().releaseInstance();
            return;
        }
    }

    @Override
    public void registerServerListener(IServerListener listener) {
        this.mServerListener = listener;
    }

    public IServerListener getServerListener() {
        return this.mServerListener;
    }

    private boolean canReceiveDetailedErrors(BIBusEnvelope envelope) {
        BiBusHeader biBusHeader = envelope.getBiBusHeader();
        if (biBusHeader == null) {
            return false;
        }
        UserCapabilityCache userCapabilityCache = biBusHeader.getUserCapabilityCache();
        if (userCapabilityCache == null) {
            return false;
        }
        return userCapabilityCache.hasItem("canReceiveDetailedErrors");
    }

    /*
     * Exception decompiling
     */
    public ResponseAdapter executeRSVP4J(BIBusEnvelope requestEnvelope, String sessionContextID, boolean createSessionContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        perfLogger = null;
        parametersLogger = null;
        UNUSED_FORM_FIELD_VARS = new LinkedList<String>();
        UNUSED_FORM_FIELD_VARS.add("ui.spec");
        UNUSED_FORM_FIELD_VARS.add("conversation");
        UNUSED_ENVIRONMENT_VARS = new LinkedList<String>();
        UNUSED_ENVIRONMENT_VARS.add("SAML_REQUEST_CONTEXT");
        serverURL = null;
    }
}

