/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkerThreadPool
extends ThreadPoolExecutor {
    public WorkerThreadPool(BlockingQueue<Runnable> queue, int minActive, int maxActive, long keepAlive) {
        super(minActive, maxActive, keepAlive, TimeUnit.MILLISECONDS, queue, new QueryWorkerThreadFactory());
    }

    protected boolean start() {
        int coreThreads = this.prestartAllCoreThreads();
        return coreThreads == this.getCorePoolSize();
    }

    protected List<Runnable> stopNow() {
        List<Runnable> activeTasks = this.shutdownNow();
        return activeTasks;
    }

    protected void stop() {
        this.shutdown();
    }

    private static class QueryWorkerThreadFactory
    implements ThreadFactory {
        static final int WORKER_PRIORITY = 8;
        static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        QueryWorkerThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "qcom-" + POOL_NUMBER.getAndIncrement() + "-worker-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            t.setPriority(8);
            return t;
        }
    }
}

