/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices.messaging;

import com.cognos.xqebifw.cubingservices.messaging.SSLSocketOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.net.ssl.SSLSocket;

public class HTTPSSLSocketOutputStream
extends SSLSocketOutputStream {
    private byte[] sizeByteBuffer;
    private byte[] crlfByteBuffer;

    public HTTPSSLSocketOutputStream(SSLSocket sslSocket) {
        super(sslSocket);
    }

    @Override
    public boolean isChunking() {
        return this.chunking;
    }

    @Override
    public void setChunking(boolean isChunking) {
        this.chunking = isChunking;
    }

    @Override
    public void flush() throws IOException {
        if (this.position > 0) {
            if (this.chunking) {
                this.writeChunkSize();
                this.writeChunkData();
            } else {
                super.flush();
            }
        }
    }

    protected void writeChunkData() throws IOException {
        super.flush();
        this.writeCRLF();
    }

    private void writeChunkSize() throws IOException {
        if (this.position <= 0) {
            throw new IllegalArgumentException("The buffer is empty.  Only the last chunk should have a size of zero.");
        }
        this.writeSize(this.position);
        this.writeCRLF();
    }

    private void writeSize(int size) throws IOException {
        this.sizeByteBuffer = HTTPSSLSocketOutputStream.getHexBytes(size);
        this.writeFull(this.sizeByteBuffer);
    }

    @Override
    public void writeCRLF() throws IOException {
        byte[] crlfBuffer = this.getCRLFByteBuffer();
        this.writeFull(crlfBuffer);
    }

    @Override
    public void writeLastChunk() throws IOException {
        if (this.position != 0) {
            throw new IllegalArgumentException("The buffer is not empty.  It should be flushed before the last chunk is written.");
        }
        this.writeSize(0);
        this.writeCRLF();
    }

    private byte[] getCRLFByteBuffer() throws UnsupportedEncodingException {
        if (this.crlfByteBuffer == null) {
            this.crlfByteBuffer = new byte[2];
            byte[] tempCR = "\r".getBytes("UTF-8");
            System.arraycopy(tempCR, 0, this.crlfByteBuffer, 0, tempCR.length);
            byte[] tempLF = "\n".getBytes("UTF-8");
            System.arraycopy(tempLF, 0, this.crlfByteBuffer, tempCR.length, tempLF.length);
        }
        return this.crlfByteBuffer;
    }
}

