/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices.messaging;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqebifw.cubingservices.SSLSession;
import com.cognos.xqebifw.cubingservices.Session;
import com.cognos.xqebifw.cubingservices.messaging.HTTPSSLSocketOutputStream;
import com.cognos.xqebifw.cubingservices.messaging.MsgBox;
import com.cognos.xqebifw.cubingservices.messaging.XMLAMessage;
import com.cognos.xqebifw.cubingservices.messaging.XMLAResponseMessage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocket;

public class SSLMsgBox
extends MsgBox {
    private static final int WARNINGSIZE_4 = 4;
    private static final int KB_1024 = 1024;
    private SSLSession session;
    private static final int BUF_SIZE = 262144;
    public static final String NETWORK_BUFFER_SIZE = "network.bufferSize[@size]";
    private byte[] byteBuffer;
    private int free = 0;
    private int position = 0;
    private static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "RequestAdapter", LogLevel.WARN);

    public SSLMsgBox() {
        this.reset();
    }

    @Override
    public MsgBox.CommState unwrapXMLAMsg(Session sesRead) {
        BufferedInputStream buffIn;
        this.status = MsgBox.CommState.OK;
        this.session = (SSLSession)sesRead;
        if (this.byteBuffer == null) {
            this.byteBuffer = new byte[this.getBufferSize()];
        }
        if ((buffIn = this.session.getBufInputStream()) == null) {
            return MsgBox.CommState.IOERROR;
        }
        int count = this.readData(buffIn, MIN_LENGTH_HTTP, (SSLSession)sesRead);
        if (!this.isOk()) {
            return this.status;
        }
        int lastLimit = this.free;
        int lastPosition = this.position;
        byte[] dataStream = this.getStream();
        if (dataStream == null) {
            this.status = MsgBox.CommState.PROTOCOL_READ_ERROR;
            return this.status;
        }
        ByteArrayInputStream bs = new ByteArrayInputStream(dataStream);
        XMLAMessage inMsg = (XMLAMessage)this.session.getLastInputMessage();
        if (inMsg == null) {
            inMsg = new XMLAMessage(bs, true);
        } else {
            inMsg.resetInput(bs);
        }
        MsgBox.CommState rc = MsgBox.CommState.OK;
        inMsg.setStatus(rc);
        int hdrsLen = 0;
        int entLen = -1;
        long retNo = 0L;
        while (!inMsg.hasHdrs()) {
            try {
                inMsg.unpack();
            }
            catch (Exception e) {
                this.status = MsgBox.CommState.HTTP_BAD_MSG_HEADER;
            }
            if (!this.isOk()) {
                return this.status;
            }
            if (inMsg.getStatus() == MsgBox.CommState.EOS) {
                inMsg.setStatus(MsgBox.CommState.OK);
            }
            if (!this.isOk()) {
                return this.status;
            }
            hdrsLen = inMsg.getMsgLength();
            if (hdrsLen < -1) {
                this.status = MsgBox.CommState.HTTP_INTERNAL_ERROR;
            }
            if (!this.isOk()) {
                return this.status;
            }
            entLen = inMsg.getEntLen();
            if (inMsg.hasHdrs() && (entLen < 0 || this.position >= hdrsLen + entLen)) continue;
            if (++retNo > 1000000L) {
                this.status = MsgBox.CommState.PROTOCOL_READ_TIMEDOUT;
                return this.status;
            }
            try {
                TimeUnit.MICROSECONDS.sleep(retNo * 10L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Thread.yield();
            this.free = lastLimit;
            this.position = lastPosition;
            count = this.readMoreData(buffIn, 1, (SSLSession)sesRead);
            if (!this.isOk()) {
                return this.status;
            }
            lastLimit = this.free;
            lastPosition = this.position;
            dataStream = this.getStream();
            if (dataStream == null) {
                this.status = MsgBox.CommState.PROTOCOL_READ_ERROR;
                return this.status;
            }
            bs = new ByteArrayInputStream(dataStream);
            inMsg.resetInput(bs);
        }
        if (entLen > 0) {
            if (hdrsLen + entLen > this.byteBuffer.length) {
                this.data = new byte[entLen];
                int tpos = 0;
                int spos = hdrsLen - 1;
                tpos = this.moveArr(this.data, dataStream, tpos, spos);
                this.readRest(buffIn, tpos, entLen - (count - hdrsLen));
                if (!this.isOk()) {
                    return this.status;
                }
                bs = new ByteArrayInputStream(this.data);
                inMsg.setInput(bs);
            }
        } else if (inMsg.isChunked()) {
            if (dataStream != null) {
                inMsg.setDataStream(dataStream);
                dataStream = null;
                bs = null;
            }
            inMsg.setChunkCtx(lastLimit, lastPosition, hdrsLen);
            boolean done = false;
            byte[] chunk = null;
            while (!done) {
                chunk = this.getChunk(inMsg, buffIn);
                if (!this.isOk()) {
                    return this.status;
                }
                if (chunk == null) {
                    this.status = MsgBox.CommState.HTTP_CHUNK_ERROR;
                    return this.status;
                }
                if (chunk.length > 0) {
                    inMsg.addChunk(chunk);
                    continue;
                }
                done = true;
            }
            int footersLen = 0;
            retNo = 0L;
            while (!inMsg.hasFooters()) {
                int lineL = -1;
                retNo = 0L;
                inMsg.setStatus(MsgBox.CommState.OK);
                while (lineL < 0) {
                    lineL = inMsg.readHdrLine(retNo == 0L);
                    if (inMsg.getStatus() == MsgBox.CommState.EOS) {
                        inMsg.setStatus(MsgBox.CommState.OK);
                    }
                    if (!this.isOk()) {
                        return this.status;
                    }
                    if (lineL >= 0) continue;
                    if (++retNo > 1000000L) {
                        this.status = MsgBox.CommState.PROTOCOL_READ_TIMEDOUT;
                        return this.status;
                    }
                    try {
                        TimeUnit.MICROSECONDS.sleep(retNo * 10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Thread.yield();
                    count = this.readData(buffIn, 1, null);
                    if (!this.isOk()) {
                        return this.status;
                    }
                    inMsg.setLastLimit(this.free);
                    inMsg.setLastPosition(this.position);
                    byte[] ds = this.getStream();
                    if (ds == null) {
                        this.status = MsgBox.CommState.PROTOCOL_READ_ERROR;
                        return this.status;
                    }
                    inMsg.setDataStream(ds);
                    inMsg.setInput(new ByteArrayInputStream(inMsg.getDataStream()));
                    inMsg.setLastOffset(0);
                }
                footersLen = inMsg.getMsgLength() - hdrsLen;
                if (footersLen < 0) {
                    this.status = MsgBox.CommState.HTTP_INTERNAL_ERROR;
                }
                if (this.isOk()) continue;
                return this.status;
            }
            inMsg.setDataStream(null);
            byte[] allChunks = inMsg.getCoalescedChunk();
            if (allChunks == null) {
                this.status = MsgBox.CommState.HTTP_CHUNK_ERROR;
                return this.status;
            }
            bs = new ByteArrayInputStream(allChunks);
            inMsg.setInput(bs);
        } else {
            throw new IllegalStateException("Invalid incoming message");
        }
        if (this.byteBuffer != null && this.byteBuffer.length > this.getWarnBufferSize()) {
            LOGGER.log("The size of input reqeust = " + this.byteBuffer.length + ".\n");
        }
        this.session.setLastInputMessage(inMsg);
        return this.status;
    }

    private int getBufferSize() {
        int bufferSize = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getIntProperty(NETWORK_BUFFER_SIZE, 0);
        if (bufferSize == 0) {
            return 262144;
        }
        return bufferSize * 1024;
    }

    private int getWarnBufferSize() {
        return this.getBufferSize() * 4;
    }

    private int readData(BufferedInputStream buffIn, int minAmount, SSLSession runSess) {
        int count = -1;
        int total = 0;
        this.position = 0;
        this.free = this.byteBuffer.length;
        long startTime = System.currentTimeMillis();
        do {
            try {
                count = buffIn.read(this.byteBuffer, this.position, this.free);
                if (count == 0) {
                    if (System.currentTimeMillis() - startTime > 300000L) {
                        this.status = MsgBox.CommState.TIMEOUT;
                    }
                    Thread.sleep(1L);
                }
            }
            catch (IOException aioe) {
                this.status = MsgBox.CommState.IOERROR;
            }
            catch (InterruptedException e) {
                this.status = MsgBox.CommState.INTERRUPTED;
            }
            this.free -= (total += count);
            this.position += count;
        } while (total < minAmount && count != -1 && this.isOk());
        if (count == -1) {
            runSess.setEOFReached();
            return count;
        }
        return total;
    }

    private int readMoreData(BufferedInputStream buffIn, int minAmount, SSLSession runSess) {
        int count = -1;
        int total = 0;
        long startTime = System.currentTimeMillis();
        do {
            try {
                count = buffIn.read(this.byteBuffer, this.position, this.free);
                if (count == 0) {
                    if (this.position >= this.free) {
                        byte[] tmp = null;
                        tmp = this.byteBuffer.length * 2 < 0 ? new byte[Integer.MAX_VALUE] : new byte[this.byteBuffer.length * 2];
                        this.moveArr(tmp, this.byteBuffer, 0, 0, this.position);
                        this.free = tmp.length - this.position;
                        this.byteBuffer = tmp;
                    } else if (System.currentTimeMillis() - startTime > 300000L) {
                        this.status = MsgBox.CommState.TIMEOUT;
                    }
                    Thread.sleep(1L);
                }
            }
            catch (IOException aioe) {
                this.status = MsgBox.CommState.IOERROR;
            }
            catch (InterruptedException e) {
                this.status = MsgBox.CommState.INTERRUPTED;
            }
            catch (IndexOutOfBoundsException e) {
                this.status = MsgBox.CommState.BUFFER_SIZE_EXCEEDED;
            }
            this.free -= (total += count);
            this.position += count;
        } while (total < minAmount && count != -1 && this.isOk());
        if (!this.isOk()) {
            return total;
        }
        if (count == -1) {
            runSess.setEOFReached();
            return count;
        }
        return total;
    }

    private void readRest(BufferedInputStream buffIn, int pos, int total) {
        int chunkLen = this.getBufferSize();
        int amount = 0;
        int count = -1;
        while (total > 0) {
            if (total > chunkLen) {
                amount = chunkLen;
                total -= chunkLen;
            } else {
                amount = total;
                total = 0;
            }
            count = this.readData(buffIn, amount, null);
            if (!this.isOk()) {
                return;
            }
            if (count == -1) {
                this.status = MsgBox.CommState.END_OF_STREAM;
                return;
            }
            byte[] dataStream = this.getStream();
            if (dataStream == null) {
                this.status = MsgBox.CommState.PROTOCOL_READ_ERROR;
                return;
            }
            pos = this.moveArr(this.data, dataStream, pos, 0);
        }
    }

    private byte[] getChunk(XMLAMessage inMsg, BufferedInputStream buffIn) {
        byte[] chunk = null;
        int lineL = this.getChunkSize(inMsg, buffIn);
        if (lineL < 0) {
            this.status = MsgBox.CommState.BAD_MSG_BODY;
        }
        if (!this.isOk()) {
            return chunk;
        }
        inMsg.setLastOffset(inMsg.getLastOffset() + lineL - inMsg.skipLen());
        chunk = this.getChunkData(inMsg, buffIn);
        return chunk;
    }

    private int getChunkSize(XMLAMessage inMsg, BufferedInputStream buffIn) {
        int lineL = -1;
        long retNo = 0L;
        inMsg.setStatus(MsgBox.CommState.OK);
        while (lineL < 0) {
            lineL = inMsg.readEntLine(retNo == 0L);
            if (!this.isOk()) {
                return lineL;
            }
            if (lineL >= 0) continue;
            if (++retNo > 1000000L) {
                this.status = MsgBox.CommState.PROTOCOL_READ_TIMEDOUT;
                return lineL;
            }
            try {
                TimeUnit.MICROSECONDS.sleep(retNo * 10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Thread.yield();
            this.readData(buffIn, 1, null);
            inMsg.setLastLimit(this.free);
            inMsg.setLastPosition(this.position);
            byte[] ds = this.getStream();
            if (ds == null) {
                this.status = MsgBox.CommState.PROTOCOL_READ_ERROR;
                return lineL;
            }
            inMsg.setDataStream(ds);
            inMsg.setInput(new ByteArrayInputStream(inMsg.getDataStream()));
            inMsg.setLastOffset(0);
        }
        return lineL;
    }

    private byte[] getChunkData(XMLAMessage inMsg, BufferedInputStream buffIn) {
        byte[] chunk = null;
        int chunkLen = inMsg.getLastChunkLen();
        if (chunkLen < 0) {
            throw new IllegalArgumentException("Invalid chunk length " + chunkLen);
        }
        if (chunkLen == 0) {
            return new byte[0];
        }
        if (inMsg.getLastOffset() + chunkLen > inMsg.getLastPosition()) {
            this.data = new byte[chunkLen];
            int tpos = 0;
            int spos = inMsg.getLastOffset();
            tpos = this.moveArr(this.data, inMsg.getDataStream(), tpos, spos);
            int haveLen = inMsg.getLastPosition() - inMsg.getLastOffset();
            int needLen = chunkLen - haveLen;
            this.readRest(inMsg, buffIn, tpos, needLen);
            if (!this.isOk()) {
                return chunk;
            }
            inMsg.setInput(new ByteArrayInputStream(inMsg.getDataStream()));
            try {
                inMsg.getInputStream().skip(needLen);
            }
            catch (Exception e) {
                this.status = MsgBox.CommState.BAD_MSG_BODY;
            }
            if (!this.isOk()) {
                return chunk;
            }
            return this.data;
        }
        chunk = new byte[chunkLen];
        this.moveArr(chunk, inMsg.getDataStream(), 0, inMsg.getLastOffset(), chunkLen);
        try {
            inMsg.getInputStream().skip(chunkLen);
        }
        catch (Exception e) {
            this.status = MsgBox.CommState.BAD_MSG_BODY;
        }
        inMsg.setLastOffset(inMsg.getLastOffset() + chunkLen);
        return chunk;
    }

    private void readRest(XMLAMessage inMsg, BufferedInputStream buffIn, int pos, int total) {
        int chunkLen = this.byteBuffer.length;
        int amount = 0;
        int count = -1;
        byte[] dataStream = null;
        while (total > 0) {
            if (total > chunkLen) {
                amount = chunkLen;
                total -= chunkLen;
            } else {
                amount = total;
                total = 0;
            }
            count = this.readData(buffIn, amount, null);
            if (!this.isOk()) {
                return;
            }
            if (count == -1) {
                this.status = MsgBox.CommState.END_OF_STREAM;
                return;
            }
            dataStream = this.getStream();
            if (dataStream == null) {
                this.status = MsgBox.CommState.PROTOCOL_READ_ERROR;
                return;
            }
            pos = this.moveArr(this.data, dataStream, pos, 0, amount);
        }
        inMsg.setDataStream(dataStream);
        inMsg.setLastOffset(amount);
        inMsg.setLastLimit(this.free);
        inMsg.setLastPosition(this.position);
    }

    private byte[] getStream() {
        this.free = this.position;
        if (this.position <= 0) {
            return null;
        }
        byte[] m = new byte[this.position];
        System.arraycopy(this.byteBuffer, 0, m, 0, this.position);
        return m;
    }

    @Override
    public void reset() {
        this.data = null;
        this.byteBuffer = null;
        this.free = this.getBufferSize();
        this.position = 0;
        this.status = MsgBox.CommState.OK;
    }

    @Override
    public MsgBox.CommState wrapXMLAMsg(Session sesWrite) {
        this.status = MsgBox.CommState.OK;
        this.session = (SSLSession)sesWrite;
        SSLSocket sslSocket = this.session.getSSLSocket();
        HTTPSSLSocketOutputStream httpSocketOutputStream = new HTTPSSLSocketOutputStream(sslSocket);
        XMLAResponseMessage outMsg = (XMLAResponseMessage)sesWrite.getLastOutputMessage();
        sesWrite.setLastOutputMessage(null);
        try {
            outMsg.pack();
        }
        catch (Exception e) {
            this.status = MsgBox.CommState.HTTP_BAD_MSG_HEADER;
            return this.status;
        }
        this.data = outMsg.getMessageStatus();
        if (this.data == null || this.data.length == 0) {
            this.status = MsgBox.CommState.HTTP_BAD_MSG_STATUS;
            return this.status;
        }
        if (this.writeMessageInfo(outMsg, httpSocketOutputStream, this.data) != MsgBox.CommState.OK) {
            return this.status;
        }
        this.data = outMsg.getMessageHeader();
        if (this.data != null && this.data.length > 0) {
            if (this.writeMessageInfo(outMsg, httpSocketOutputStream, this.data) != MsgBox.CommState.OK) {
                return this.status;
            }
            if (this.writeMessageBody(outMsg, httpSocketOutputStream) != MsgBox.CommState.OK) {
                return this.status;
            }
        }
        return this.status;
    }
}

