/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices.messaging;

import com.cognos.xqebifw.cubingservices.messaging.AbstractSocketOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class SocketChannelOutputStream
extends AbstractSocketOutputStream {
    private Selector selector;
    protected ByteBuffer byteBuffer;
    protected SocketChannel socketChannel;

    public SocketChannelOutputStream(ByteBuffer buffer, SocketChannel channel) {
        this.byteBuffer = buffer;
        this.socketChannel = channel;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.selector != null) {
            this.selector.close();
        }
        this.selector = null;
        super.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.byteBuffer.position() > 0) {
            this.write(this.byteBuffer);
            this.byteBuffer.clear();
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            this.flush();
        }
        this.byteBuffer.put((byte)(b & 0xFF));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (b.length == 0) {
            return;
        }
        if (off < 0 || len < 0 || off + len > b.length || off >= b.length) {
            throw new IndexOutOfBoundsException();
        }
        int amount = 0;
        int pos = 0;
        while (len > 0) {
            int remaining;
            if (!this.byteBuffer.hasRemaining()) {
                this.flush();
            }
            amount = len > (remaining = this.byteBuffer.remaining()) ? remaining : len;
            this.byteBuffer.put(b, off + pos, amount);
            if ((len -= amount) <= 0) continue;
            pos += amount;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    protected void write(ByteBuffer buffer) throws IOException {
        int bytesWritten;
        buffer.flip();
        for (int bytesRemaining = buffer.remaining(); bytesRemaining > 0; bytesRemaining -= bytesWritten) {
            bytesWritten = this.socketChannel.write(buffer);
            if (bytesWritten != 0) continue;
            if (this.selector == null) {
                this.selector = Selector.open();
                this.socketChannel.register(this.selector, 4);
            }
            this.selector.select();
        }
    }
}

