/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices.messaging;

import com.cognos.xqe.cubingservices.messaging.Message;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqebifw.cubingservices.messaging.MsgBox;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;

public class XMLAMessage
extends Message {
    public static final String POST = "POST";
    public static final int POST_LEN = "POST".length();
    public static final String CNTN_TYP = "Content-Type";
    public static final int CNTN_TYP_LEN = "Content-Type".length();
    public static final String TEXT_XML_PARAM = "text/xml; charset=utf-8";
    public static final String CNTN_LEN = "Content-Length";
    public static final int CNTN_LEN_LEN = "Content-Length".length();
    public static final String CHUNK_HDR = "Transfer-Encoding";
    public static final int CHUNK_HDR_LEN = "Transfer-Encoding".length();
    public static final String CHUNK_KEY = "chunked";
    public static final int CHUNK_KEY_LEN = "chunked".length();
    public static final String SOAP_ACT = "SOAPAction";
    public static final int SOAP_ACT_LEN = "SOAPAction".length();
    public static final String[] XQE_SOAP_ACTIONS = new String[]{"http://developer.cognos.com/schemas/queryService", "http://developer.cognos.com/schemas/queryService/1", "http://developer.cognos.com/schemas/queryService/1.high", "http://developer.cognos.com/schemas/queryService/1.session", "http://developer.cognos.com/schemas/queryService/1.absolute", "http://developer.cognos.com/schemas/queryService/1.control", "http://developer.cognos.com/schemas/queryService/1.server", "http://www.ibm.com/xmlns/prod/cognos/queryService/201101/", "http://www.ibm.com/xmlns/prod/cognos/queryService/201101/.high", "http://www.ibm.com/xmlns/prod/cognos/queryService/201101/.session", "http://www.ibm.com/xmlns/prod/cognos/queryService/201101/.absolute", "http://www.ibm.com/xmlns/prod/cognos/queryService/201101/.control", "http://www.ibm.com/xmlns/prod/cognos/queryService/201101/.server", "http://www.ibm.com/xmlns/prod/cognos/queryService/201109/", "http://www.ibm.com/xmlns/prod/cognos/queryService/201109/.high", "http://www.ibm.com/xmlns/prod/cognos/queryService/201109/.session", "http://www.ibm.com/xmlns/prod/cognos/queryService/201109/.absolute", "http://www.ibm.com/xmlns/prod/cognos/queryService/201109/.control", "http://www.ibm.com/xmlns/prod/cognos/queryService/201109/.server", "http://www.ibm.com/xmlns/prod/cognos/queryService/201109/.local", "http://www.ibm.com/xmlns/prod/cognos/queryService/201301/", "http://www.ibm.com/xmlns/prod/cognos/queryService/201301/.high", "http://www.ibm.com/xmlns/prod/cognos/queryService/201301/.session", "http://www.ibm.com/xmlns/prod/cognos/queryService/201301/.absolute", "http://www.ibm.com/xmlns/prod/cognos/queryService/201301/.control", "http://www.ibm.com/xmlns/prod/cognos/queryService/201301/.server", "http://www.ibm.com/xmlns/prod/cognos/queryService/201301/.local", "http://www.ibm.com/xmlns/prod/cognos/queryService/201404/", "http://www.ibm.com/xmlns/prod/cognos/queryService/201404/.high", "http://www.ibm.com/xmlns/prod/cognos/queryService/201404/.session", "http://www.ibm.com/xmlns/prod/cognos/queryService/201404/.absolute", "http://www.ibm.com/xmlns/prod/cognos/queryService/201404/.control", "http://www.ibm.com/xmlns/prod/cognos/queryService/201404/.server", "http://www.ibm.com/xmlns/prod/cognos/queryService/201404/.local"};
    public static final HashSet<String> XQE_SOAP_ACTION_SET = new HashSet<String>(Arrays.asList(XQE_SOAP_ACTIONS));
    public static final String CS_XMLA_APPL_SOAP_ACT_DISC = "\"urn:schemas-microsoft-com:xml-analysis:Discover\"";
    public static final String CS_XMLA_APPL_SOAP_ACT_EXEC = "\"urn:schemas-microsoft-com:xml-analysis:Execute\"";
    public static final String CS_XMLA_APPL_SOAP_ACT_CANC = "\"urn:schemas-microsoft-com:xml-analysis:Cancel\"";
    public static final String[] CS_SOAP_ACTIONS = new String[]{"\"urn:schemas-microsoft-com:xml-analysis:Discover\"", "\"urn:schemas-microsoft-com:xml-analysis:Execute\"", "\"urn:schemas-microsoft-com:xml-analysis:Cancel\""};
    public static final String CS_XMLA_APPL_URN = "IBMXmlAnalysis";
    public static final String COMPRESS = "Accept-Encoding";
    public static final int COMPRESS_LEN = "Accept-Encoding".length();
    public static final String COMPRESS_GZIP = "gzip";
    public static final String COMPRESS_DEFLATE = "deflate";
    public static final String COMPRESS_COMPRESS = "compress";
    public static final String COMPRESS_STAR = "*";
    public static final String COMPRESS_IDENTITY = "identity";
    public static final String SECURITY = "Authorization";
    public static final int SECURITY_LEN = "Authorization".length();
    public static final String SECURITY_BASIC = "BASIC";
    public static final String KEEP_CON = "Connection";
    public static final int KEEP_CON_LEN = "Connection".length();
    public static final String KEEP_CON_KEEP_ALIVE = "Keep-Alive";
    public static final String KEEP_CON_CLOSE = "close";
    public static final String KEEP_REQ = "RequestId";
    public static final int KEEP_REQ_LEN = "RequestId".length();
    public static final String EMPTY = "";
    public static final String SPACE = " ";
    public static final String COLON = ":";
    public static final String SEMICOLON = ";";
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final int EOS = -1;
    private static final int RADIX = 16;
    private static final int BUF_SIZE = 80;
    private String appDoc;
    private boolean chunked;
    private boolean secured;
    private boolean hdrend;
    private boolean footerEnd;
    private int lineNo;
    private int firstHdrLineNo;
    private int charNo;
    private int skipNo;
    private int totChars;
    private int entityLen;
    private int lastChunkL;
    private StringBuilder line;
    private ByteArrayInputStream inputStream;
    private String uri;
    private String soapAction;
    private float gzipVal;
    private float deflateVal;
    private float compressVal;
    private float starVal;
    private float identityVal;
    private String base64Val;
    private String keepAliveVal;
    private String reqIdVal;
    private MsgBox.CommState status;
    private int lastLimit;
    private int lastPosition;
    private int offset;
    private byte[] dataStream;
    private HTTPChunk[] chunks;
    private String zipisrc;
    private String zipistep;
    private String zipisrcsvc;
    private String zipiid;
    private static final int ZIPI_ID_LEN = "zipi.id".length();
    private static final int ZIPI_SRC_LEN = "zipi.src".length();
    private static final int ZIPI_SRC_SVC_LEN = "zipi.src_svc".length();
    private static final int ZIPI_STEP_LEN = "zipi.step".length();

    public XMLAMessage(ByteArrayInputStream is, boolean sec) {
        super((byte)55, (byte)1);
        this.secured = sec;
        this.resetInput(is);
    }

    public void resetInput(ByteArrayInputStream is) {
        this.uri = EMPTY;
        this.appDoc = EMPTY;
        this.soapAction = EMPTY;
        this.base64Val = EMPTY;
        this.keepAliveVal = EMPTY;
        this.reqIdVal = EMPTY;
        this.chunked = false;
        this.hdrend = false;
        this.footerEnd = true;
        this.lineNo = 0;
        this.charNo = 0;
        this.skipNo = 0;
        this.totChars = 0;
        this.firstHdrLineNo = -1;
        this.entityLen = -1;
        this.lastChunkL = -1;
        this.lastLimit = -1;
        this.lastPosition = -1;
        this.offset = -1;
        this.line = null;
        this.gzipVal = 0.0f;
        this.deflateVal = 0.0f;
        this.compressVal = 0.0f;
        this.starVal = 0.0f;
        this.identityVal = 1.0f;
        this.status = MsgBox.CommState.OK;
        this.dataStream = null;
        this.resetChunks();
        this.setInput(is);
    }

    public void setInput(ByteArrayInputStream is) {
        this.inputStream = is;
    }

    public int getNumChunks() {
        if (this.chunks == null) {
            return 0;
        }
        return this.chunks.length;
    }

    public byte[] getChunk(int num) {
        if (this.chunks == null || num > this.getNumChunks() || num < 0) {
            return null;
        }
        return this.chunks[num].getChunk();
    }

    public byte[] getCoalescedChunk() {
        int num = this.getNumChunks();
        if (num == 0) {
            return null;
        }
        int len = 0;
        for (int i = 0; i < num; ++i) {
            len += this.getChunk(i).length;
        }
        byte[] coalescedChunk = new byte[len];
        int tpos = 0;
        for (int i = 0; i < num; ++i) {
            byte[] chunk = this.getChunk(i);
            System.arraycopy(chunk, 0, coalescedChunk, tpos, chunk.length);
            tpos += chunk.length;
        }
        return coalescedChunk;
    }

    public void addChunk(byte[] chunk) {
        if (this.chunks == null) {
            this.chunks = new HTTPChunk[1];
            this.chunks[0] = new HTTPChunk(chunk);
        } else {
            int numChunks = this.chunks.length;
            HTTPChunk[] prevChunks = this.chunks;
            this.chunks = new HTTPChunk[numChunks + 1];
            for (int i = 0; i < numChunks; ++i) {
                this.chunks[i] = prevChunks[i];
            }
            this.chunks[numChunks] = new HTTPChunk(chunk);
        }
    }

    public void resetChunks() {
        this.chunks = null;
    }

    public void setChunkCtx(int lastLim, int lastPos, int off) {
        this.resetChunks();
        this.setLastLimit(lastLim);
        this.setLastPosition(lastPos);
        this.setLastOffset(off);
    }

    public int getLastChunkLen() {
        return this.lastChunkL;
    }

    public void setLastLimit(int ll) {
        this.lastLimit = ll;
    }

    public int getLastLimit() {
        return this.lastLimit;
    }

    public void setLastPosition(int lp) {
        this.lastPosition = lp;
    }

    public int getLastPosition() {
        return this.lastPosition;
    }

    public void setLastOffset(int off) {
        this.offset = off;
    }

    public int getLastOffset() {
        return this.offset;
    }

    public void setDataStream(byte[] ds) {
        this.dataStream = ds;
    }

    public byte[] getDataStream() {
        return this.dataStream;
    }

    private void resetLine() {
        if (this.line == null) {
            this.line = new StringBuilder(80);
        } else {
            this.line.delete(0, this.line.length());
        }
        this.charNo = 0;
        this.skipNo = 0;
    }

    public boolean isQueryMessage() {
        return this.getSOAPaction().equals(CS_XMLA_APPL_SOAP_ACT_EXEC);
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setStatus(MsgBox.CommState st) {
        this.status = st;
    }

    public MsgBox.CommState getStatus() {
        return this.status;
    }

    public String getURI() {
        return this.uri;
    }

    public String getServletName() {
        return this.appDoc;
    }

    public String getSOAPaction() {
        return this.soapAction;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getAuthorization() {
        return this.base64Val;
    }

    public int amountParsed() {
        return this.totChars + this.charNo;
    }

    public int getMsgLength() {
        return this.totChars;
    }

    public int skipLen() {
        return this.skipNo;
    }

    public int getEntLen() {
        return this.entityLen;
    }

    public boolean hasHdrs() {
        return this.hdrend;
    }

    public boolean hasFooters() {
        return this.footerEnd;
    }

    public String keepAliveRef() {
        if (this.reqIdVal != null && this.reqIdVal.length() > 0) {
            return this.reqIdVal;
        }
        if (this.keepAliveVal != null && this.keepAliveVal.length() > 0) {
            return this.keepAliveVal;
        }
        return null;
    }

    public boolean keepAlive() {
        return this.keepAliveRef() != null;
    }

    public boolean deflateAllowed() {
        return this.deflateVal > 0.0f;
    }

    public boolean gzipAllowed() {
        return this.gzipVal > 0.0f;
    }

    @Override
    public void unpack() throws Exception {
        int ll = -1;
        while ((ll = this.readHdrLine(true)) > 0) {
        }
    }

    @Override
    public void pack() throws Exception {
    }

    public int readHdrLine(boolean startLine) {
        if (startLine) {
            this.resetLine();
        }
        int cval = -1;
        MsgBox.CommState errorState = MsgBox.CommState.OK;
        char c = '\u0000';
        boolean eol = false;
        cval = this.inputStream.read();
        while (cval != -1) {
            ++this.charNo;
            c = (char)cval;
            if (c == '\n') {
                eol = true;
                ++this.lineNo;
                this.totChars += this.charNo;
                this.charNo = 0;
                errorState = this.parseHdrLine();
                break;
            }
            if (c != '\r') {
                if (this.firstHdrLineNo < 0) {
                    this.firstHdrLineNo = this.lineNo;
                }
                this.line.append(c);
            }
            cval = this.inputStream.read();
        }
        if (eol) {
            if (errorState != MsgBox.CommState.OK) {
                this.setStatus(errorState);
                return -1;
            }
            return this.line.length();
        }
        this.skipNo = this.charNo;
        return -1;
    }

    private MsgBox.CommState parseHdrLine() {
        if (!this.hdrend && this.firstHdrLineNo >= 0 && this.lineNo - this.firstHdrLineNo == 1) {
            if (!this.containsHeader(POST, POST_LEN)) {
                return MsgBox.CommState.HTTP_METHOD_UNSUPPORTED;
            }
            String p = this.getSingleParam(this.line, POST_LEN, SPACE);
            int uriIdx = p.indexOf(SPACE);
            this.uri = uriIdx > 0 ? p.substring(0, uriIdx) : p;
            uriIdx = this.uri.lastIndexOf("/");
            this.appDoc = uriIdx >= 0 ? this.uri.substring(uriIdx + 1) : this.uri;
            return MsgBox.CommState.OK;
        }
        if (!this.hdrend && this.firstHdrLineNo >= 0 && this.line.length() == 0) {
            this.hdrend = true;
            return MsgBox.CommState.OK;
        }
        if (this.hdrend && this.line.length() == 0) {
            this.footerEnd = true;
            return MsgBox.CommState.OK;
        }
        if (this.firstHdrLineNo >= 0 && this.containsHeader(CNTN_LEN, CNTN_LEN_LEN)) {
            String p = this.getSingleParam(this.line, CNTN_LEN_LEN, COLON);
            if (p == null) {
                return MsgBox.CommState.HTTP_HDR_PARSE_ERROR;
            }
            try {
                this.entityLen = Integer.parseInt(p);
            }
            catch (NumberFormatException ne) {
                return MsgBox.CommState.HTTP_HDR_PARSE_ERROR;
            }
            return MsgBox.CommState.OK;
        }
        if (this.firstHdrLineNo >= 0 && this.containsHeader(SOAP_ACT, SOAP_ACT_LEN)) {
            String p = this.getSingleParam(this.line, SOAP_ACT_LEN, COLON);
            if (p == null) {
                return MsgBox.CommState.HTTP_HDR_PARSE_ERROR;
            }
            this.soapAction = p;
            return MsgBox.CommState.OK;
        }
        if (this.firstHdrLineNo >= 0 && this.containsHeader(COMPRESS, COMPRESS_LEN)) {
            String p = this.getSingleParam(this.line, CNTN_LEN_LEN, COLON);
            String[] cvs = p.split(",");
            for (int i = 0; i < cvs.length; ++i) {
                if (this.processCompress(cvs[i])) continue;
                return MsgBox.CommState.HTTP_HDR_PARSE_ERROR;
            }
            if (this.starVal > this.gzipVal) {
                this.gzipVal = this.starVal;
            }
            if (this.starVal > this.deflateVal) {
                this.deflateVal = this.starVal;
            }
            if (this.starVal > this.compressVal) {
                this.compressVal = this.starVal;
            }
            if (this.identityVal > this.gzipVal) {
                this.gzipVal = 0.0f;
            }
            if (this.identityVal > this.deflateVal) {
                this.deflateVal = 0.0f;
            }
            if (this.identityVal > this.compressVal) {
                this.compressVal = 0.0f;
            }
            if (this.compressVal > this.gzipVal) {
                this.gzipVal = 0.0f;
            }
            if (this.compressVal > this.deflateVal) {
                this.deflateVal = 0.0f;
            }
            if (this.compressVal > this.gzipVal + this.deflateVal) {
                this.gzipVal = 0.0f;
                this.deflateVal = 0.0f;
                return MsgBox.CommState.HTTP_HDR_CODEC_UNSUPP;
            }
            return MsgBox.CommState.OK;
        }
        if (this.firstHdrLineNo >= 0 && this.secured && this.containsHeader(SECURITY, SECURITY_LEN)) {
            String p = this.getSingleParam(this.line, SECURITY_LEN, COLON);
            if (!SECURITY_BASIC.equalsIgnoreCase(p.substring(0, SECURITY_BASIC.length()))) {
                return MsgBox.CommState.HTTP_HDR_ENCRYPT_UNSUPP;
            }
            this.base64Val = p.substring(SECURITY_BASIC.length()).trim();
            return MsgBox.CommState.OK;
        }
        if (this.firstHdrLineNo >= 0 && this.containsHeader(KEEP_CON, KEEP_CON_LEN)) {
            String p = this.getSingleParam(this.line, KEEP_CON_LEN, COLON);
            if (!KEEP_CON_CLOSE.equalsIgnoreCase(p.substring(0, KEEP_CON_CLOSE.length())) && !KEEP_CON_KEEP_ALIVE.equalsIgnoreCase(p.substring(0, KEEP_CON_KEEP_ALIVE.length()))) {
                this.keepAliveVal = p;
            }
            return MsgBox.CommState.OK;
        }
        if (this.firstHdrLineNo >= 0 && this.containsHeader(KEEP_REQ, KEEP_REQ_LEN)) {
            this.reqIdVal = this.getSingleParam(this.line, KEEP_REQ_LEN, COLON);
            return MsgBox.CommState.OK;
        }
        if (this.firstHdrLineNo >= 0 && this.containsHeader(CHUNK_HDR, CHUNK_HDR_LEN)) {
            String p = this.getSingleParam(this.line, CHUNK_HDR_LEN, COLON);
            this.chunked = CHUNK_KEY.equalsIgnoreCase(p.substring(0, CHUNK_KEY_LEN));
            this.footerEnd = false;
            return MsgBox.CommState.OK;
        }
        if (ZipiBridge.isEnabled()) {
            if (this.firstHdrLineNo >= 0 && this.containsHeader("zipi.id", ZIPI_ID_LEN)) {
                this.zipiid = this.getSingleParam(this.line, ZIPI_ID_LEN, COLON);
                return MsgBox.CommState.OK;
            }
            if (this.firstHdrLineNo >= 0 && this.containsHeader("zipi.src_svc", ZIPI_SRC_SVC_LEN)) {
                this.zipisrcsvc = this.getSingleParam(this.line, ZIPI_SRC_SVC_LEN, COLON);
                return MsgBox.CommState.OK;
            }
            if (this.firstHdrLineNo >= 0 && this.containsHeader("zipi.src", ZIPI_SRC_LEN)) {
                this.zipisrc = this.getSingleParam(this.line, ZIPI_SRC_LEN, COLON);
                return MsgBox.CommState.OK;
            }
            if (this.firstHdrLineNo >= 0 && this.containsHeader("zipi.step", ZIPI_STEP_LEN)) {
                this.zipistep = this.getSingleParam(this.line, ZIPI_STEP_LEN, COLON);
                return MsgBox.CommState.OK;
            }
        }
        return MsgBox.CommState.OK;
    }

    private boolean containsHeader(String header, int len) {
        return this.line.length() >= len && header.equalsIgnoreCase(this.line.substring(0, len));
    }

    private String getSingleParam(StringBuilder sb, int start, String delim) {
        String param = null;
        int idx = sb.indexOf(delim, start);
        if (idx < 0) {
            return sb.toString();
        }
        try {
            param = sb.substring(idx + 1);
        }
        catch (StringIndexOutOfBoundsException oob) {
            return param;
        }
        return param.trim();
    }

    private boolean processCompress(String item) {
        String[] parms = item.split(SEMICOLON);
        String c = parms[0].trim();
        String v = EMPTY;
        float f = -1.0f;
        if (parms.length > 1) {
            String x;
            int eqIdx = parms[1].indexOf("=", 1);
            if (eqIdx > 0) {
                x = null;
                try {
                    x = parms[1].substring(eqIdx + 1);
                }
                catch (StringIndexOutOfBoundsException oob) {
                    return false;
                }
            } else {
                return false;
            }
            v = x.trim();
            try {
                f = Float.parseFloat(v);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        if (COMPRESS_GZIP.equalsIgnoreCase(c)) {
            this.gzipVal = f < 0.0f ? 1.0f : f;
        } else if (COMPRESS_DEFLATE.equalsIgnoreCase(c)) {
            this.deflateVal = f < 0.0f ? 1.0f : f;
        } else if (COMPRESS_COMPRESS.equalsIgnoreCase(c)) {
            this.compressVal = f < 0.0f ? 1.0f : f;
        } else if (COMPRESS_STAR.equalsIgnoreCase(c)) {
            this.starVal = f < 0.0f ? 1.0f : f;
        } else if (COMPRESS_IDENTITY.equalsIgnoreCase(c)) {
            this.identityVal = f < 0.0f ? 1.0f : f;
        }
        return true;
    }

    public int readEntLine(boolean startLine) {
        if (startLine) {
            this.resetLine();
        }
        MsgBox.CommState errorState = MsgBox.CommState.OK;
        int cval = -1;
        int lineL = -1;
        this.lastChunkL = -1;
        char c = '\u0000';
        boolean eol = false;
        cval = this.inputStream.read();
        while (!eol && cval != -1) {
            ++this.charNo;
            c = (char)cval;
            if (c == '\n') {
                eol = true;
                break;
            }
            if (c != '\r') {
                this.line.append(c);
            }
            cval = this.inputStream.read();
        }
        if (eol && this.line.length() == 0 && this.getNumChunks() > 0) {
            eol = false;
            cval = this.inputStream.read();
            while (!eol && cval != -1) {
                ++this.charNo;
                c = (char)cval;
                if (c == '\n') {
                    eol = true;
                    break;
                }
                if (c != '\r') {
                    this.line.append(c);
                }
                cval = this.inputStream.read();
            }
        }
        if (eol) {
            if (this.line.length() > 0) {
                lineL = this.charNo;
                String[] x = this.line.toString().split(SEMICOLON);
                if (x[0].length() > 0) {
                    try {
                        this.lastChunkL = Integer.parseInt(x[0].toString(), 16);
                    }
                    catch (NumberFormatException e) {
                        errorState = MsgBox.CommState.HTTP_BAD_CHUNK_SIZE;
                    }
                    if (this.lastChunkL < 0) {
                        errorState = MsgBox.CommState.HTTP_BAD_CHUNK_SIZE;
                    }
                } else {
                    errorState = MsgBox.CommState.HTTP_NO_CHUNK_SIZE;
                }
            } else {
                errorState = MsgBox.CommState.HTTP_NO_CHUNK_SIZE;
            }
        } else {
            lineL = this.lastChunkL;
            this.skipNo = this.charNo;
        }
        if (lineL < 0) {
            this.setStatus(MsgBox.CommState.EOS);
            return -1;
        }
        if (errorState != MsgBox.CommState.OK) {
            this.setStatus(errorState);
            return -1;
        }
        return lineL;
    }

    public String getZipiId() {
        return this.zipiid;
    }

    public String getZipiSrc() {
        return this.zipisrc;
    }

    public String getZipiSrcSvc() {
        return this.zipisrcsvc;
    }

    public String getZipiStep() {
        return this.zipistep;
    }

    public class HTTPChunk {
        byte[] chunk;

        public HTTPChunk(byte[] ch) {
            this.chunk = ch;
        }

        public byte[] getChunk() {
            return this.chunk;
        }
    }
}

