/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.management;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.olap.securecache.DMRMemberStorage;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.QueryReuseManager;

public final class XqeCacheOperations {
    private static XQELogger mLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MIB", LogLevel.ERROR);

    private XqeCacheOperations() {
    }

    public static boolean flush() {
        if (mLogger.isOn(LogLevel.INFO)) {
            mLogger.log(LogLevel.INFO, "Executed flush cache operation");
        }
        boolean status = false;
        try {
            status = MemberStorage.flushAllStorages();
        }
        catch (Exception e) {
            mLogger.log(e);
        }
        return status;
    }

    public static boolean flush(String dataSourceName, String catalogName, String cubeName) {
        if (mLogger.isOn(LogLevel.INFO)) {
            mLogger.log(LogLevel.INFO, "Executed flush cache operation with parameters, dataSourceName=" + dataSourceName + ", catalogName=" + catalogName + ", cubename=" + cubeName);
        }
        if ("*".equals(dataSourceName)) {
            XqeCacheOperations.flushRelationalRelatedCaches();
        }
        return MemberStorage.flushStorage(dataSourceName, catalogName, cubeName);
    }

    private static void flushRelationalRelatedCaches() {
        QueryReuseManager qrm;
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (!config.getBooleanProperty("general.clearCacheForRelational[@enabled]", true)) {
            return;
        }
        QueryEngine xqeQueryEngine = QueryEngine.getInstance();
        if (xqeQueryEngine != null) {
            xqeQueryEngine.getCacheManager().clearMAResultCache();
            xqeQueryEngine.getCacheManager().clearPlanTrees();
            xqeQueryEngine.setLastClearCacheTime(System.currentTimeMillis());
        }
        if ((qrm = QueryReuseManager.getInstance()) != null) {
            qrm.clearQREntriesAndResultSetCache();
        }
    }

    public static String dump() {
        if (mLogger.isOn(LogLevel.INFO)) {
            mLogger.log(LogLevel.INFO, "Executed dump cache operation");
        }
        String dumpFilePath = null;
        try {
            dumpFilePath = MemberStorage.dumpAllStorages();
        }
        catch (Exception e) {
            mLogger.log(e);
        }
        return dumpFilePath;
    }

    public static String dump(String dataSourceName, String catalogName, String cubeName) {
        if (mLogger.isOn(LogLevel.INFO)) {
            mLogger.log(LogLevel.INFO, "Executed dump cache operation with parameters, dataSourceName=" + dataSourceName + ", catalogName=" + catalogName + ", cubename=" + cubeName);
        }
        return MemberStorage.dumpStorageState(dataSourceName, catalogName, cubeName);
    }

    public static boolean flushDMRCache(String dataSourceName, String packageName) {
        if (mLogger.isOn(LogLevel.INFO)) {
            mLogger.log(LogLevel.INFO, "Executed flushDMRCache cache operation with parameters, dataSourceName=" + dataSourceName + ", packageName=" + packageName);
        }
        if (dataSourceName != null && !dataSourceName.equals("")) {
            return DMRMemberStorage.flushStorageForDS(dataSourceName);
        }
        if (packageName != null && !packageName.equals("")) {
            return DMRMemberStorage.flushStorageForPackage(packageName);
        }
        return false;
    }

    public static String dumpDMRCache(String dataSourceName, String packageName) {
        if (mLogger.isOn(LogLevel.INFO)) {
            mLogger.log(LogLevel.INFO, "Executed dumpDMRCache cache operation with parameters, dataSourceName=" + dataSourceName + ", packageName=" + packageName);
        }
        if (dataSourceName != null && !dataSourceName.equals("")) {
            return DMRMemberStorage.dumpStorageStateForDS(dataSourceName);
        }
        if (packageName != null && !packageName.equals("")) {
            return DMRMemberStorage.dumpStorageStateForPackage(packageName);
        }
        return null;
    }

    public static boolean flushDMRCache() {
        if (mLogger.isOn(LogLevel.INFO)) {
            mLogger.log(LogLevel.INFO, "Executed flushDMRCache cache operation");
        }
        return DMRMemberStorage.flushAllStorages();
    }

    public static String dumpDMRCache() {
        if (mLogger.isOn(LogLevel.INFO)) {
            mLogger.log(LogLevel.INFO, "Executed dumpDMRCache cache operation");
        }
        String dumpFilePath = null;
        try {
            dumpFilePath = DMRMemberStorage.dumpAllStorages();
        }
        catch (Exception e) {
            mLogger.log(e);
        }
        return dumpFilePath;
    }
}

