/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.management.cogadmin;

import com.cognos.pogo.monitoring.ServiceStatus;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.MetricsManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqebifw.management.cogadmin.AdminConsoleMemoryMetrics;
import com.cognos.xqebifw.management.cogadmin.AdminConsolePackageCacheMetrics;
import com.cognos.xqebifw.management.cogadmin.AdminConsoleRequestMetrics;
import com.cognos.xqebifw.management.cogadmin.AdminConsoleRolapCacheMetrics;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;

public final class AdminConsoleMetricsMBean
extends NotificationBroadcasterSupport
implements DynamicMBean,
NotificationListener {
    private static final String PROXY_OBJECT_NAMES = "ProxyObjectNames";
    public static final String METRICS_PROXY_MBEAN_NAME = "com.cognos.xqe:type=requestMetrics,service=queryService";
    public static final String REQUEST_MBEAN_NAME = "com.cognos:type=request,service=queryService";
    public static final String ROLAP_CACHE_MBEAN_NAME = "com.cognos:type=rolapCache,service=queryService";
    public static final String PACKAGE_CACHE_MBEAN_NAME = "com.cognos:type=packageCache,service=queryService";
    public static final String MEMORY_METRICS_MBEAN_NAME = "com.cognos:type=MemoryMetrics,service=queryService";
    public static final String REGISTER_PROXY = "registerProxy";
    public static final String DEFAULT_DESCRIPTION = "Attribute exposed for management";
    private static final String LONG = "long";
    private static final String VOID = "void";
    private static final String RESET = "reset";
    private static XQELogger mLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MIB", LogLevel.ERROR);
    private MBeanServer mbeanServer;
    AdminConsoleRequestMetrics requestMBean;
    AdminConsoleRolapCacheMetrics cacheMBean;
    AdminConsolePackageCacheMetrics packageCacheMBean;
    AdminConsoleMemoryMetrics memoryMetricsMBean;
    public static final String[] ATTRIBUTE_NAMES = new String[]{"OperationalStatus", "OperationalStatusLastUpdateTime", "CurrentTime", "NumberOfReceivedRequests", "NumberOfReceivedRequestsLastUpdateTime", "NumberOfReceivedRequestsLastResetTime", "NumberOfSuccessfulRequests", "NumberOfSuccessfulRequestsLastUpdateTime", "NumberOfSuccessfulRequestsLastResetTime", "NumberOfFailedRequests", "NumberOfFailedRequestsLastUpdateTime", "NumberOfFailedRequestsLastResetTime", "ServiceTimeAllRequests", "ServiceTimeAllRequestsLastUpdateTime", "ServiceTimeAllRequestsLastResetTime", "ServiceTimeSuccessfulRequests", "ServiceTimeSuccessfulRequestsLastUpdateTime", "ServiceTimeSuccessfulRequestsLastResetTime", "ServiceTimeFailedRequests", "ServiceTimeFailedRequestsLastUpdateTime", "ServiceTimeFailedRequestsLastResetTime", "ResponseTimeHighWaterMark", "ResponseTimeHighWaterMarkLastUpdateTime", "ResponseTimeLowWaterMark", "ResponseTimeLowWaterMarkLastUpdateTime", "MillisecondsPerSuccessfulRequest", "SuccessfulRequestsPerMinute", "FailedRequestPercent", "SuccessfulRequestPercent", "XqeQueriesPlanned", "XqeQueriesPlannedLastUpdateTime", "XqeQueriesPlannedLastResetTime", "XqeSuccessfulQueriesPlanned", "XqeSuccessfulQueriesPlannedLastUpdateTime", "XqeSuccessfulQueriesPlannedLastResetTime", "XqeFailedQueriesPlanned", "XqeFailedQueriesPlannedLastUpdateTime", "XqeFailedQueriesPlannedLastResetTime", "XqeQueriesExecuted", "XqeQueriesExecutedLastUpdateTime", "XqeQueriesExecutedLastResetTime", "XqeSuccessfulQueriesExecuted", "XqeSuccessfulQueriesExecutedLastUpdateTime", "XqeSuccessfulQueriesExecutedLastResetTime", "XqeFailedQueriesExecuted", "XqeFailedQueriesExecutedLastUpdateTime", "XqeFailedQueriesExecutedLastResetTime", "AllRequestsLastUpdateTime", "ConsolidatedLastResponseTime", "FailedRequestsLastUpdateTime", "LastRequestResetTime", "LastResponseTime", "LastResponseTimeLastUpdateTime", "OperationalStatusLastUpdateTime", "ReceivedRequestsLastUpdateTime", "SuccessfulRequestsLastUpdateTime"};
    private MBeanInfo mbeanInfo = null;

    private AdminConsoleMetricsMBean(MBeanServer server) {
        this.mbeanServer = server;
    }

    private void initStandardMBeans() {
        ObjectName name;
        try {
            this.requestMBean = new AdminConsoleRequestMetrics(this.mbeanServer, METRICS_PROXY_MBEAN_NAME);
            name = new ObjectName(REQUEST_MBEAN_NAME);
            this.mbeanServer.registerMBean(this.requestMBean, name);
        }
        catch (Exception e) {
            mLogger.log(e);
        }
        try {
            this.cacheMBean = new AdminConsoleRolapCacheMetrics(this.mbeanServer, METRICS_PROXY_MBEAN_NAME);
            name = new ObjectName(ROLAP_CACHE_MBEAN_NAME);
            this.mbeanServer.registerMBean(this.cacheMBean, name);
        }
        catch (Exception e) {
            mLogger.log(e);
        }
        try {
            this.packageCacheMBean = new AdminConsolePackageCacheMetrics(this.mbeanServer, "com.cognos.xqe:type=packageMetrics,service=queryService");
            name = new ObjectName(PACKAGE_CACHE_MBEAN_NAME);
            this.mbeanServer.registerMBean(this.packageCacheMBean, name);
        }
        catch (Exception e) {
            mLogger.log(e);
        }
        try {
            this.memoryMetricsMBean = new AdminConsoleMemoryMetrics(this.mbeanServer, METRICS_PROXY_MBEAN_NAME);
            name = new ObjectName(MEMORY_METRICS_MBEAN_NAME);
            this.mbeanServer.registerMBean(this.memoryMetricsMBean, name);
        }
        catch (Exception e) {
            mLogger.log(e);
        }
    }

    private Set<ObjectName> getProxyMBeans() throws MBeanException {
        try {
            ObjectName wildcard = new ObjectName(MetricsManager.getMBeanName("*"));
            return this.mbeanServer.queryNames(wildcard, null);
        }
        catch (MalformedObjectNameException e) {
            throw new MBeanException(e);
        }
        catch (NullPointerException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new AttributeNotFoundException("null");
        }
        Date dateValue = null;
        Long longValue = null;
        String stringValue = null;
        CompositeData compositeValue = null;
        if (PROXY_OBJECT_NAMES.equals(attribute)) {
            Set<ObjectName> nameSet = this.getProxyMBeans();
            ArrayList<String> names = new ArrayList<String>();
            for (ObjectName objName : nameSet) {
                names.add(objName.toString());
            }
            return names.toArray(new String[0]);
        }
        for (ObjectName mbean : this.getProxyMBeans()) {
            Object value = null;
            try {
                value = this.mbeanServer.getAttribute(mbean, attribute);
            }
            catch (RuntimeMBeanException e) {
                if (mLogger.isOn(LogLevel.INFO)) {
                    mLogger.log(LogLevel.INFO, "Remote connection failed for mBean: " + mbean.toString(), (Throwable)e);
                }
            }
            catch (InstanceNotFoundException e) {
                mLogger.log(e);
            }
            if (value instanceof Date) {
                if (dateValue == null) {
                    dateValue = (Date)value;
                    continue;
                }
                if (dateValue.compareTo((Date)value) >= 0) continue;
                dateValue = (Date)value;
                continue;
            }
            if (value instanceof Long) {
                if (longValue == null) {
                    longValue = (Long)value;
                    continue;
                }
                longValue = longValue + (Long)value;
                continue;
            }
            if (value instanceof String) {
                stringValue = (String)value;
                continue;
            }
            if (value instanceof CompositeData) {
                compositeValue = (CompositeData)value;
                continue;
            }
            return value;
        }
        if (dateValue != null) {
            return dateValue;
        }
        if (longValue != null) {
            return longValue;
        }
        if (stringValue != null) {
            return stringValue;
        }
        if (compositeValue != null) {
            return compositeValue;
        }
        if (attribute.endsWith("Time")) {
            return new Date();
        }
        if ("OperationalStatus".equals(attribute)) {
            return ServiceStatus.UNAVAILABLE;
        }
        if (mLogger.isOn(LogLevel.INFO)) {
            mLogger.log(LogLevel.INFO, "attribute " + attribute + " value is null. Returning Long.valueOf(0)");
        }
        return 0L;
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList result = new AttributeList();
        if (attributes == null) {
            return result;
        }
        for (String attrib : attributes) {
            try {
                result.add(new Attribute(attrib, this.getAttribute(attrib)));
            }
            catch (Exception e) {
                mLogger.log(e);
            }
        }
        return result;
    }

    private MBeanInfo buildMBeanInfo() {
        MBeanInfo info = null;
        ArrayList<MBeanAttributeInfo> attributeInfoList = new ArrayList<MBeanAttributeInfo>();
        for (String name : ATTRIBUTE_NAMES) {
            String typeString = LONG;
            if (name.endsWith("LastResetTime") || name.endsWith("LastUpdateTime")) {
                typeString = Date.class.getName();
            }
            attributeInfoList.add(new MBeanAttributeInfo(name, typeString, DEFAULT_DESCRIPTION, true, false, false));
        }
        attributeInfoList.add(new MBeanAttributeInfo(PROXY_OBJECT_NAMES, "String[]", "", true, false, false));
        attributeInfoList.add(new MBeanAttributeInfo("CubeState", CompositeData.class.getCanonicalName(), "Cube states", true, false, false));
        attributeInfoList.add(new MBeanAttributeInfo("PackageCacheState", CompositeData.class.getCanonicalName(), "Package cache state", true, false, false));
        MBeanAttributeInfo[] attributeInfo = attributeInfoList.toArray(new MBeanAttributeInfo[0]);
        MBeanOperationInfo[] operationInfo = new MBeanOperationInfo[]{new MBeanOperationInfo(RESET, "Reset metrics", null, VOID, 1), new MBeanOperationInfo(RESET, "Reset metrics a counter type.", new MBeanParameterInfo[]{new MBeanParameterInfo("type", String.class.getName(), "Counter type")}, VOID, 1), new MBeanOperationInfo(REGISTER_PROXY, "Register a proxy mbean for notifications.", new MBeanParameterInfo[]{new MBeanParameterInfo("name", String.class.getName(), "Proxy MBean name")}, VOID, 1)};
        MBeanNotificationInfo[] notifInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "A metric in this MBean has changed.")};
        info = new MBeanInfo(this.getClass().getName(), "Creates metrics proxy objects on query service startup.", attributeInfo, null, operationInfo, notifInfo);
        return info;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.mbeanInfo == null) {
            this.mbeanInfo = this.buildMBeanInfo();
        }
        return this.mbeanInfo;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            if (REGISTER_PROXY.equals(actionName)) {
                ObjectName objName = new ObjectName((String)params[0]);
                this.mbeanServer.addNotificationListener(objName, this, null, null);
                return null;
            }
            Object result = null;
            for (ObjectName mbean : this.getProxyMBeans()) {
                result = this.mbeanServer.invoke(mbean, actionName, params, signature);
            }
            return result;
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (MalformedObjectNameException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException(attribute.getName());
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }

    public static void createMBean(MBeanServer server) {
        AdminConsoleMetricsMBean metricsMBean = new AdminConsoleMetricsMBean(server);
        try {
            ObjectName requestName = new ObjectName(METRICS_PROXY_MBEAN_NAME);
            server.registerMBean(metricsMBean, requestName);
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
        metricsMBean.initStandardMBeans();
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        this.sendNotification(notification);
    }
}

