/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.runtree.olap.mdx.rolapprovider.admin.tool;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailMessages;
import com.cognos.developer.schemas.bibus._3.AsynchDetailROLAPDataSourceState;
import com.cognos.developer.schemas.bibus._3.AsynchDetailUnstructuredData;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionInt;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.GenericOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.GenericOptionBoolean;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.QueryServiceStub;
import com.cognos.developer.schemas.bibus._3.QueryService_PortType;
import com.cognos.developer.schemas.bibus._3.QueryService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.RoutingInfo;
import com.cognos.developer.schemas.bibus._3.UserCapabilityCache;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.xqe.bibushandler.XQEService;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCommandResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeCommandResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeMetricResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateResult;
import com.cognos.xqebifw.bibushandler.content.LogonCommand;
import com.cognos.xqebifw.runtree.olap.mdx.rolapprovider.admin.tool.ROLAPAdminTestTool;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Stub;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;

public class BiBusCommandPlugin
implements ROLAPAdminTestTool.ICommandPlugin {
    private static final String COLON = ":";
    private static final String NAMESPACE_URI = "http://developer.cognos.com/schemas/bibus/3/";
    private static final QName BI_BUS_HEADER_QNAME = new QName("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 9300;
    private static final int DEFAULT_WAIT_THRESHOLD = 5;
    public static final String ALL_CAPABILITIES = "all";
    private static final String QUOTE = "\"";
    private URL dispatcherURL;
    private String serverHost = "localhost";
    private int serverPort = 9300;
    private int waitThreshold = 5;
    private List<String> capabilitiesToRemove = new ArrayList<String>();
    private List<String> capabilitiesToAdd = new ArrayList<String>();
    private QueryService_PortType queryService;
    private String[] credentials = new String[]{"", null, null};

    public BiBusCommandPlugin(String serverOverride, int portOverride, int waitThresholdOverride, String[] capabilitiesToRemoveOverride, String[] capabilitiesToAddOverride, String[] credentialsOverride) {
        if (serverOverride != null) {
            this.serverHost = serverOverride;
        }
        if (portOverride != -1) {
            this.serverPort = portOverride;
        }
        if (waitThresholdOverride != -1) {
            this.waitThreshold = waitThresholdOverride;
        }
        if (capabilitiesToRemoveOverride != null) {
            for (String capabilityToRemove : capabilitiesToRemoveOverride) {
                this.capabilitiesToRemove.add(capabilityToRemove);
            }
        }
        if (capabilitiesToAddOverride != null) {
            for (String capabilityToAdd : capabilitiesToAddOverride) {
                this.capabilitiesToAdd.add(capabilityToAdd);
            }
        }
        if (credentialsOverride != null) {
            this.credentials = credentialsOverride;
        }
    }

    @Override
    public IROLAPCommandResult executeCommand(String command, List<String> cubes, HashMap<String, String> arguments, boolean silent) throws Exception {
        AsynchReplyStatusEnum replyStatus;
        String[] cubeNames = cubes.toArray(new String[cubes.size()]);
        ParameterValue[] parameters = new ParameterValue[]{};
        ArrayList<Object> options = new ArrayList<Object>();
        AsynchOptionInt primaryWait = new AsynchOptionInt();
        primaryWait.setName(AsynchOptionEnum.primaryWaitThreshold);
        primaryWait.setValue(this.waitThreshold);
        options.add(primaryWait);
        AsynchOptionInt secondaryWait = new AsynchOptionInt();
        secondaryWait.setName(AsynchOptionEnum.secondaryWaitThreshold);
        secondaryWait.setValue(this.waitThreshold);
        options.add(secondaryWait);
        AsynchReply reply = null;
        if ("getCubeMetrics".equals(command)) {
            this.getQueryService(true);
            reply = this.queryService.getCubeState(new String[0], parameters, options.toArray(new Option[0]));
            replyStatus = reply.getStatus();
            while (replyStatus == AsynchReplyStatusEnum.working || replyStatus == AsynchReplyStatusEnum.stillWorking) {
                reply = this.getQueryService(false).wait(reply.getPrimaryRequest(), new ParameterValue[0], new Option[0]);
                replyStatus = reply.getStatus();
            }
        }
        if (!silent) {
            ROLAPAdminTestTool.println(String.format("Executing command '%s' on cube(s) %s", command, cubes.toString()));
        }
        this.getQueryService(true);
        ROLAPAdminTestTool.printVerbose("Sending request to the Query Service to execute the command.");
        if ("startCubes".equals(command)) {
            reply = this.queryService.startCubes(cubeNames, parameters, options.toArray(new Option[0]));
        } else if ("stopCubes".equals(command)) {
            reply = this.queryService.stopCubes(cubeNames, parameters, options.toArray(new Option[0]));
        } else if ("forceStartCubes".equals(command)) {
            GenericOptionBoolean startCubeAndSources = new GenericOptionBoolean();
            startCubeAndSources.setName("http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#startROLAPCubesAndSourceCubes");
            startCubeAndSources.setValue(true);
            options.add(startCubeAndSources);
            reply = this.queryService.startCubes(cubeNames, parameters, options.toArray(new Option[0]));
        } else if ("forceStopCubes".equals(command)) {
            GenericOptionBoolean stopImmediately = new GenericOptionBoolean();
            stopImmediately.setName("http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#stopROLAPCubesImmediately");
            stopImmediately.setValue(true);
            options.add(stopImmediately);
            reply = this.queryService.stopCubes(cubeNames, parameters, options.toArray(new Option[0]));
        } else if ("restartCubes".equals(command)) {
            reply = this.queryService.restartCubes(cubeNames, parameters, options.toArray(new Option[0]));
        } else if ("refreshCubeMemberCache".equals(command)) {
            reply = this.queryService.refreshCubeMemberCache(cubeNames, parameters, options.toArray(new Option[0]));
        } else if ("refreshCubeDataCache".equals(command)) {
            reply = this.queryService.refreshCubeDataCache(cubeNames, parameters, options.toArray(new Option[0]));
        } else if ("refreshCubeSecurity".equals(command)) {
            reply = this.queryService.refreshCubeSecurity(cubeNames, parameters, options.toArray(new Option[0]));
        } else if ("clearCubeWorkloadLog".equals(command)) {
            reply = this.queryService.clearCubeWorkloadLog(cubeNames, parameters, options.toArray(new Option[0]));
        } else if ("pauseCubes".equals(command)) {
            reply = this.queryService.pauseCubes(cubeNames, parameters, options.toArray(new Option[0]));
        } else if ("incrementallyLoadCubes".equals(command)) {
            if (arguments.containsKey("transactionID")) {
                GenericOptionAnyURI tid = new GenericOptionAnyURI();
                tid.setName("http://developer.cognos.com/ceba/constants/queryTaskOptionEnum#transactionID");
                tid.setValue(arguments.get("transactionID"));
                options.add(tid);
            }
            reply = this.queryService.incrementallyLoadCubes(cubeNames, parameters, options.toArray(new Option[0]));
        } else if ("getCubeState".equals(command)) {
            reply = this.queryService.getCubeState(cubeNames, parameters, options.toArray(new Option[0]));
        } else if ("getCubeMetrics".equals(command)) {
            reply = this.queryServiceCall("getCubeMetrics", cubeNames, parameters, options.toArray(new Option[0]));
        }
        replyStatus = reply.getStatus();
        while (replyStatus == AsynchReplyStatusEnum.working || replyStatus == AsynchReplyStatusEnum.stillWorking) {
            ROLAPAdminTestTool.printVerbose("The Query Service is " + replyStatus);
            ROLAPAdminTestTool.printVerbose("Waiting " + this.waitThreshold + " sec for the Query Service to complete execution.");
            reply = this.getQueryService(false).wait(reply.getPrimaryRequest(), parameters, options.toArray(new Option[0]));
            replyStatus = reply.getStatus();
        }
        ROLAPAdminTestTool.printVerbose("The Query Service completed execution.");
        if (!silent) {
            ROLAPAdminTestTool.println(String.format("Finished executing command '%s' on cube(s) %s\n", command, cubes.toString()));
        }
        return this.processReply(reply, silent);
    }

    private OperationDesc createOperation(String name) {
        OperationDesc oper = new OperationDesc();
        oper.setName(name);
        ParameterDesc param = new ParameterDesc(new QName("", "cubeNames"), 1, new QName(NAMESPACE_URI, "stringArray"), String[].class, false, false);
        oper.addParameter(param);
        param = new ParameterDesc(new QName("", "parameterValues"), 1, new QName(NAMESPACE_URI, "parameterValueArray"), ParameterValue[].class, false, false);
        oper.addParameter(param);
        param = new ParameterDesc(new QName("", "options"), 1, new QName(NAMESPACE_URI, "optionArray"), Option[].class, false, false);
        oper.addParameter(param);
        oper.setReturnType(new QName(NAMESPACE_URI, "asynchReply"));
        oper.setReturnClass(AsynchReply.class);
        oper.setReturnQName(new QName("", "result"));
        oper.setStyle(Style.RPC);
        oper.setUse(Use.ENCODED);
        return oper;
    }

    private AsynchReply queryServiceCall(String command, String[] cubeNames, ParameterValue[] parameterValues, Option[] options) throws RemoteException, ServiceException {
        Object resp;
        QueryServiceStub qs = (QueryServiceStub)this.queryService;
        Call call = (Call)qs._getService().createCall();
        call.setOperation(this.createOperation(command));
        call.setUseSOAPAction(true);
        call.setSOAPActionURI("http://www.ibm.com/xmlns/prod/cognos/queryService/201404/.absolute");
        call.setSOAPVersion((SOAPConstants)SOAPConstants.SOAP11_CONSTANTS);
        call.setOperationName(new QName("http://developer.cognos.com/schemas/queryService/1", command));
        call.setTargetEndpointAddress(this.getDispatcherURL());
        call.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
        call.setPortName(qs.getPortName());
        SOAPHeaderElement[] sh = qs.getHeaders();
        if (sh != null) {
            for (SOAPHeaderElement elt : sh) {
                call.addHeader(elt);
            }
        }
        if ((resp = call.invoke(new Object[]{cubeNames, parameterValues, options})) instanceof RemoteException) {
            throw (RemoteException)resp;
        }
        qs.extractAttachments(call);
        try {
            return (AsynchReply)resp;
        }
        catch (Exception ex) {
            return (AsynchReply)JavaUtils.convert((Object)resp, AsynchReply.class);
        }
    }

    @Override
    public ROLAPCubeStateResult getCubeStates(List<String> cubes, boolean silent) throws Exception {
        return (ROLAPCubeStateResult)this.executeCommand("getCubeState", cubes, null, silent);
    }

    private URL getDispatcherURL() {
        StringBuilder httpInfo = new StringBuilder();
        if (this.dispatcherURL == null) {
            try {
                if (XQEService.isSSLProtocol()) {
                    httpInfo.append("https://");
                } else {
                    httpInfo.append("http://");
                }
                String dispatcherURLString = httpInfo + this.serverHost + COLON + this.serverPort + "/p2pd/servlet/dispatch";
                ROLAPAdminTestTool.printVerbose("Using the dispatcher: " + dispatcherURLString);
                this.dispatcherURL = new URL(dispatcherURLString);
            }
            catch (MalformedURLException ex) {
                ROLAPAdminTestTool.error(String.format("Error processing dispatcher URL '%s'", this.dispatcherURL.toString()), ex);
            }
            catch (CCLConfigurationException e) {
                ROLAPAdminTestTool.error(String.format("Configuration error  '%s'", httpInfo), e);
            }
        }
        return this.dispatcherURL;
    }

    private IROLAPCommandResult processReply(AsynchReply reply, boolean silent) {
        IROLAPCommandResult result = null;
        ROLAPAdminTestTool.printVerbose("Processing the reply.");
        ROLAPAdminTestTool.printVerbose("The reply status is: " + reply.getStatus());
        AsynchDetail[] details = reply.getDetails();
        if (details == null || details.length == 0) {
            ROLAPAdminTestTool.printVerbose("The reply contained no details.");
        } else {
            ROLAPAdminTestTool.printVerbose("The reply details are:");
            if (details[0] instanceof AsynchDetailROLAPDataSourceState) {
                result = new ROLAPCubeStateResult();
            } else if (details[0] instanceof AsynchDetailMessages) {
                result = new ROLAPCubeCommandResult();
            } else if (details[0] instanceof AsynchDetailUnstructuredData) {
                result = new ROLAPCubeMetricResult();
            } else {
                ROLAPAdminTestTool.printVerbose("The reply is not an instance of AsynchDetailROLAPDataSourceState or AsynchDetailMessages.");
            }
            if (result != null) {
                result.load(details);
            }
        }
        return result;
    }

    private BiBusHeader buildBiBusHeader() {
        LogonCommand logonCommand = new LogonCommand(QUOTE + this.credentials[0] + QUOTE, this.credentials[1], this.credentials[2]);
        return logonCommand.buildHeader();
    }

    private QueryService_PortType getQueryService(boolean isNewConversation) {
        BiBusHeader biBusHeader;
        if (this.queryService == null) {
            ROLAPAdminTestTool.printVerbose("Creating the Query Service.");
            QueryService_ServiceLocator queryServiceLocator = new QueryService_ServiceLocator();
            try {
                this.queryService = queryServiceLocator.getqueryService(this.getDispatcherURL());
            }
            catch (Exception ex) {
                ROLAPAdminTestTool.error("Error locating Query Service", ex);
            }
        }
        if ((biBusHeader = this.getBiBusHeaderFromLatestSOAPResponse()) == null) {
            ROLAPAdminTestTool.printVerbose("Logging onto CM to create a BiBusHeader.");
            biBusHeader = this.buildBiBusHeader();
            biBusHeader.setRouting(null);
        } else {
            if (isNewConversation) {
                ROLAPAdminTestTool.printVerbose("Setting up a new conversation.");
                String routingServerGroup = this.getRoutingServerGroup(biBusHeader);
                if (routingServerGroup != null && routingServerGroup.length() > 0) {
                    ROLAPAdminTestTool.printVerbose("Using routing server group: " + routingServerGroup);
                    RoutingInfo routingInfo = new RoutingInfo(routingServerGroup);
                    biBusHeader.setRouting(routingInfo);
                } else {
                    biBusHeader.setRouting(null);
                }
            }
            ROLAPAdminTestTool.printVerbose("Clearing the Query Service header.");
            ((Stub)this.queryService).clearHeaders();
        }
        this.addRemoveCapabilities(biBusHeader);
        ROLAPAdminTestTool.printVerbose("Setting the Query Service header.");
        ((Stub)this.queryService).setHeader(BI_BUS_HEADER_QNAME.getNamespaceURI(), BI_BUS_HEADER_QNAME.getLocalPart(), (Object)biBusHeader);
        return this.queryService;
    }

    private BiBusHeader getBiBusHeaderFromLatestSOAPResponse() {
        ROLAPAdminTestTool.printVerbose("Getting the latest SOAP response from the Query Service.");
        SOAPHeaderElement responseHeader = ((Stub)this.queryService).getResponseHeader(BI_BUS_HEADER_QNAME.getNamespaceURI(), BI_BUS_HEADER_QNAME.getLocalPart());
        if (responseHeader == null) {
            return null;
        }
        BiBusHeader biBusHeader = null;
        try {
            biBusHeader = (BiBusHeader)responseHeader.getValueAsType(BI_BUS_HEADER_QNAME);
        }
        catch (Exception ex) {
            ROLAPAdminTestTool.error("Failed to get biBusHeader from latest SOAP response", ex);
        }
        return biBusHeader;
    }

    private String getRoutingServerGroup(BiBusHeader biBusHeader) {
        String routingServerGroup = null;
        RoutingInfo routingInfo = biBusHeader.getRouting();
        if (routingInfo != null) {
            routingServerGroup = routingInfo.getRoutingServerGroup();
        }
        return routingServerGroup;
    }

    private void addRemoveCapabilities(BiBusHeader biBusHeader) {
        if (!this.capabilitiesToRemove.isEmpty() || !this.capabilitiesToAdd.isEmpty()) {
            UserCapabilityCache userCapabilityCache = biBusHeader.getUserCapabilityCache();
            if (userCapabilityCache == null) {
                ROLAPAdminTestTool.error("User capability cache is empty");
            }
            UserCapabilityEnum[] userCapabilityEnumArray = userCapabilityCache.getUserCapabilities();
            ArrayList<Object> userCapabilityEnumList = new ArrayList<Object>();
            if (this.capabilitiesToRemove.contains(ALL_CAPABILITIES)) {
                ROLAPAdminTestTool.printVerbose("Removing all capabilities.");
                userCapabilityCache.setUserCapabilities(null);
            } else if (userCapabilityEnumArray != null) {
                for (UserCapabilityEnum userCapabilityEnum : userCapabilityEnumArray) {
                    String userCapabilityEnumString = userCapabilityEnum.getValue();
                    if (!this.capabilitiesToRemove.contains(userCapabilityEnumString)) {
                        userCapabilityEnumList.add(userCapabilityEnum);
                        continue;
                    }
                    ROLAPAdminTestTool.printVerbose("Removing the capability: " + userCapabilityEnumString);
                }
            }
            for (String capabilityToAdd : this.capabilitiesToAdd) {
                if (userCapabilityEnumList.contains(capabilityToAdd)) continue;
                TestUserCapabilityEnum capability = new TestUserCapabilityEnum(capabilityToAdd);
                userCapabilityEnumList.add((Object)capability);
                ROLAPAdminTestTool.printVerbose("Adding the capability: " + capabilityToAdd);
            }
            userCapabilityCache.setUserCapabilities(userCapabilityEnumList.toArray(new UserCapabilityEnum[userCapabilityEnumList.size()]));
        }
    }

    @Override
    public void setProperty(String propertyName, String propertyValue, List<String> cubes) throws Exception {
        ROLAPAdminTestTool.error("The set command is not supported in BiBus mode.");
    }

    private class TestUserCapabilityEnum
    extends UserCapabilityEnum {
        private static final long serialVersionUID = 1L;

        TestUserCapabilityEnum(String capability) {
            super(capability);
        }
    }
}

