/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.zipi;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.RequestAdapter;
import com.ibm.cognos.pogo.zipi.ZipiAPI;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.concurrent.Callable;

public class ZipiCallable<E>
implements Callable<E> {
    XQELogger eLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Timing", LogLevel.ERROR);
    private final Callable<E> delegate;
    private final String action;
    private final String objPath;
    private final RequestAdapter zipiRequestAdapter;
    private final String retrivedQRDName;

    public ZipiCallable(Callable<E> callable, String zipiAction, String zipiObjPath) {
        this.delegate = callable;
        String actionName = zipiAction;
        if (actionName == null) {
            actionName = this.getActionName(callable);
        }
        this.action = actionName == null ? "EmptyActionName" : actionName;
        this.objPath = zipiObjPath != null ? zipiObjPath : "";
        this.zipiRequestAdapter = ZipiAPI.createThreadRequestAdapter();
        this.retrivedQRDName = ZipiContext.getQRDName();
    }

    private String getActionName(Callable<E> callable) {
        String actionN = callable.toString();
        if (this.isDefaultObjectName(actionN)) {
            actionN = callable.getClass().getName();
        }
        return actionN;
    }

    private boolean isDefaultObjectName(String actionN) {
        return actionN != null && actionN.contains("@");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E call() throws Exception {
        ZipiTimer zipiTimer = null;
        try {
            ZipiBridge.clearCurrentContext();
            zipiTimer = ZipiBridge.startTimer(this.zipiRequestAdapter);
            ZipiContext.setQRDName(this.retrivedQRDName);
            StringBuilder objLongName = new StringBuilder(this.objPath);
            if (this.objPath != "") {
                objLongName.append("_");
            }
            ZipiBridge.updateZipiContext(zipiTimer, this.action, objLongName.append(this.retrivedQRDName).toString());
        }
        catch (Exception e) {
            this.eLogger.log(e);
        }
        try {
            E e = this.delegate.call();
            return e;
        }
        finally {
            try {
                zipiTimer.stopAndClear();
            }
            catch (Exception e) {
                this.eLogger.log(e);
            }
        }
    }

    public String toString() {
        return this.delegate.toString();
    }
}

