/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.util.QuerySubjectSQLGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqemfw4j.MFWMetadata;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import java.lang.ref.SoftReference;
import java.util.List;

class MFWAccessedViaShortcut
extends MFWMetadata
implements IAccessedViaShortcut {
    private static final String MACRO_MARKER = "#";
    private IShortcut shortcut = null;
    private SoftReference<SQLGenerator> sqlGen = new SoftReference<Object>(null);
    private Boolean mInvolvedInJoinRelationship;

    MFWAccessedViaShortcut(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandles) {
        super(mfwConnection, mfwHandles);
    }

    @Override
    public boolean isAccessedViaShortcut() {
        return this.shortcut != null;
    }

    @Override
    public IShortcut getShortcut() {
        return this.shortcut;
    }

    @Override
    public void setShortcut(IShortcut scObj) {
        this.shortcut = scObj;
    }

    public IXQEQueryNode generateSQLAST(PlanningEnvironment environment, IXQEQueryNode ownerNode, IQuerySubject querySubject) throws ParseException {
        SQLGenerator generator = null;
        if (querySubject != null) {
            generator = new SQLGenerator(querySubject);
        } else {
            generator = this.sqlGen.get();
            if (null == generator) {
                generator = new SQLGenerator((IQuerySubject)((Object)this));
                this.sqlGen = new SoftReference<SQLGenerator>(generator);
            }
        }
        return generator.generateSQLAST(environment, ownerNode);
    }

    public Boolean getInvolvedInJoins() {
        return this.mInvolvedInJoinRelationship;
    }

    public void setInvolvedInJoins(boolean b) {
        this.mInvolvedInJoinRelationship = b;
    }

    public static void expandMacrosinSQLRelation(IXQEQueryNode sqlAST, PlanningEnvironment environment) {
        List<IXQEQueryNode> relationNodes = sqlAST.getDescendantsOfTypesOrdered(new int[]{301016}, true);
        for (IXQEQueryNode rel : relationNodes) {
            String schema;
            String catalog;
            SQLRelation relation = (SQLRelation)rel;
            String databaseName = relation.getDatabaseName();
            if (MacroExpander.isMacro(databaseName)) {
                relation.setRawCmDatabaseName(databaseName);
                relation.setDatabaseName(QuerySubjectSQLGenerator.getMacroExpandedString(databaseName, environment));
            }
            if (MacroExpander.isMacro(catalog = relation.getCatalogName())) {
                relation.setRawCatalogName(catalog);
                catalog = QuerySubjectSQLGenerator.getMacroExpandedString(catalog, environment);
                if (catalog != null && catalog.length() > 0) {
                    relation.setCatalogName(catalog);
                } else {
                    relation.removeProperty("catalog");
                }
            }
            if (!MacroExpander.isMacro(schema = relation.getSchemaName())) continue;
            relation.setRawSchemaName(schema);
            schema = QuerySubjectSQLGenerator.getMacroExpandedString(schema, environment);
            if (schema != null && schema.length() > 0) {
                relation.setSchemaName(schema);
                continue;
            }
            relation.removeProperty("schema");
        }
    }

    private class SQLGenerator {
        private final IQuerySubject theQS;
        private IXQEQueryNode sqlAST = null;
        private String unexpandedSQL = null;
        private String expandedSQL = null;
        private QuerySubjectSQLGenerator.SqlType sqlType = null;

        SQLGenerator(IQuerySubject qs) {
            this.theQS = qs;
        }

        public IXQEQueryNode generateSQLAST(PlanningEnvironment environment, IXQEQueryNode ownerNode) throws ParseException {
            QuerySubjectSQLGenerator sqlGenerator = new QuerySubjectSQLGenerator(ownerNode);
            if (this.sqlAST == null || !this.expandedSQLSameAsBefore(sqlGenerator, environment)) {
                if (this.unexpandedSQL == null) {
                    this.unexpandedSQL = sqlGenerator.getUnexpandedSQL(this.theQS);
                    this.sqlType = sqlGenerator.getSqlType();
                }
                this.sqlAST = sqlGenerator.generateSQLAST(environment, this.theQS);
                this.sqlAST.detach();
                if (this.unexpandedSQL.contains(MFWAccessedViaShortcut.MACRO_MARKER)) {
                    this.expandedSQL = sqlGenerator.getMacroExpandedSQL(environment, this.unexpandedSQL, sqlGenerator.getSqlType(), this.theQS);
                }
            }
            IXQEQueryNode sqlASTcopy = environment.getNodeFactory().deepCopyNode(this.sqlAST);
            MFWAccessedViaShortcut.expandMacrosinSQLRelation(sqlASTcopy, environment);
            this.setDBHint(environment, ownerNode, sqlASTcopy);
            if (sqlGenerator.hasMacroInCMDataSource()) {
                this.sqlAST = null;
            }
            return sqlASTcopy;
        }

        protected void setDBHint(PlanningEnvironment environment, IXQEQueryNode ownerNode, IXQEQueryNode sqlASTcopy) {
            if (sqlASTcopy.getType() != 301007) {
                return;
            }
            String desc = this.theQS.getDescription();
            String kw = "DBHINT={";
            if (desc == null || desc.isEmpty()) {
                return;
            }
            int idx = desc.indexOf(kw);
            if (idx == -1) {
                return;
            }
            String s = desc.substring(idx + kw.length());
            if ((idx = s.indexOf("}")) == -1) {
                return;
            }
            if ((s = s.substring(0, idx)).isEmpty()) {
                return;
            }
            if (s.contains(MFWAccessedViaShortcut.MACRO_MARKER)) {
                MacroExpander expander = new MacroExpander();
                expander.setLocalParameters(MetadataContext.getLocalParameters(this.theQS));
                s = expander.expand(ownerNode, environment, s);
            }
            sqlASTcopy.setPropertyValue("dbHint", s);
        }

        private boolean expandedSQLSameAsBefore(QuerySubjectSQLGenerator sqlGenerator, PlanningEnvironment environment) {
            if (this.expandedSQL == null) {
                return true;
            }
            String expSQL = sqlGenerator.getMacroExpandedSQL(environment, this.unexpandedSQL, this.sqlType, this.theQS);
            return expSQL.equals(this.expandedSQL);
        }
    }
}

