/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.utilities.IMFWUsageIndicator;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestGateway;
import com.cognos.xqemfw4j.MFWUsageIndicator;

public class MFWJSONMetadataConnection
extends MFWMetadataConnection {
    private String cmDataSource = null;

    public String getCmDataSource() {
        return this.cmDataSource;
    }

    @Override
    public void connect(String connectionString, String theExpressionLocale, IExecutionEnvironment execEnv, MFWRequestContext requestContext) {
        XQELogger traceLogger = MFWJSONMetadataConnection.getLogger();
        this.cmDataSource = connectionString;
        String theContentLocale = requestContext.getContentLocale();
        String theProductLocale = requestContext.getProductLocale();
        requestContext.setXQEUsageIndicatorService((IMFWUsageIndicator)new MFWUsageIndicator());
        try {
            MFWJSONMetadataConnection.initializeRequiredComponents();
            this.metadataSource = this.getDefaultMetadataSource();
            MFWGateway gatewayImpl = MFWGateway.open((String)"XQEMetadataGateway", (MFWRequestContext)requestContext, (MFWMetadataSource)this.metadataSource);
            MFWMultiRequestGateway.Parameters params = MFWMultiRequestGateway.Parameters.fromRequestContext(requestContext);
            this.gateway = new MFWMultiRequestGateway((ExecutionEnvironment)execEnv, "XQEMetadataGateway", this.metadataSource, params, gatewayImpl);
            this.projectHandle = this.queryHandle("/project");
            this.projectHandle.persist();
            this.expressionLocaleString = this.getUseDesignLocaleForReferenceID() ? this.getDefaultLocaleString() : LocaleConverter.localeToStr(LocaleConverter.resolveLocale(theExpressionLocale, this.queryLocales()));
            this.contentLocaleString = LocaleConverter.localeToStr(LocaleConverter.resolveLocale(theContentLocale, this.queryLocales()));
            this.productLocaleString = theProductLocale;
        }
        catch (UnresolvedParameterException ex) {
            throw ex;
        }
        catch (MFWException ex) {
            if (traceLogger.isOn(LogLevel.ERROR)) {
                StringBuilder logBuf = new StringBuilder();
                logBuf.append("Connection failed ");
                MFWJSONMetadataConnection.appendConnectionInfo(logBuf, this.metadataSource);
                logBuf.append("; Caused by: ");
                traceLogger.log(LogLevel.ERROR, logBuf.toString(), (Throwable)ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (traceLogger.isOn(LogLevel.ERROR)) {
                StringBuilder logBuf = new StringBuilder();
                logBuf.append("Connection failed ");
                MFWJSONMetadataConnection.appendConnectionInfo(logBuf, this.metadataSource);
                logBuf.append("; Caused by: ");
                traceLogger.log(LogLevel.ERROR, logBuf.toString(), (Throwable)ex);
            }
            throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, (Throwable)ex, this.cmDataSource);
        }
        if (traceLogger.isOn()) {
            StringBuilder logBuf = new StringBuilder();
            logBuf.append("Established connection ");
            MFWJSONMetadataConnection.appendConnectionInfo(logBuf, this.metadataSource);
            traceLogger.log(logBuf.toString());
        }
    }

    @Override
    protected MFWMetadataSource getDefaultMetadataSource() {
        MFWMetadataSource source = MFWMetadataSource.create((String)"JSON");
        source.addConnectionItem("cmDataSource", (Object)this.cmDataSource);
        source.addConnectionItem("cachingMode", (Object)"transient");
        return source;
    }
}

