/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MetadataBindingException;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import com.cognos.xqemfw4j.MFWDataSource;
import com.cognos.xqemfw4j.MFWHierarchy;
import com.cognos.xqemfw4j.MFWMeasure;
import com.cognos.xqemfw4j.MFWMeasureDimension;
import com.cognos.xqemfw4j.MFWMeasureLevel;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class MFWMeasureHierarchy
extends MFWHierarchy {
    private static final String QUERY_HIERARCHYINFO = "/property[name='measureHierarchyInfo']/__Value";
    IMember[] members = null;

    MFWMeasureHierarchy(MFWMeasureDimension mfwMeasureDimension, String hierarchyUniqueName) {
        super(mfwMeasureDimension.getConnection(), null);
        this.dimension = mfwMeasureDimension;
        this.uniqueName = hierarchyUniqueName;
    }

    MFWMeasureDimension getMfwMeasureDimension() {
        return (MFWMeasureDimension)this.dimension;
    }

    @Override
    public boolean isAutoGenerated() {
        return true;
    }

    @Override
    public IDimension getDimension() {
        return this.dimension;
    }

    @Override
    public String toString() {
        return this.getDimension().toString() + "/" + this.getName();
    }

    @Override
    public List<ILevel> getLevels() {
        if (this.levels == null) {
            this.queryLevels();
        }
        return this.levels;
    }

    @Override
    public IMember getMember(String memberUniqueName) {
        if (memberUniqueName == null) {
            return null;
        }
        IMember member = null;
        for (IMember measure : this.getMembers()) {
            if (!measure.getUniqueName().equals(memberUniqueName)) continue;
            member = measure;
        }
        return member;
    }

    @Override
    public IMember[] getMembers() {
        if (this.members == null) {
            ArrayList<IMember> measureList = new ArrayList<IMember>();
            short ridMeasureFolder = MFWModelRes.getInstance().RID_measureFolder;
            short ridMeasure = MFWModelRes.getInstance().RID_measure;
            Stack<MFWMultiRequestHandle> stack = new Stack<MFWMultiRequestHandle>();
            stack.push(this.getMfwMeasureDimension().getHandle());
            while (stack.size() > 0) {
                MFWMultiRequestHandle handle = (MFWMultiRequestHandle)stack.pop();
                if (handle.getInfo().getRID() == ridMeasure) {
                    MFWMultiRequestHandle handleTemp = handle;
                    ArrayList<MFWMultiRequestHandle> nodeTempList = new ArrayList<MFWMultiRequestHandle>();
                    while (handleTemp.getParent().getNameRID() != MFWModelRes.getInstance().RID_project) {
                        MFWMultiRequestHandle parentHandle = handleTemp.getParent();
                        nodeTempList.add(parentHandle);
                        handleTemp = parentHandle;
                    }
                    ArrayList handleList = new ArrayList(nodeTempList.size() + 1);
                    for (int i = nodeTempList.size() - 1; i >= 0; --i) {
                        handleList.add(nodeTempList.get(i));
                    }
                    handleList.add(handle);
                    measureList.add((IMember)this.getConnection().mfwObjectToMetadataObject(handleList.toArray(new MFWMultiRequestHandle[handleList.size()])));
                    MFWMultiRequestHandle[] hMeasures = this.queryHandles(handle, ridMeasure, new short[0]);
                    for (int i = hMeasures.length - 1; i >= 0; --i) {
                        stack.push(hMeasures[i]);
                    }
                    continue;
                }
                MFWMultiRequestHandle[] hMeasures = this.queryHandles(handle, ridMeasure, new short[0]);
                for (int i = hMeasures.length - 1; i >= 0; --i) {
                    stack.push(hMeasures[i]);
                }
                MFWMultiRequestHandle[] hMeasureFolders = this.queryHandles(handle, ridMeasureFolder, new short[0]);
                for (int i = hMeasureFolders.length - 1; i >= 0; --i) {
                    stack.push(hMeasureFolders[i]);
                }
            }
            this.members = measureList.toArray(new IMember[0]);
        }
        return this.members;
    }

    @Override
    public String getID() {
        return this.getMfwMeasureDimension().getID() + "/" + this.getName();
    }

    @Override
    public IMember getDefaultMember() {
        if (this.defaultMember == null) {
            IMember[] hierarchyMembers;
            MFWDataSource datasource = (MFWDataSource)this.getDimension().getCube().getModelDataSource();
            String defaultMeasureRef = datasource.getCubeDefaultMeasure();
            IMeasure defaultMeasure = null;
            if (defaultMeasureRef != null) {
                try {
                    defaultMeasure = (IMeasure)this.getConnection().bindMetadataReference(defaultMeasureRef);
                }
                catch (MetadataBindingException ex) {
                    defaultMeasure = null;
                }
                catch (XQERuntimeException ex) {
                    if (ex.getMessageKey() == XQEMessageKeys.MD_MetadataBindingFailedTempCubProperty) {
                        defaultMeasure = null;
                    }
                    throw ex;
                }
                if (defaultMeasure == null) {
                    defaultMeasure = (IMeasure)this.getMember(defaultMeasureRef);
                }
            }
            if (defaultMeasure == null && (hierarchyMembers = this.getMembers()) != null && hierarchyMembers.length > 0) {
                defaultMeasure = (IMeasure)hierarchyMembers[0];
            }
            this.defaultMember = defaultMeasure;
        }
        return this.defaultMember;
    }

    @Override
    public IMember getRootMember() {
        List<IMember> rootMembers;
        if (this.rootMember == null && (rootMembers = this.getLevel(0).getMembers()).size() == 1) {
            this.rootMember = rootMembers.get(0);
        }
        return this.rootMember;
    }

    @Override
    public String getUniqueID() {
        if (this.uniqueID == null) {
            this.uniqueID = this.getDimension().getUniqueID();
        }
        return this.uniqueID;
    }

    @Override
    public String getV5UniqueName() {
        return this.getDimension().getV5UniqueName();
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = this.getDimension().getUniqueName();
        }
        return this.uniqueName;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.getDimension().getName();
        }
        return this.name;
    }

    @Override
    public boolean isMultiRoot() {
        if (this.multiRoot == null) {
            this.multiRoot = true;
        }
        return this.multiRoot;
    }

    @Override
    public boolean isParentChild() {
        if (this.parentChild == null) {
            this.parentChild = true;
        }
        return this.parentChild;
    }

    @Override
    public boolean isRagged() {
        if (this.ragged == null) {
            this.ragged = false;
        }
        return this.ragged;
    }

    @Override
    public boolean isUnbalanced() {
        if (this.balanced == null) {
            this.balanced = true;
        }
        return this.balanced == false;
    }

    @Override
    public int getCardinality() {
        return this.getMembers().length;
    }

    /*
     * WARNING - void declaration
     */
    void queryLevels() {
        List<Object> queryLevels = new ArrayList();
        List<MFWMeasure> measures = CollectionCast.downcast(Arrays.asList(this.getMembers()), IMember.class, MFWMeasure.class);
        LinkedList levelMembers = new LinkedList();
        for (MFWMeasure measure : measures) {
            int depth = measure.getDepth();
            while (levelMembers.size() < depth + 1) {
                levelMembers.add(new LinkedList());
            }
            ((List)levelMembers.get(depth)).add(measure);
        }
        String hierarchyInfo = this.queryValue(this.getMfwMeasureDimension().getHandle(), QUERY_HIERARCHYINFO);
        if (hierarchyInfo != null) {
            void var7_15;
            ArrayList<String> externalNames = new ArrayList<String>();
            try {
                XMLStreamReader xmlReader = StaxUtil.createXMLStreamReader(hierarchyInfo);
                while (xmlReader.hasNext() && StaxUtil.moveToElement(xmlReader, "level")) {
                    ChildElementIterator childElementIterator = new ChildElementIterator(xmlReader);
                    while (childElementIterator.next()) {
                        if (xmlReader.getLocalName().equals("externalName")) {
                            externalNames.add(xmlReader.getElementText());
                            continue;
                        }
                        StaxUtil.skipElement(xmlReader);
                    }
                    if (StaxUtil.testOnEndElement(xmlReader, "level")) continue;
                    StaxUtil.moveToEndElement(xmlReader, "level");
                }
                xmlReader.close();
            }
            catch (XMLStreamException ex) {
                throw new XQERuntimeException(ex);
            }
            boolean levelIndexAdjustment = false;
            if (levelMembers.size() + 1 == externalNames.size()) {
                levelIndexAdjustment = true;
            }
            boolean bl = false;
            while (var7_15 < externalNames.size()) {
                void levelMembersIndex = var7_15 - levelIndexAdjustment;
                if (levelMembersIndex >= 0 && levelMembersIndex < levelMembers.size()) {
                    MFWMeasureLevel measureLevel = new MFWMeasureLevel(this, (int)(var7_15 - levelIndexAdjustment), (String)externalNames.get((int)var7_15), (List)levelMembers.get((int)levelMembersIndex));
                    queryLevels.add(measureLevel);
                }
                ++var7_15;
            }
            queryLevels = Collections.unmodifiableList(queryLevels);
        } else if (this.isDMR()) {
            queryLevels = new ArrayList(levelMembers.size());
            int levelOrdinal = -1;
            for (List list : levelMembers) {
                MFWMeasureLevel measureLevel = new MFWMeasureLevel(this, ++levelOrdinal, null, list);
                queryLevels.add(measureLevel);
            }
            queryLevels = Collections.unmodifiableList(queryLevels);
        } else {
            List<LevelRecord> levelRecords = this.queryLevelRecords();
            if (levelRecords == null) {
                queryLevels = Collections.unmodifiableList(new ArrayList());
            } else {
                queryLevels = new ArrayList(levelRecords.size());
                List measureLevelMembers = null;
                for (LevelRecord levelRecord : levelRecords) {
                    if (!levelMembers.isEmpty()) {
                        measureLevelMembers = (List)levelMembers.get(levelRecord.getLevelNumber());
                    }
                    MFWMeasureLevel measureLevel = new MFWMeasureLevel(this, levelRecord.getLevelNumber(), levelRecord.getUniqueName(), measureLevelMembers);
                    queryLevels.add(measureLevel);
                }
                queryLevels = Collections.unmodifiableList(queryLevels);
            }
        }
        this.setLevels(queryLevels);
    }

    private synchronized void setLevels(List<ILevel> queryLevels) {
        if (this.levels == null) {
            this.levels = queryLevels;
        }
    }

    @Override
    public String getCaption() {
        if (this.caption == null) {
            this.caption = this.getMfwMeasureDimension().getCaption();
        }
        return this.caption;
    }

    @Override
    public boolean isAccessible() {
        if (this.isAccessible == null) {
            this.isAccessible = this.getMfwMeasureDimension().isAccessible();
        }
        return this.isAccessible;
    }
}

