/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.ValueMethodNotImplementedException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.xml.XMLWriter;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestGateway;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.CompareToBuilder;

abstract class MFWMetadata
implements IMetadata {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(MFWMetadata.class);
    static final long serialVersionUID = 7647274105530911872L;
    public static final String MULTIPART_NAME_DELIMITER = ".";
    public static final double UNKNOWN_ORDER_OF_MAGNITUDE = -1.0;
    private static final String ALLOWED_JAVA_IDENTIFIER_CHARS = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    protected String caption = null;
    protected String description = null;
    protected String screenTip = null;
    protected final MFWMetadataConnection connection;
    protected final MFWMultiRequestHandle[] handles;
    Map<String, Object> dynamicProperties = null;
    protected IMetadata parentObject = null;
    protected IMetadata parentObjectSkipFolders = null;
    protected List<IMetadata> childMetadataObjects = null;
    protected List<IMetadata> descendantMetadataObjectsSkipFolders = null;
    private Integer hashCode = null;
    protected Boolean isAccessible = null;
    Integer shortcutIndex = null;

    MFWMetadata(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandles) {
        if (mfwConnection == null) {
            this.throwInvalidObject();
        }
        this.connection = mfwConnection;
        this.handles = mfwHandles;
        if (null != this.handles) {
            for (MFWMultiRequestHandle handle : this.handles) {
                handle.persist();
            }
        }
    }

    protected void throwInvalidObject() throws XQERuntimeException {
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "An attempt to construct invalid metadata object");
    }

    protected void throwNotImplemented() throws XQERuntimeException {
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "not implemented");
    }

    public boolean isInitialised() {
        return true;
    }

    protected void initialiseChildren() {
    }

    public String toString() {
        return this.getID();
    }

    public String toString(int depthLimit) {
        return this.getConnection().toString((IMultiRequestHandle)this.getHandle(), depthLimit);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getUniqueName() {
        return null;
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.getDynamicProperties().get(propertyName);
    }

    public MFWMultiRequestHandle[] getHandles() {
        return this.handles;
    }

    public MFWMultiRequestHandle getHandle() {
        MFWMultiRequestHandle handle = null;
        if (this.handles != null && this.handles.length >= 1) {
            handle = this.handles[this.handles.length - 1];
        }
        return handle;
    }

    @Override
    public MFWMetadataConnection getConnection() {
        return this.connection;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isMetadata() {
        return true;
    }

    public boolean isResultSet() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isDMR() {
        return false;
    }

    @Override
    public boolean isMFW() {
        return true;
    }

    public void setNull() throws ValueMethodNotImplementedException {
        throw new ValueMethodNotImplementedException(this.getClass().getName() + ".setNull()");
    }

    @Override
    public Set<String> getAvailableProperties() {
        return this.getDynamicProperties().keySet();
    }

    protected Map<String, Object> getDynamicProperties() {
        if (this.dynamicProperties == null) {
            this.dynamicProperties = this.queryDynamicProperties();
        }
        return this.dynamicProperties;
    }

    protected Map<String, Object> queryDynamicProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        MFWMultiRequestHandle node = this.getHandle();
        if (node != null && !node.isProperty()) {
            MFWMultiRequestGateway gateway = this.getConnection().getGateway();
            MFWMultiRequestHandle[] children = gateway.getAllObjectChildren(node);
            for (int i = 0; i < children.length; ++i) {
                if (children[i].isProperty()) {
                    String propertyName = children[i].getName();
                    String propertyValue = gateway.getPropertyValue(children[i]);
                    properties.put(propertyName, propertyValue);
                    continue;
                }
                MFWMultiRequestHandle childObject = children[i];
                if (childObject.getNameRID() != MFWModelRes.getInstance().RID_property) continue;
                String propertyName = null;
                String propertyValue = null;
                MFWMultiRequestHandle[] childPropNodes = gateway.getAllObjectChildren(childObject);
                for (int k = 0; k < childPropNodes.length; ++k) {
                    if (!childPropNodes[k].isProperty()) continue;
                    short rid = childPropNodes[k].getNameRID();
                    if (rid == MFWModelRes.getInstance().RID_name) {
                        propertyName = gateway.getPropertyValue(childPropNodes[k]);
                        continue;
                    }
                    if (rid != MFWModelRes.getInstance().RID__Value) continue;
                    propertyValue = gateway.getPropertyValue(childPropNodes[k]);
                }
                if (propertyName == null || propertyValue == null) continue;
                properties.put(propertyName, propertyValue);
            }
        }
        return properties;
    }

    @Override
    public List<IMetadata> getChildMetadataObjects() {
        if (this.childMetadataObjects == null) {
            List<IMetadata> children = new ArrayList();
            if (this.getHandle() != null) {
                MFWMultiRequestHandle[] childrenHandles;
                MFWMultiRequestHandle[] nodes = this.getHandles();
                ArrayList<MFWMultiRequestHandle> handleList = new ArrayList<MFWMultiRequestHandle>(nodes.length + 1);
                if (nodes.length > 0) {
                    for (int i = 0; i < nodes.length; ++i) {
                        handleList.add(nodes[i]);
                    }
                }
                handleList.add(null);
                for (MFWMultiRequestHandle childHandle : childrenHandles = this.getConnection().getGateway().getAllObjectChildren(this.getHandle())) {
                    handleList.set(handleList.size() - 1, childHandle);
                    IMetadata childObj = this.getConnection().mfwObjectToMetadataObject(handleList.toArray(new MFWMultiRequestHandle[handleList.size()]));
                    if (childObj == null) continue;
                    children.add(childObj);
                }
            }
            children = Collections.unmodifiableList(children);
            this.childMetadataObjects = children;
        }
        return this.childMetadataObjects;
    }

    @Override
    public List<IMetadata> getDescendantMetadataObjectsSkipFolders() {
        if (this.descendantMetadataObjectsSkipFolders == null) {
            ArrayList<IMetadata> folderObjects = new ArrayList<IMetadata>();
            List<IMetadata> children = this.getChildMetadataObjects();
            for (IMetadata child : children) {
                if (child.getObjectType() != MetadataType.FOLDER) continue;
                folderObjects.add(child);
            }
            if (folderObjects.isEmpty()) {
                this.descendantMetadataObjectsSkipFolders = children;
            } else {
                List<IMetadata> descendantMetadataObjects = new ArrayList();
                for (IMetadata child : children) {
                    if (child.getObjectType() != MetadataType.FOLDER) {
                        descendantMetadataObjects.add(child);
                        continue;
                    }
                    descendantMetadataObjects.addAll(((MFWMetadata)child).getDescendantMetadataObjectsSkipFolders());
                }
                descendantMetadataObjects = Collections.unmodifiableList(descendantMetadataObjects);
                this.descendantMetadataObjectsSkipFolders = descendantMetadataObjects;
            }
        }
        return this.descendantMetadataObjectsSkipFolders;
    }

    public void populateChildren() {
    }

    @Override
    public IDataType getDataType() {
        return null;
    }

    private int getInteger(String value) {
        int result = 0;
        result = value == null || "zero".equals(value) ? 0 : Integer.parseInt(value);
        return result;
    }

    protected IDataType queryDataType() {
        String mfwDatatype = this.queryValue(MFWModelRes.getInstance().RID_datatype, new short[0]);
        int precision = this.getInteger(this.queryValue(MFWModelRes.getInstance().RID_precision, new short[0]));
        int scale = this.getInteger(this.queryValue(MFWModelRes.getInstance().RID_scale, new short[0]));
        IDataType datatype = MetadataUtil.constructDatatype(this, mfwDatatype, scale, precision);
        return datatype;
    }

    @Override
    public MetadataType getObjectType() {
        throw new UnsupportedOperationException();
    }

    public void toXML(XMLWriter xmlWriter) {
    }

    public Object toJSON() {
        throw new UnsupportedOperationException();
    }

    public Object copy() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void copyFrom(IValue value) throws ValueMethodNotImplementedException {
        throw new ValueMethodNotImplementedException(this.getClass().getName() + ".copyFrom(Value dValue)");
    }

    public String makeJavaIdentifier() {
        StringBuilder sb = new StringBuilder();
        char[] chars = this.getName().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (ALLOWED_JAVA_IDENTIFIER_CHARS.indexOf(chars[i]) < 0) continue;
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    @Override
    public String getV5UniqueName() {
        return null;
    }

    public String getParentObjectUniqueName() {
        String parentUniqueName = null;
        if (this.getParentObject() != null) {
            parentUniqueName = this.getParentObject().getUniqueName();
        }
        return parentUniqueName;
    }

    public int sizeOf() {
        return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.DEFAULT);
    }

    @Override
    public boolean hasChildMetadataObjects() {
        return true;
    }

    protected String queryDescription() {
        return this.queryDescription(this.getConnection().getContentLocaleString());
    }

    protected String queryDescription(String locale) {
        String descr = null;
        for (MFWMultiRequestHandle handleDescription : this.queryHandles(MFWModelRes.getInstance().RID_description, new short[0])) {
            if (!locale.equals(this.getConnection().queryValue(handleDescription, MFWModelRes.getInstance().RID_locale, new short[0]))) continue;
            descr = this.getConnection().queryValue(handleDescription, MFWModelRes.getInstance().RID__Value, new short[0]);
            break;
        }
        return descr;
    }

    @Override
    public String getDescription() {
        return null;
    }

    protected String queryScreenTip() {
        return this.queryScreenTip(this.getConnection().getContentLocaleString());
    }

    protected String queryScreenTip(String locale) {
        String tip = null;
        for (MFWMultiRequestHandle handleDescription : this.queryHandles(MFWModelRes.getInstance().RID_screenTip, new short[0])) {
            if (!locale.equals(this.getConnection().queryValue(handleDescription, MFWModelRes.getInstance().RID_locale, new short[0]))) continue;
            tip = this.getConnection().queryValue(handleDescription, MFWModelRes.getInstance().RID__Value, new short[0]);
            break;
        }
        return tip;
    }

    @Override
    public String getScreenTip() {
        return null;
    }

    @Override
    public String getUniqueID() {
        return null;
    }

    @Override
    public String getCaption() {
        if (this.caption == null) {
            this.caption = this.queryCaption();
        }
        return this.caption;
    }

    @Override
    public void setParentMetadataObject(IMetadata parent) {
        this.parentObject = parent;
    }

    @Override
    public IMetadata getParentObject() {
        if (this.parentObject == null) {
            IMetadata parent = null;
            MFWMultiRequestHandle parentHandle = null;
            MFWMultiRequestHandle[] currentHandles = this.getHandles();
            if (currentHandles == null) {
                return null;
            }
            int handleLength = currentHandles.length;
            if (handleLength > 1) {
                int index = handleLength - 2;
                MFWMultiRequestHandle[] parentHandles = new MFWMultiRequestHandle[index + 1];
                System.arraycopy(currentHandles, 0, parentHandles, 0, index + 1);
                parent = this.getConnection().mfwObjectToMetadataObject(parentHandles);
            } else {
                parentHandle = this.getHandle().getParent();
                parent = this.getConnection().mfwObjectToMetadataObject(parentHandle);
            }
            this.parentObject = parent;
        }
        return this.parentObject;
    }

    @Override
    public IMetadata getParentObjectSkipFolders() {
        if (this.parentObjectSkipFolders == null) {
            IMetadata parent = null;
            MFWMultiRequestHandle parentHandle = null;
            MFWMultiRequestHandle[] currentHandles = this.getHandles();
            if (currentHandles == null) {
                return null;
            }
            int handleLength = currentHandles.length;
            if (handleLength > 1) {
                short parentHandleID;
                int index;
                for (index = handleLength - 2; index >= 0 && ((parentHandleID = (parentHandle = currentHandles[index]).getNameRID()) == MFWModelRes.getInstance().RID_folder || parentHandleID == MFWModelRes.getInstance().RID_hierarchyFolder || parentHandleID == MFWModelRes.getInstance().RID_measureFolder || parentHandleID == MFWModelRes.getInstance().RID_queryItemFolder); --index) {
                }
                MFWMultiRequestHandle[] parentHandles = new MFWMultiRequestHandle[index + 1];
                System.arraycopy(currentHandles, 0, parentHandles, 0, index + 1);
                parent = this.getConnection().mfwObjectToMetadataObject(parentHandles);
            } else {
                parentHandle = this.getHandle().getParent();
                short parentHandleID = parentHandle.getNameRID();
                while (parentHandleID == MFWModelRes.getInstance().RID_folder || parentHandleID == MFWModelRes.getInstance().RID_hierarchyFolder || parentHandleID == MFWModelRes.getInstance().RID_measureFolder || parentHandleID == MFWModelRes.getInstance().RID_queryItemFolder) {
                    parentHandle = parentHandle.getParent();
                    parentHandleID = parentHandle.getNameRID();
                }
                parent = this.getConnection().mfwObjectToMetadataObject(parentHandle);
            }
            this.parentObjectSkipFolders = parent;
        }
        return this.parentObjectSkipFolders;
    }

    @Override
    public int compareTo(Object other) {
        if (null == other) {
            return -1;
        }
        if (this == other) {
            return 0;
        }
        if (!(other instanceof IMetadata)) {
            return -1;
        }
        CompareToBuilder ctb = new CompareToBuilder();
        if (other instanceof MFWMetadata) {
            MFWMetadata metadata = (MFWMetadata)other;
            ctb.append((Object)this.getID(), (Object)metadata.getID());
        } else {
            IMetadata otherMetadata = (IMetadata)other;
            ctb.append((Object)this.getObjectType(), (Object)otherMetadata.getObjectType());
            ctb.append((Object)MFWMetadata.getValueForCompare(this), (Object)MFWMetadata.getValueForCompare(otherMetadata));
        }
        return ctb.toComparison();
    }

    private static String getValueForCompare(IMetadata meta) {
        if (meta instanceof IQuerySubject || meta instanceof IQueryItem || meta instanceof IRelationship) {
            return meta.getID();
        }
        return meta.getUniqueName();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof IMetadata)) {
            return false;
        }
        CompareToBuilder ctb = new CompareToBuilder();
        if (other instanceof MFWMetadata) {
            MFWMetadata metadata = (MFWMetadata)other;
            ctb.append((Object)this.getID(), (Object)metadata.getID());
        } else {
            IMetadata otherMetadata = (IMetadata)other;
            ctb.append((Object)this.getObjectType(), (Object)otherMetadata.getObjectType());
            ctb.append((Object)MFWMetadata.getValueForCompare(this), (Object)MFWMetadata.getValueForCompare(otherMetadata));
        }
        return ctb.toComparison() == 0;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.getID().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public String getID() {
        return null;
    }

    protected MFWMultiRequestHandle queryHandle(short ridChild, short ... ridDescendants) {
        return this.getConnection().queryHandle(this.getHandle(), ridChild, ridDescendants);
    }

    protected MFWMultiRequestHandle[] queryHandles(short ridChild, short ... ridDescendants) {
        return this.getConnection().queryHandles(this.getHandle(), ridChild, ridDescendants);
    }

    protected MFWMultiRequestHandle[] queryHandles(MFWMultiRequestHandle handle, short ridChild, short ... ridDescendants) {
        return this.getConnection().queryHandles(handle, ridChild, ridDescendants);
    }

    protected String queryValue(short ridChild, short ... ridDescendants) {
        return this.getConnection().queryValue(this.getHandle(), ridChild, ridDescendants);
    }

    protected String queryValue(MFWMultiRequestHandle handle, short ridChild, short ... ridDescendants) {
        return this.getConnection().queryValue(handle, ridChild, ridDescendants);
    }

    protected MFWMultiRequestHandle[] queryHandles(String query) {
        return this.getConnection().queryHandles(this.getHandle(), query);
    }

    protected String queryValue(MFWMultiRequestHandle handle, String query) {
        return this.getConnection().queryValue(handle, query);
    }

    protected String queryValue(MFWMultiRequestHandle handle) {
        return this.getConnection().queryValue(handle);
    }

    protected String queryValue() {
        return this.queryValue(this.getHandle());
    }

    protected MFWMultiRequestHandle queryHandle(String query) {
        return this.getConnection().queryHandle(this.getHandle(), query);
    }

    protected String queryValue(String query) {
        return this.getConnection().queryValue(this.getHandle(), query);
    }

    List<String> queryValues(String query) {
        return this.getConnection().queryValues(this.getHandle(), query);
    }

    List<String> queryValues(short ridChild, short ... ridDescendants) {
        return this.getConnection().queryValues(this.getHandle(), ridChild, ridDescendants);
    }

    List<IMetadata> queryMetadata(String queryString) {
        return this.getConnection().queryMetadata(this.getHandle(), queryString);
    }

    List<IMetadata> queryMetadata(short ridChild, short ... ridDescendants) {
        return this.getConnection().queryMetadata(this.getHandle(), ridChild, new short[0]);
    }

    protected String buildDefaultUniqueName() {
        return UniqueNameGenerator.createUniqueName(this.getName());
    }

    protected boolean containsShortcut() {
        for (MFWMultiRequestHandle handle : this.getHandles()) {
            if (handle.getNameRID() != MFWModelRes.getInstance().RID_shortcut) continue;
            return true;
        }
        return false;
    }

    protected IMetadata buildParentMetadataObject(short rid) {
        IMetadata ret = null;
        MFWMultiRequestHandle[] nodes = this.getHandles();
        ArrayList<MFWMultiRequestHandle> ph = null;
        for (MFWMultiRequestHandle handle = this.getHandle().getParent(); handle != null; handle = handle.getParent()) {
            if (handle.getNameRID() != rid || nodes == null || nodes.length <= 0) continue;
            ph = new ArrayList<MFWMultiRequestHandle>(nodes.length);
            for (int i = 0; i < nodes.length - 1; ++i) {
                ph.add(nodes[i]);
            }
            while (ph.size() > 0 && ((MFWMultiRequestHandle)ph.get(ph.size() - 1)).getNameRID() != rid) {
                ph.remove(ph.size() - 1);
            }
            if (ph.size() == 0) {
                ph.add(handle);
            }
            ret = this.getConnection().mfwObjectToMetadataObject(ph.toArray(new MFWMultiRequestHandle[ph.size()]));
            break;
        }
        return ret;
    }

    protected String buildID() {
        String id = this.queryValue(MFWModelRes.getInstance().RID_ID, new short[0]);
        if (this.containsShortcut()) {
            MFWMultiRequestHandle[] nodeHandles = this.getHandles();
            for (int i = nodeHandles.length - 1; i >= 0; --i) {
                if (nodeHandles[i].getNameRID() != MFWModelRes.getInstance().RID_shortcut) continue;
                MFWMultiRequestHandle handle = nodeHandles[i];
                String shortcutRefobj = this.getConnection().queryValue(handle, MFWModelRes.getInstance().RID_refobj, new short[0]);
                String shortcutID = this.getConnection().queryValue(handle, MFWModelRes.getInstance().RID_ID, new short[0]);
                id = id.replace(shortcutRefobj, shortcutID);
            }
        }
        return id;
    }

    protected String queryName(String locale) {
        String name = null;
        for (MFWMultiRequestHandle handleName : this.queryHandles(MFWModelRes.getInstance().RID_name, new short[0])) {
            if (!locale.equals(this.getConnection().queryValue(handleName, MFWModelRes.getInstance().RID_locale, new short[0]))) continue;
            name = this.getConnection().queryValue(handleName, MFWModelRes.getInstance().RID__Value, new short[0]);
            break;
        }
        return name;
    }

    protected String queryName() {
        return this.queryName(this.getConnection().getExpressionLocaleString());
    }

    protected String queryExpression() {
        String expression = this.queryValue(MFWModelRes.getInstance().RID_unTaggedExpression, new short[0]);
        if (expression == null) {
            expression = this.queryValue(MFWModelRes.getInstance().RID_expression, new short[0]);
        }
        return expression;
    }

    protected String queryCaption() {
        return this.queryName(this.getConnection().getContentLocaleString());
    }

    @Override
    public boolean isAccessible() {
        if (this.isAccessible == null) {
            Boolean bIsAccessible = true;
            if (this.getShortcutIndex() == -1) {
                String visible = this.queryValue(MFWModelRes.getInstance().RID_visible, new short[0]);
                bIsAccessible = "visibleAndAccessible".equals(visible) || "hiddenAndAccessible".equals(visible);
            } else {
                for (int i = this.getShortcutIndex(); i < this.getHandles().length && bIsAccessible.booleanValue(); ++i) {
                    String visible = this.queryValue(this.getHandles()[i], MFWModelRes.getInstance().RID_visible, new short[0]);
                    bIsAccessible = "visibleAndAccessible".equals(visible) || "hiddenAndAccessible".equals(visible);
                }
            }
            this.isAccessible = bIsAccessible;
        }
        return this.isAccessible;
    }

    @Override
    public boolean isVisible(boolean inShortcut) {
        return this.isObjectIncluded(inShortcut);
    }

    @Override
    public boolean isHidden() {
        boolean hasHiddenProperty = this.getHandle().getInfo().findChildInfo(MFWModelRes.getInstance().RID_hidden) != null;
        boolean isHidden = false;
        if (hasHiddenProperty) {
            isHidden = this.getConnection().getGateway().getObjectBooleanPropertyValue(this.getHandle(), MFWModelRes.getInstance().RID_hidden);
        }
        return isHidden;
    }

    private boolean isObjectIncluded(boolean inShortcut) {
        boolean hasVisibleProperty;
        boolean bl = hasVisibleProperty = this.getHandle().getInfo().findChildInfo(MFWModelRes.getInstance().RID_visible) != null;
        if (!hasVisibleProperty) {
            return true;
        }
        String visibility = this.getConnection().getGateway().getObjectPropertyValue(this.getHandle(), MFWModelRes.getInstance().RID_visible);
        if (visibility != null) {
            if (inShortcut) {
                return visibility.equals("visibleAndAccessible") || visibility.equals("hiddenAndAccessible");
            }
            return visibility.equals("visibleAndAccessible");
        }
        return true;
    }

    private int getShortcutIndex() {
        if (this.shortcutIndex == null) {
            Integer scIndex = -1;
            for (int h = 0; h < this.getHandles().length; ++h) {
                if (this.getHandles()[h].getNameRID() != MFWModelRes.getInstance().RID_shortcut) continue;
                scIndex = h;
                break;
            }
            this.shortcutIndex = scIndex;
        }
        return this.shortcutIndex;
    }
}

