/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqemoser.WAMoserModuleReader;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class DaaSMoserModuleReader
extends WAMoserModuleReader {
    private static final String MODULEURL = "?moduleUrl=";
    private static final String XXQE = "X-XQE";
    private static final String XXQEQUERY = "query";
    private static final String LOCATION = "location";
    private String csvToURLBasePath = MetadataService.getInstance().getCSVToParquetBasePath();

    @Override
    public String getURL(String modulePath, String xqeMoser) {
        return this.moserBasePath + MODULEURL + DaaSMoserModuleReader.encodeURIComponent(modulePath);
    }

    @Override
    public String getDecodedURL(String modulePath, String xqeMoser) {
        return this.moserBasePath + MODULEURL + modulePath;
    }

    @Override
    public void setRequestHeader(RESTClient client) {
        client.setRequestHeader(XXQE, XXQEQUERY);
    }

    @Override
    public boolean isXQEMoserWhole() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCSVToParquet(String moduleName, String module, Map<String, String> cookiesToMoser, HttpServletRequest httpServletRequest) {
        String location = null;
        this.cookies = cookiesToMoser;
        String urlStr = this.csvToURLBasePath;
        int statusCode = 0;
        RESTClient client = null;
        try {
            JsonObject jsonModule;
            client = RESTClientFactory.getInstance().getClient(httpServletRequest);
            if (DaaSMoserModuleReader.loggingEnabled()) {
                DaaSMoserModuleReader.log(LogLevel.INFO, OperationEnum.START, "start reading csv to URL location " + urlStr);
            }
            if ((statusCode = client.createResource(urlStr, "application/json", jsonModule = JsonObject.parseString((String)module, (boolean)false))) == 201 || statusCode == 304) {
                String headerLocation = client.getResponseHeader(LOCATION);
                if (headerLocation == null || headerLocation.isEmpty()) {
                    throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, moduleName);
                }
                String string = location = ";LOCAL;PARQUET;URL=" + headerLocation;
                return string;
            }
            if (statusCode >= 400) {
                throw new XQERuntimeException(XQEMessageKeys.MD_CSV2ParquetFailed, String.valueOf(statusCode), client.getErrorResponseString());
            }
            if (DaaSMoserModuleReader.loggingEnabled()) {
                DaaSMoserModuleReader.log(LogLevel.INFO, OperationEnum.END, "failed. end reading module " + urlStr + " status=" + statusCode);
            }
        }
        catch (IOException e) {
            throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, (Throwable)e, moduleName + 12 + statusCode);
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    client = null;
                }
            }
        }
        throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, moduleName + 12 + statusCode);
    }
}

