/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.builder.CompareToBuilder;

public class MoserBaseMetadata {
    protected final long objectId;
    protected IMetadata parent;
    protected String name;
    protected String label;
    protected MetadataType objectType;
    protected Locale defaultLocale;
    protected boolean bValid = true;
    protected boolean isHidden = false;
    protected boolean isTransient = false;
    protected int locationIndex = -1;

    public MoserBaseMetadata(long id, String n, int location) {
        this.objectId = id;
        this.name = n;
        this.locationIndex = location;
    }

    public MoserBaseMetadata(long id, String n, String l, int location) {
        this.objectId = id;
        this.name = n;
        this.label = l;
        this.locationIndex = location;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public void setParent(IMetadata p) {
        this.parent = p;
    }

    public String getCaption() {
        return this.name;
    }

    public String getScreenTip() {
        return null;
    }

    public MetadataType getObjectType() {
        return this.objectType;
    }

    public IMetadata getParentObject() {
        return this.parent;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale lc) {
        this.defaultLocale = lc;
    }

    protected int doCompareTo(Object obj) {
        if (this.equals(obj)) {
            return 0;
        }
        if (obj instanceof MoserBaseMetadata) {
            long otherId = ((MoserBaseMetadata)obj).objectId;
            if (this.objectId < otherId) {
                return -1;
            }
            return 1;
        }
        if (obj instanceof IMetadata && this instanceof IMetadata) {
            CompareToBuilder ctb = new CompareToBuilder();
            IMetadata otherMetadata = (IMetadata)obj;
            ctb.append((Object)this.getObjectType(), (Object)otherMetadata.getObjectType());
            ctb.append((Object)MoserBaseMetadata.getValueForCompare((IMetadata)((Object)this)), (Object)MoserBaseMetadata.getValueForCompare(otherMetadata));
            return ctb.toComparison();
        }
        return -1;
    }

    private static String getValueForCompare(IMetadata meta) {
        if (meta instanceof IQuerySubject || meta instanceof IQueryItem || meta instanceof IRelationship) {
            return meta.getID();
        }
        return meta.getUniqueName();
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }

    public String getIdForExpression() {
        return null;
    }

    public boolean isVisible(boolean inShortcut) {
        return true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MoserBaseMetadata)) {
            return false;
        }
        MoserBaseMetadata otherMD = (MoserBaseMetadata)other;
        return this.objectId == otherMD.objectId;
    }

    public int hashCode() {
        return (int)this.objectId;
    }

    public boolean isValid() {
        return this.bValid;
    }

    public void setValid(boolean b) {
        this.bValid = b;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setIsHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setIsTransient(boolean bTransient) {
        this.isTransient = bTransient;
    }

    public int getLocation() {
        return this.locationIndex;
    }

    public void setLocation(int i) {
        this.locationIndex = i;
    }

    public List<Pair> getLocations(IMetadata anchor) {
        ArrayList<Pair> rt = new ArrayList<Pair>();
        rt.add(new Pair(this.locationIndex, (Object)((IMetadata)((Object)this)).getObjectType()));
        IMetadata p = this.parent;
        while (p != null && !p.equals(anchor)) {
            Pair loc = new Pair(((MoserBaseMetadata)((Object)p)).locationIndex, (Object)p.getObjectType());
            rt.add(loc);
            p = ((MoserBaseMetadata)((Object)p)).parent;
        }
        Collections.reverse(rt);
        return rt;
    }
}

